/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.exist.collections.Collection;
import org.exist.dom.persistent.AbstractNodeSet;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.NodeSetIterator;
import org.exist.indexing.StructuralIndex;
import org.exist.numbering.NodeId;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.dom.INodeIterator;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualNodeSet
extends AbstractNodeSet {
    private static final int MAX_CHILD_COUNT_FOR_OPTIMIZE = 5;
    protected int axis = -1;
    protected NodeTest test;
    protected NodeSet context;
    protected NodeSet realSet = null;
    protected boolean realSetIsComplete = false;
    protected boolean inPredicate = false;
    protected boolean useSelfAsContext = false;
    protected int contextId = -1;
    private DocumentSet realDocumentSet = null;
    private boolean knownIsEmptyCardinality = false;
    private boolean knownHasOneCardinality = false;
    private boolean knownHasManyCardinality = false;
    protected boolean hasMany = false;
    private DBBroker broker;

    public VirtualNodeSet(DBBroker broker, int axis, NodeTest test, int contextId, NodeSet context) {
        this.isEmpty = true;
        this.hasOne = false;
        this.axis = axis;
        this.test = test;
        this.context = context;
        this.contextId = contextId;
        this.broker = broker;
    }

    @Override
    public boolean contains(NodeProxy p) {
        NodeProxy firstParent = this.getFirstParent(p, null, this.axis == 12, 0);
        return firstParent != null;
    }

    public void setInPredicate(boolean predicate) {
        this.inPredicate = predicate;
    }

    @Override
    public DocumentSet getDocumentSet() {
        if (this.realDocumentSet != null) {
            return this.realDocumentSet;
        }
        return this.context.getDocumentSet();
    }

    @Override
    public Iterator<Collection> getCollectionIterator() {
        return this.context.getCollectionIterator();
    }

    private NodeProxy getFirstParent(NodeProxy self, NodeProxy firstParent, boolean includeSelf, int recursions) {
        return this.getFirstParent(self, firstParent, includeSelf, true, recursions);
    }

    private NodeProxy getFirstParent(NodeProxy self, NodeProxy candidateFirstParent, boolean includeSelf, boolean restrictToDirectParent, int recursions) {
        NodeProxy parent;
        NodeId parentOfSelfId = self.getNodeId().getParentId();
        if (recursions == 0 && includeSelf && this.test.matches(self)) {
            if (this.axis == 5) {
                parent = this.context.get(self.getOwnerDocument(), parentOfSelfId);
                if (parent != null) {
                    self.copyContext(parent);
                    if (this.useSelfAsContext && this.inPredicate) {
                        self.addContextNode(this.contextId, self);
                    } else if (this.inPredicate) {
                        self.addContextNode(this.contextId, parent);
                    }
                    return self;
                }
            } else {
                candidateFirstParent = self;
            }
        }
        if (candidateFirstParent == null) {
            if (parentOfSelfId == NodeId.DOCUMENT_NODE) {
                return null;
            }
            candidateFirstParent = new NodeProxy(self.getOwnerDocument(), parentOfSelfId, 1);
            if (this.axis == 8 && (parent = this.context.get(candidateFirstParent.getOwnerDocument(), parentOfSelfId)) != null && this.test.matches(parent)) {
                candidateFirstParent.copyContext(parent);
                if (this.useSelfAsContext && this.inPredicate) {
                    candidateFirstParent.addContextNode(this.contextId, candidateFirstParent);
                } else if (this.inPredicate) {
                    candidateFirstParent.addContextNode(this.contextId, parent);
                }
                return candidateFirstParent;
            }
            return this.getFirstParent(candidateFirstParent, candidateFirstParent, false, restrictToDirectParent, recursions + 1);
        }
        NodeProxy parentOfSelf = this.context.get(self.getOwnerDocument(), parentOfSelfId);
        if (parentOfSelf != null && this.test.matches(self)) {
            if (this.axis != 5) {
                self = candidateFirstParent;
            }
            self.copyContext(parentOfSelf);
            if (this.useSelfAsContext && this.inPredicate) {
                self.addContextNode(this.contextId, self);
            } else if (this.inPredicate) {
                self.addContextNode(this.contextId, parentOfSelf);
            }
            return self;
        }
        if (parentOfSelfId == NodeId.DOCUMENT_NODE) {
            return null;
        }
        if (restrictToDirectParent && this.axis == 5 && recursions == 1) {
            return null;
        }
        parentOfSelf = new NodeProxy(self.getOwnerDocument(), parentOfSelfId, 1);
        return this.getFirstParent(parentOfSelf, candidateFirstParent, false, false, recursions + 1);
    }

    private void addInternal(NodeProxy p) {
        if (this.realSet == null) {
            this.realSet = new NewArrayNodeSet();
        }
        this.realSet.add(p);
        this.knownIsEmptyCardinality = true;
        this.knownHasOneCardinality = true;
        this.knownHasManyCardinality = true;
        this.isEmpty = this.realSet.isEmpty();
        this.hasOne = this.realSet.hasOne();
        this.hasMany = !this.isEmpty && !this.hasOne;
        this.realDocumentSet = null;
        this.realSetIsComplete = false;
    }

    @Override
    public NodeProxy parentWithChild(NodeProxy proxy, boolean restrictToDirectParent, boolean includeSelf, int level) {
        if (this.realSet != null && this.realSetIsComplete) {
            return this.realSet.parentWithChild(proxy, restrictToDirectParent, includeSelf, level);
        }
        NodeProxy first = this.getFirstParent(proxy, null, includeSelf, restrictToDirectParent, 0);
        if (first != null) {
            this.addInternal(first);
        }
        return first;
    }

    @Override
    public NodeProxy parentWithChild(DocumentImpl doc, NodeId nodeId, boolean restrictToDirectParent, boolean includeSelf) {
        if (this.realSet != null && this.realSetIsComplete) {
            return this.realSet.parentWithChild(doc, nodeId, restrictToDirectParent, includeSelf);
        }
        NodeProxy first = this.getFirstParent(new NodeProxy(doc, nodeId), null, includeSelf, restrictToDirectParent, 0);
        if (first != null) {
            this.addInternal(first);
        }
        return first;
    }

    private NodeSet getNodes() {
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (NodeProxy proxy : this.context) {
            if (proxy.getNodeId() == NodeId.DOCUMENT_NODE) {
                if (proxy.getOwnerDocument().getResourceType() == 1) continue;
                if ((this.axis == 12 || this.axis == 1 || this.axis == 8) && this.test.matches(proxy)) {
                    result.add(proxy);
                }
                if ((this.axis == 5 || this.axis == 6) && proxy.getOwnerDocument().getChildCount() == 1) {
                    NodeProxy p = proxy.getOwnerDocument().getFirstChildProxy();
                    if (!this.test.matches(p)) continue;
                    if (this.useSelfAsContext && this.inPredicate) {
                        p.addContextNode(this.contextId, p);
                    }
                    p.addMatches(proxy);
                    result.add(p);
                    continue;
                }
                NodeList cl = proxy.getOwnerDocument().getChildNodes();
                for (int j = 0; j < cl.getLength(); ++j) {
                    IStoredNode node = (IStoredNode)cl.item(j);
                    NodeProxy p = new NodeProxy(node);
                    if (this.test.matches(p)) {
                        if (this.useSelfAsContext && this.inPredicate) {
                            p.addContextNode(this.contextId, p);
                        }
                        result.add(p);
                    }
                    if (node.getNodeType() == 1 && (this.axis == 7 || this.axis == 8 || this.axis == 13)) {
                        NodeProxy contextNode = new NodeProxy(p);
                        contextNode.deepCopyContext(proxy);
                        try (INodeIterator domIter = this.broker.getNodeIterator(contextNode.asStoredNode());){
                            domIter.next();
                            contextNode.setMatches(proxy.getMatches());
                            this.addChildren(contextNode, result, node, domIter, 0);
                        }
                        catch (IOException ioe) {
                            LOG.warn("Unable to close iterator", (Throwable)ioe);
                        }
                    }
                    if (node.getNodeType() != 7 || this.axis != 5 && this.axis != 7 && this.axis != 8 && this.axis != 12 && this.axis != 3 && this.axis != 9 || !this.test.matches(node)) continue;
                    result.add(p);
                }
                continue;
            }
            if ((this.axis == 12 || this.axis == 1 || this.axis == 8) && this.test.matches(proxy)) {
                if (this.useSelfAsContext && this.inPredicate) {
                    proxy.addContextNode(this.contextId, proxy);
                }
                result.add(proxy);
            }
            if (this.test.getType() == 4 || this.test.getType() == 5 || this.test.getType() == 501) {
                DocumentImpl doc = proxy.getOwnerDocument();
                if (this.axis == 3) {
                    IStoredNode ps = (IStoredNode)doc.getFirstChild();
                    IStoredNode pe = (IStoredNode)((Object)doc.getDocumentElement());
                    while (ps != null && !ps.equals(pe)) {
                        if (this.test.matches(ps)) {
                            result.add(new NodeProxy(ps));
                        }
                        ps = (IStoredNode)doc.getFollowingSibling(ps);
                    }
                }
                if (this.axis == 9) {
                    IStoredNode pe = (IStoredNode)((Object)doc.getDocumentElement());
                    IStoredNode pf = (IStoredNode)doc.getFollowingSibling(pe);
                    while (pf != null) {
                        if (this.test.matches(pf)) {
                            result.add(new NodeProxy(pf));
                        }
                        pf = (IStoredNode)doc.getFollowingSibling(pf);
                    }
                }
                if (this.axis == 12 || this.axis == 1 || this.axis == 8) {
                    result.add(proxy);
                }
            }
            if (this.axis == 12) continue;
            this.addChildren(proxy, result);
        }
        this.realDocumentSet = result.getDocumentSet();
        return result;
    }

    private NodeSet getNodesFromIndex() {
        StructuralIndex index = this.broker.getStructuralIndex();
        byte type = this.test.getType() == 1 ? (byte)0 : 1;
        NodeSet result = index.scanByType(type, this.axis, this.test, this.useSelfAsContext && this.inPredicate, this.context.getDocumentSet(), this.context, this.contextId);
        this.realDocumentSet = result.getDocumentSet();
        return result;
    }

    private void addChildren(NodeProxy contextNode, NodeSet result, IStoredNode node, INodeIterator iter, int recursions) {
        if (node.hasChildNodes() || node.hasAttributes()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                IStoredNode child = (IStoredNode)iter.next();
                if (child == null) {
                    LOG.debug("CHILD == NULL; doc = " + ((DocumentImpl)node.getOwnerDocument()).getURI());
                    return;
                }
                if (node.getOwnerDocument() == null) {
                    LOG.debug("DOC == NULL");
                    return;
                }
                child.setOwnerDocument((DocumentImpl)node.getOwnerDocument());
                NodeProxy p = new NodeProxy(child);
                p.setMatches(contextNode.getMatches());
                if (this.test.matches(child) && ((this.axis == 5 || this.axis == 6) && recursions == 0 || this.axis == 7 || this.axis == 8 || this.axis == 13)) {
                    p.deepCopyContext(contextNode);
                    if (this.useSelfAsContext && this.inPredicate) {
                        p.addContextNode(this.contextId, p);
                    } else if (this.inPredicate) {
                        p.addContextNode(this.contextId, contextNode);
                    }
                    result.add(p);
                }
                this.addChildren(contextNode, result, child, iter, recursions + 1);
            }
        }
    }

    private void addChildren(NodeProxy contextNode, NodeSet result) {
        block15: {
            try {
                EmbeddedXMLStreamReader reader = (EmbeddedXMLStreamReader)this.broker.getXMLStreamReader(contextNode, true);
                int status = reader.next();
                int level = 0;
                if (status != 1) break block15;
                while (reader.hasNext()) {
                    status = reader.next();
                    if (this.axis != 6 || status == 10) {
                        switch (status) {
                            case 2: {
                                if (--level >= 0) break;
                                return;
                            }
                            case 10: {
                                AttrImpl attr;
                                if ((this.axis != 6 || level != 0) && this.axis != 13 || !this.test.matches(attr = (AttrImpl)reader.getNode())) break;
                                NodeProxy p = new NodeProxy(attr);
                                p.deepCopyContext(contextNode);
                                if (this.useSelfAsContext && this.inPredicate) {
                                    p.addContextNode(this.contextId, p);
                                } else if (this.inPredicate) {
                                    p.addContextNode(this.contextId, contextNode);
                                }
                                result.add(p);
                                break;
                            }
                            default: {
                                if ((this.axis != 5 || level != 0) && this.axis != 7 && this.axis != 8 || !this.test.matches(reader)) break;
                                NodeId nodeId = (NodeId)reader.getProperty("node-id");
                                NodeProxy p = new NodeProxy(contextNode.getOwnerDocument(), nodeId, reader.getNodeType(), reader.getCurrentPosition());
                                p.deepCopyContext(contextNode);
                                if (this.useSelfAsContext && this.inPredicate) {
                                    p.addContextNode(this.contextId, p);
                                } else if (this.inPredicate) {
                                    p.addContextNode(this.contextId, contextNode);
                                }
                                result.add(p);
                            }
                        }
                        if (status != 1) continue;
                        ++level;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
            catch (XMLStreamException e) {
                LOG.error((Object)e);
            }
        }
    }

    private final void realize() {
        if (this.realSet != null && this.realSetIsComplete) {
            return;
        }
        this.realSet = this.getNodes();
        this.knownIsEmptyCardinality = true;
        this.knownHasOneCardinality = true;
        this.knownHasManyCardinality = true;
        this.isEmpty = this.realSet.isEmpty();
        this.hasOne = this.realSet.hasOne();
        this.hasMany = this.realSet.hasMany();
        this.realSetIsComplete = true;
    }

    public void setSelfIsContext() {
        this.useSelfAsContext = true;
        if (this.realSet != null && this.realSetIsComplete) {
            for (NodeProxy p : this.realSet) {
                p.addContextNode(this.contextId, p);
            }
        }
    }

    public void setContextId(int contextId) {
        this.contextId = contextId;
    }

    @Override
    public boolean isEmpty() {
        if (this.knownIsEmptyCardinality) {
            return this.isEmpty;
        }
        return this.getLength() == 0;
    }

    @Override
    public boolean hasOne() {
        if (this.knownHasOneCardinality) {
            return this.hasOne;
        }
        return this.getLength() == 1;
    }

    @Override
    public boolean hasMany() {
        if (this.knownHasManyCardinality) {
            return this.hasMany;
        }
        return this.getLength() > 1;
    }

    @Override
    public void add(NodeProxy proxy) {
    }

    @Override
    public void addAll(NodeSet other) {
    }

    @Override
    public int getLength() {
        this.realize();
        return this.realSet.getLength();
    }

    @Override
    public int getItemType() {
        if (this.realSet != null && this.realSetIsComplete) {
            return this.realSet.getItemType();
        }
        return -1;
    }

    @Override
    public int getItemCount() {
        this.realize();
        return this.realSet.getItemCount();
    }

    @Override
    public Node item(int pos) {
        this.realize();
        return this.realSet.item(pos);
    }

    @Override
    public NodeProxy get(int pos) {
        this.realize();
        return this.realSet.get(pos);
    }

    @Override
    public Item itemAt(int pos) {
        this.realize();
        return this.realSet.itemAt(pos);
    }

    @Override
    public NodeProxy get(DocumentImpl doc, NodeId nodeId) {
        this.realize();
        return this.realSet.get(doc, nodeId);
    }

    @Override
    public NodeProxy get(NodeProxy proxy) {
        this.realize();
        return this.realSet.get(proxy);
    }

    @Override
    public NodeSetIterator iterator() {
        this.realize();
        return this.realSet.iterator();
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        this.realize();
        return this.realSet.iterate();
    }

    @Override
    public SequenceIterator unorderedIterator() throws XPathException {
        this.realize();
        return this.realSet.unorderedIterator();
    }

    @Override
    public NodeSet intersection(NodeSet other) {
        this.realize();
        return this.realSet.intersection(other);
    }

    @Override
    public NodeSet union(NodeSet other) {
        this.realize();
        return this.realSet.union(other);
    }

    @Override
    public NodeSet filterDocuments(NodeSet otherSet) {
        return this;
    }

    @Override
    public String toString() {
        if (this.realSet == null) {
            return "Virtual#unknown";
        }
        return "";
    }
}

