/*
 * Decompiled with CFR 0.152.
 */
package org.exist.examples.triggers;

import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.FilteringTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.xml.sax.InputSource;

public class ExampleTrigger
extends FilteringTrigger
implements DocumentTrigger {
    protected Logger LOG = LogManager.getLogger(this.getClass());
    private DocumentImpl doc;

    public void configure(DBBroker broker, Collection parent, Map parameters) throws TriggerException {
        super.configure(broker, parent, (Map<String, List<?>>)parameters);
        XmldbURI contentsFile = null;
        String contentsName = (String)parameters.get("contents");
        if (contentsName == null) {
            contentsFile = XmldbURI.create("contents.xml");
        } else {
            try {
                contentsFile = XmldbURI.xmldbUriFor(contentsName);
            }
            catch (URISyntaxException e) {
                throw new TriggerException(e);
            }
        }
        try {
            this.doc = parent.getDocument(broker, contentsFile);
            if (this.doc == null) {
                this.LOG.debug("creating new file for collection contents");
            }
            parent.setTriggersEnabled(false);
            IndexInfo info = parent.validateXMLResource(null, broker, contentsFile, "<?xml version=\"1.0\"?><contents></contents>");
            parent.store(null, broker, info, "<?xml version=\"1.0\"?><contents></contents>");
            this.doc = info.getDocument();
        }
        catch (Exception e) {
            throw new TriggerException(e.getMessage(), e);
        }
        finally {
            parent.setTriggersEnabled(true);
        }
    }

    private void addRecord(DBBroker broker, String xupdate) throws TriggerException {
        this.LOG.debug(xupdate);
        DefaultDocumentSet docs = new DefaultDocumentSet();
        docs.add(this.doc);
        try {
            this.getCollection().setTriggersEnabled(false);
            XUpdateProcessor processor = new XUpdateProcessor(broker, docs);
            Modification[] modifications = processor.parse(new InputSource(new StringReader(xupdate)));
            for (int i = 0; i < modifications.length; ++i) {
                modifications[i].process(null);
            }
            broker.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TriggerException(e.getMessage(), e);
        }
        finally {
            this.getCollection().setTriggersEnabled(true);
        }
    }

    @Override
    public void beforeCreateDocument(DBBroker broker, Txn transaction, XmldbURI uri) throws TriggerException {
        String xupdate = "<?xml version=\"1.0\"?><xu:modifications version=\"1.0\" xmlns:xu=\"http://www.xmldb.org/xupdate\"><xu:append select='/contents'><xu:element name='file'>" + uri.toString() + "</xu:element></xu:append></xu:modifications>";
        this.addRecord(broker, xupdate);
    }

    @Override
    public void afterCreateDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void beforeUpdateDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void afterUpdateDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void beforeMoveDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void afterMoveDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void beforeCopyDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void afterCopyDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void beforeDeleteDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
        String xupdate = "<?xml version=\"1.0\"?><xu:modifications version=\"1.0\" xmlns:xu=\"http://www.xmldb.org/xupdate\"><xu:remove select=\"//file[text()='" + document.getURI().toString() + "']\"></xu:remove></xu:modifications>";
        this.addRecord(broker, xupdate);
    }

    @Override
    public void afterDeleteDocument(DBBroker broker, Txn transaction, XmldbURI uri) throws TriggerException {
    }

    @Override
    public void beforeUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void afterUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }
}

