/*
 * Decompiled with CFR 0.152.
 */
package org.exist.examples.xmldb;

import org.exist.xmldb.EXistXPathQueryService;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class NestedExample {
    protected static final String URI = "xmldb:exist://localhost:8080/exist/xmlrpc";
    protected static final String driver = "org.exist.xmldb.DatabaseImpl";
    protected static String data = "<book><chapter><title>Title</title><para>Paragraph 1</para><para>Paragraph 2</para></chapter></book>";

    public static void main(String[] args) throws Exception {
        Class<?> cl = Class.forName(driver);
        Database database = (Database)cl.newInstance();
        database.setProperty("create-database", "true");
        DatabaseManager.registerDatabase((Database)database);
        Collection col = DatabaseManager.getCollection((String)"xmldb:exist://localhost:8080/exist/xmlrpc/db", (String)"admin", (String)"");
        XMLResource res = (XMLResource)col.createResource("test.xml", "XMLResource");
        res.setContent((Object)data);
        col.storeResource((Resource)res);
        EXistXPathQueryService service = (EXistXPathQueryService)col.getService("XPathQueryService", "1.0");
        service.setProperty("indent", "yes");
        service.setProperty("encoding", "UTF-8");
        ResourceSet set = null;
        System.out.println();
        System.out.println("Query 1");
        System.out.println("=======");
        set = service.query("/book/chapter");
        res = (XMLResource)set.getResource(0L);
        System.out.println(res.getContent());
        System.out.println();
        System.out.println("Query 2");
        System.out.println("=======");
        set = service.query(res, "title");
        res = (XMLResource)set.getResource(0L);
        System.out.println(res.getContent());
    }
}

