/*
 * Decompiled with CFR 0.152.
 */
package org.exist.examples.xmldb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.EXistXQueryService;
import org.xml.sax.ContentHandler;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.CompiledExpression;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class XQueryExample {
    protected static final String URI = "xmldb:exist://";
    protected static final String driver = "org.exist.xmldb.DatabaseImpl";

    protected static String readFile(String file) throws IOException {
        try (BufferedReader f = new BufferedReader(new FileReader(file));){
            String line;
            StringBuffer xml = new StringBuffer();
            while ((line = f.readLine()) != null) {
                xml.append(line);
            }
            String string = xml.toString();
            return string;
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                XQueryExample.usage();
            }
            Class<?> cl = Class.forName(driver);
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
            String query = XQueryExample.readFile(args[0]);
            Collection col = DatabaseManager.getCollection((String)"xmldb:exist:///db");
            EXistXQueryService service = (EXistXQueryService)col.getService("XQueryService", "1.0");
            service.setProperty("indent", "yes");
            service.setProperty("encoding", "UTF-8");
            CompiledExpression compiled = service.compile(query);
            long start = System.currentTimeMillis();
            ResourceSet result = service.execute(compiled);
            long qtime = System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            Properties outputProperties = new Properties();
            outputProperties.setProperty("indent", "yes");
            SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            serializer.setOutput(new OutputStreamWriter(System.out), outputProperties);
            for (int i = 0; i < (int)result.getSize(); ++i) {
                XMLResource resource = (XMLResource)result.getResource((long)i);
                resource.getContentAsSAX((ContentHandler)serializer);
            }
            SerializerPool.getInstance().returnObject(serializer);
            long rtime = System.currentTimeMillis() - start;
            System.out.println("hits:          " + result.getSize());
            System.out.println("query time:    " + qtime);
            System.out.println("retrieve time: " + rtime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void usage() {
        System.out.println("usage: examples.xmldb.XQueryExample xquery-file");
        System.exit(0);
    }
}

