/*
 * Decompiled with CFR 0.152.
 */
package org.exist.examples.xmlrpc;

import java.io.BufferedReader;
import java.io.FileReader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class Store {
    private static final String uri = "http://localhost:8080/exist/xmlrpc";

    protected static void usage() {
        System.out.println("usage: org.exist.examples.xmlrpc.Store xmlFile [docName]");
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Store.usage();
        }
        String docName = args.length == 2 ? args[1] : args[0];
        XmlRpcClient client = new XmlRpcClient();
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL(uri));
        config.setBasicUserName("admin");
        config.setBasicPassword("");
        client.setConfig((XmlRpcClientConfig)config);
        StringBuilder xml = new StringBuilder();
        try (BufferedReader f = new BufferedReader(new FileReader(args[0]));){
            String line;
            while ((line = f.readLine()) != null) {
                xml.append(line);
            }
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(xml.toString());
        params.add(docName);
        params.add(0);
        Boolean result = (Boolean)client.execute("parse", params);
        if (result.booleanValue()) {
            System.out.println("document stored.");
        } else {
            System.out.println("could not store document.");
        }
    }
}

