/*
 * Decompiled with CFR 0.152.
 */
package org.exist.examples.xmlrpc;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.exist.xmldb.XmldbURI;

public class StoreChunked {
    public static void main(String[] args) {
        String xmldbUri = "xmldb:exist://guest:guest@localhost:8080/exist/xmlrpc/db/admin2.png";
        XmldbURI uri = XmldbURI.create("xmldb:exist://guest:guest@localhost:8080/exist/xmlrpc/db/admin2.png");
        String url = "http://guest:guest@" + uri.getAuthority() + uri.getContext();
        String path = uri.getCollectionPath();
        String filename = "webapp/resources/admin2.png";
        try (FileInputStream fis = new FileInputStream("webapp/resources/admin2.png");){
            XmlRpcClient client = new XmlRpcClient();
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL(url));
            config.setBasicUserName("guest");
            config.setBasicPassword("guest");
            client.setConfig((XmlRpcClientConfig)config);
            ArrayList<Object> params = new ArrayList<Object>();
            String handle = null;
            byte[] buf = new byte[4096];
            int len = -1;
            while ((len = ((InputStream)fis).read(buf)) > 0) {
                params.clear();
                if (handle != null) {
                    params.add(handle);
                }
                params.add(buf);
                params.add(len);
                handle = (String)client.execute("upload", params);
            }
            params.clear();
            params.add(handle);
            params.add(path);
            params.add(true);
            params.add("image/png");
            Boolean result = (Boolean)client.execute("parseLocal", params);
            if (result.booleanValue()) {
                System.out.println("document stored.");
            } else {
                System.out.println("could not store document.");
            }
        }
        catch (IOException | XmlRpcException ex) {
            ex.printStackTrace();
        }
    }
}

