/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.TextImpl;
import org.exist.indexing.StreamListener;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.storage.dom.INodeIterator;
import org.exist.storage.txn.Txn;

public class IndexUtils {
    protected static final Logger LOG = LogManager.getLogger(IndexUtils.class);

    public static void scanNode(DBBroker broker, Txn transaction, IStoredNode node, StreamListener listener) {
        try (INodeIterator iterator = broker.getNodeIterator(node);){
            iterator.next();
            NodePath path = node.getPath();
            IndexUtils.scanNode(transaction, iterator, node, listener, path);
        }
        catch (IOException ioe) {
            LOG.warn("Unable to close iterator", (Throwable)ioe);
        }
    }

    private static void scanNode(Txn transaction, INodeIterator iterator, IStoredNode node, StreamListener listener, NodePath currentPath) {
        switch (node.getNodeType()) {
            case 1: {
                if (listener != null) {
                    listener.startElement(transaction, (ElementImpl)node, currentPath);
                }
                if (node.hasChildNodes() || node.hasAttributes()) {
                    int childCount = node.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        IStoredNode child = (IStoredNode)iterator.next();
                        if (child.getNodeType() == 1) {
                            currentPath.addComponent(child.getQName());
                        }
                        IndexUtils.scanNode(transaction, iterator, child, listener, currentPath);
                        if (child.getNodeType() != 1) continue;
                        currentPath.removeLastComponent();
                    }
                }
                if (listener == null) break;
                listener.endElement(transaction, (ElementImpl)node, currentPath);
                break;
            }
            case 3: {
                if (listener == null) break;
                listener.characters(transaction, (TextImpl)node, currentPath);
                break;
            }
            case 2: {
                if (listener == null) break;
                listener.attribute(transaction, (AttrImpl)node, currentPath);
            }
        }
    }
}

