/*
 * Decompiled with CFR 0.152.
 */
package org.exist.installer;

import org.exist.security.Account;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class Setup {
    private static final String DRIVER = "org.exist.xmldb.DatabaseImpl";
    private static final String URI = "xmldb:exist:///db";

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("No password specified. Admin password will be empty.");
            return;
        }
        String passwd = null;
        if (args[0].startsWith("pass:")) {
            passwd = args[0].substring(5);
        }
        System.setProperty("exist.autodeploy", "off");
        Setup.initDb(passwd);
        Setup.shutdown(passwd);
    }

    private static void initDb(String adminPass) {
        System.out.println("--- Starting embedded database instance ---");
        try {
            Class<?> cl = Class.forName(DRIVER);
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
            Collection root = DatabaseManager.getCollection((String)URI, (String)"admin", null);
            if (adminPass != null) {
                UserManagementService service = (UserManagementService)root.getService("UserManagementService", "1.0");
                Account admin = service.getAccount("admin");
                admin.setPassword(adminPass);
                System.out.println("Setting admin user password...");
                service.updateAccount(admin);
            }
        }
        catch (Exception e) {
            System.err.println("Caught an exception while initializing db: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void shutdown(String adminPass) {
        System.out.println("--- Initialization complete. Shutdown embedded database instance ---");
        try {
            Collection root = DatabaseManager.getCollection((String)URI, (String)"admin", (String)adminPass);
            DatabaseInstanceManager manager = (DatabaseInstanceManager)root.getService("DatabaseInstanceManager", "1.0");
            manager.shutdown();
        }
        catch (XMLDBException e) {
            System.err.println("Caught an exception while initializing db: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

