/*
 * Decompiled with CFR 0.152.
 */
package org.exist.launcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.xml.transform.TransformerException;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.SystemUtils;
import org.exist.launcher.ConfigurationUtility;
import org.exist.launcher.LauncherWrapper;
import org.exist.util.Configuration;
import org.exist.util.ConfigurationHelper;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.FileUtils;

public class ConfigurationDialog
extends JDialog {
    private final Consumer<Boolean> callback;
    private boolean changed = false;
    private boolean dataDirChanged = false;
    private boolean jettyConfigChanged = false;
    private boolean beforeStart = false;
    private JButton btnCancel;
    private JPanel btnPanel;
    private JButton btnSave;
    private JButton btnSelectDir;
    private JSpinner cacheSize;
    private JSpinner collectionCache;
    private JTextField dataDir;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel lbCurrentUsage;
    private JLabel lbExistLogo;
    private JLabel lbStartupMsg;
    private JLabel lbStartupWarn;
    private JSpinner maxMemory;
    private JSpinner minMemory;
    private JSpinner httpPort;
    private JSpinner sslPort;

    public ConfigurationDialog(Consumer<Boolean> callback) {
        this.setModal(true);
        this.setTitle("eXist-db System Configuration");
        this.initComponents();
        this.callback = callback;
        PropertiesConfiguration vmProperties = LauncherWrapper.getVMProperties();
        int maxMemProp = vmProperties.getInt("memory.max", 1024);
        this.maxMemory.setValue(maxMemProp);
        int minMemProp = vmProperties.getInt("memory.min", 64);
        this.minMemory.setValue(minMemProp);
        try {
            Configuration existConfig = new Configuration();
            int cacheSizeProp = existConfig.getInteger("db-connection.cache-size");
            this.cacheSize.setValue(cacheSizeProp);
            int collectionCacheProp = existConfig.getInteger("db-connection.collection-cache-mem");
            this.collectionCache.setValue(collectionCacheProp / 1024 / 1024);
            Path dir = (Path)existConfig.getProperty("db-connection.data-dir");
            this.dataDir.setText(dir.toAbsolutePath().toString());
            Map<String, Integer> ports = ConfigurationUtility.getJettyPorts();
            if (ports.containsKey("jetty.port")) {
                this.httpPort.setValue(ports.get("jetty.port"));
            }
            if (ports.containsKey("jetty.ssl.port")) {
                this.sslPort.setValue(ports.get("jetty.ssl.port"));
            }
        }
        catch (DatabaseConfigurationException ex) {
            Logger.getLogger(ConfigurationDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.checkCacheBoundaries();
        this.changed = false;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width - this.getWidth() - 40, 60);
        this.setAlwaysOnTop(true);
    }

    public void open(boolean firstStart) {
        if (firstStart) {
            this.beforeStart = true;
            this.dataDirChanged = true;
            this.btnCancel.setVisible(false);
            this.lbStartupMsg.setVisible(true);
            this.lbStartupWarn.setVisible(true);
            if (SystemUtils.IS_OS_MAC_OSX) {
                Path dir = Paths.get(System.getProperty("user.home"), new String[0]).resolve("Library/Application Support/org.exist");
                this.dataDir.setText(dir.toAbsolutePath().toString());
            }
        } else {
            this.lbStartupMsg.setVisible(false);
            this.lbStartupWarn.setVisible(false);
        }
        this.setVisible(true);
        this.requestFocus();
    }

    private void initComponents() {
        this.lbExistLogo = new JLabel();
        this.jLabel1 = new JLabel();
        this.minMemory = new JSpinner();
        this.jLabel2 = new JLabel();
        this.maxMemory = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.cacheSize = new JSpinner();
        this.jLabel7 = new JLabel();
        this.collectionCache = new JSpinner();
        this.jLabel8 = new JLabel();
        this.lbCurrentUsage = new JLabel();
        this.lbStartupMsg = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.dataDir = new JTextField();
        this.jLabel11 = new JLabel();
        this.btnPanel = new JPanel();
        this.btnCancel = new JButton();
        this.btnSave = new JButton();
        this.btnSelectDir = new JButton();
        this.lbStartupWarn = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.httpPort = new JSpinner();
        this.sslPort = new JSpinner();
        this.setTitle("eXist-db Configuration");
        this.getContentPane().setLayout(new GridBagLayout());
        this.lbExistLogo.setIcon(new ImageIcon(this.getClass().getResource("/org/exist/client/icons/x.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.insets = new Insets(0, 16, 0, 6);
        this.getContentPane().add((Component)this.lbExistLogo, gridBagConstraints);
        this.jLabel1.setText("Min Memory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.minMemory.setModel(new SpinnerNumberModel(64, 64, 256, 64));
        this.minMemory.addChangeListener(this::minMemoryStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.minMemory, gridBagConstraints);
        this.jLabel2.setText("Max Memory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.maxMemory.setModel(new SpinnerNumberModel((Number)1024, Integer.valueOf(512), null, (Number)64));
        this.maxMemory.addChangeListener(this::maxMemoryChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.maxMemory, gridBagConstraints);
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 1));
        this.jLabel3.setText("Java Memory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(26, 22, 16, 0);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont(this.jLabel4.getFont().getStyle() | 1));
        this.jLabel4.setText("Caches");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(26, 22, 16, 0);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("General Cache");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.cacheSize.setModel(new SpinnerNumberModel(128, 48, 256, 16));
        this.cacheSize.addChangeListener(this::cacheSizeStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.cacheSize, gridBagConstraints);
        this.jLabel7.setText("Collection Cache");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        this.collectionCache.setModel(new SpinnerNumberModel(48, 48, 256, 16));
        this.collectionCache.addChangeListener(this::collectionCacheStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.collectionCache, gridBagConstraints);
        this.jLabel8.setText("<html><p>Memory settings only become effective after restart and only apply when eXist is started via the system tray launcher.</p></html>");
        this.jLabel8.setPreferredSize(new Dimension(280, 48));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 13, 0, 22);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.lbCurrentUsage.setText("Memory usage (in MB):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 22, 12, 0);
        this.getContentPane().add((Component)this.lbCurrentUsage, gridBagConstraints);
        this.lbStartupMsg.setFont(this.lbStartupMsg.getFont().deriveFont(this.lbStartupMsg.getFont().getStyle() & 0xFFFFFFFE));
        this.lbStartupMsg.setText("<html><p>It seems you are starting eXist for the first time. Please configure your memory settings below.</p></html>");
        this.lbStartupMsg.setMinimumSize(new Dimension(60, 64));
        this.lbStartupMsg.setPreferredSize(new Dimension(300, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(27, 22, 0, 22);
        this.getContentPane().add((Component)this.lbStartupMsg, gridBagConstraints);
        this.jLabel9.setText("<html><p>Changing the data directory will create an empty database in the new location (unless there's already data in it).</p></html>");
        this.jLabel9.setPreferredSize(new Dimension(280, 48));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 13, 0, 22);
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setFont(this.jLabel10.getFont().deriveFont(this.jLabel10.getFont().getStyle() | 1));
        this.jLabel10.setText("Data Directory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(26, 22, 16, 0);
        this.getContentPane().add((Component)this.jLabel10, gridBagConstraints);
        this.dataDir.setMinimumSize(new Dimension(180, 28));
        this.dataDir.setPreferredSize(new Dimension(180, 28));
        this.dataDir.addActionListener(this::dataDirActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.getContentPane().add((Component)this.dataDir, gridBagConstraints);
        this.jLabel11.setText("<html><p>Total cache size should not exceed 1/3 of max memory unless you have more than 2GB available. These sizes are in megabytes.</p></html>");
        this.jLabel11.setPreferredSize(new Dimension(280, 48));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 13, 0, 22);
        this.getContentPane().add((Component)this.jLabel11, gridBagConstraints);
        this.btnPanel.setLayout(new FlowLayout(2));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this::btnCancelActionPerformed);
        this.btnPanel.add(this.btnCancel);
        this.btnSave.setText("Save");
        this.btnSave.addActionListener(this::saveConfig);
        this.btnPanel.add(this.btnSave);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(36, 13, 8, 0);
        this.getContentPane().add((Component)this.btnPanel, gridBagConstraints);
        this.btnSelectDir.setText("Select");
        this.btnSelectDir.addActionListener(this::btnSelectDirActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        this.getContentPane().add((Component)this.btnSelectDir, gridBagConstraints);
        this.lbStartupWarn.setFont(new Font("Lucida Grande", 1, 13));
        this.lbStartupWarn.setForeground(new Color(255, 0, 0));
        this.lbStartupWarn.setText("<html><p>After startup, use dashboard or Java client to set a password for admin (empty by default).</p></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 22, 12, 22);
        this.getContentPane().add((Component)this.lbStartupWarn, gridBagConstraints);
        this.jLabel12.setText("Jetty Ports");
        this.jLabel12.setFont(this.jLabel12.getFont().deriveFont(this.jLabel12.getFont().getStyle() | 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(26, 22, 16, 0);
        this.getContentPane().add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel13.setText("HTTP Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.getContentPane().add((Component)this.jLabel13, gridBagConstraints);
        this.httpPort.setModel(new SpinnerNumberModel(8080, 80, 100000, 1));
        this.httpPort.setEditor(new JSpinner.NumberEditor(this.httpPort, "#"));
        this.httpPort.addChangeListener(this::jettyConfigChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.httpPort, gridBagConstraints);
        this.jLabel14.setText("SSL Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.getContentPane().add((Component)this.jLabel14, gridBagConstraints);
        this.sslPort.setModel(new SpinnerNumberModel(8443, 80, 100000, 1));
        this.sslPort.setEditor(new JSpinner.NumberEditor(this.sslPort, "#"));
        this.sslPort.addChangeListener(this::jettyConfigChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.sslPort, gridBagConstraints);
        this.jLabel15.setText("<html><p>Set the ports used by the integrated web server. Please make sure those ports are not used by other processes.</p></html>");
        this.jLabel15.setPreferredSize(new Dimension(280, 48));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 13, 0, 22);
        this.getContentPane().add((Component)this.jLabel15, gridBagConstraints);
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void maxMemoryChanged(ChangeEvent evt) {
        this.checkCacheBoundaries();
        this.changed = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkDataDir() {
        Path dir;
        block25: {
            if (!this.dataDirChanged) {
                return true;
            }
            dir = Paths.get(this.dataDir.getText(), new String[0]);
            if (Files.exists(dir, new LinkOption[0])) {
                try (Stream<Path> fileStream = Files.list(dir);){
                    List files = fileStream.filter(p -> FileUtils.fileName(p).endsWith(".dbx")).collect(Collectors.toList());
                    if (!files.isEmpty()) {
                        int r = JOptionPane.showConfirmDialog(this, "The specified data directory already contains data. Do you want to use this? Data will not be removed.", "Confirm Data Directory", 2, 2);
                        if (r == 0) {
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    break block25;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Failed to enumerate data files from directory: " + dir.toAbsolutePath().toString(), "Failed to enumerate data files", 0);
                    return false;
                }
            }
            int r = JOptionPane.showConfirmDialog(this, "The specified data directory does not exist. Do you want to create it?", "Create data directory?", 0, 3);
            if (r != 0) return false;
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                return true;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Failed to create data directory: " + dir.toAbsolutePath().toString(), "Failed to create directory", 0);
                return false;
            }
        }
        if (Files.isWritable(dir)) return true;
        JOptionPane.showMessageDialog(this, "The specified data directory is not writable. Please choose a different one.", "Data Directory Error", 0);
        return false;
    }

    private void saveConfig(ActionEvent evt) {
        if (!(this.beforeStart || this.changed || this.dataDirChanged || this.jettyConfigChanged)) {
            this.setVisible(false);
            return;
        }
        if (!this.checkDataDir()) {
            return;
        }
        try {
            int r;
            Properties properties = new Properties();
            properties.setProperty("memory.max", this.maxMemory.getValue().toString());
            properties.setProperty("memory.min", this.minMemory.getValue().toString());
            ConfigurationUtility.saveProperties(properties);
            ConfigurationUtility.saveWrapperProperties(properties);
            properties.clear();
            properties.setProperty("cacheSize", this.cacheSize.getValue().toString());
            properties.setProperty("collectionCache", this.collectionCache.getValue().toString());
            properties.setProperty("dataDir", this.dataDir.getText());
            ConfigurationUtility.saveConfiguration("conf.xml", "conf.xsl", properties);
            if (this.jettyConfigChanged) {
                properties.clear();
                properties.setProperty("port", this.httpPort.getValue().toString());
                properties.setProperty("port.ssl", this.sslPort.getValue().toString());
                ConfigurationUtility.saveConfiguration("tools/jetty/etc/jetty-ssl.xml", "jetty.xsl", properties);
                ConfigurationUtility.saveConfiguration("tools/jetty/etc/jetty-http.xml", "jetty.xsl", properties);
            }
            if (this.beforeStart) {
                this.beforeStart = false;
                this.btnCancel.setVisible(true);
                this.setVisible(false);
                this.callback.accept(true);
            } else if ((this.changed || this.dataDirChanged || this.jettyConfigChanged) && (r = JOptionPane.showConfirmDialog(this, "Database needs to be restarted to apply the new settings.", "Confirm restart", 0, 2)) == 0) {
                this.changed = false;
                this.dataDirChanged = false;
                this.setVisible(false);
                this.callback.accept(true);
            }
        }
        catch (IOException | ConfigurationException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Failed to save Java settings: " + e.getMessage(), "Save Error", 0);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Failed to save configuration: " + e.getMessage() + " at " + e.getLocationAsString(), "Save Error", 0);
        }
    }

    private void cacheSizeStateChanged(ChangeEvent evt) {
        this.changed = true;
        this.checkCacheBoundaries();
    }

    private void collectionCacheStateChanged(ChangeEvent evt) {
        this.changed = true;
    }

    private void minMemoryStateChanged(ChangeEvent evt) {
        this.changed = true;
    }

    private void dataDirActionPerformed(ActionEvent evt) {
        this.dataDirChanged = true;
    }

    private void jettyConfigChanged(ChangeEvent evt) {
        this.jettyConfigChanged = true;
    }

    private void btnSelectDirActionPerformed(ActionEvent evt) {
        Optional<Path> currentDir = Optional.ofNullable(this.dataDir.getText()).map(d -> Optional.of(Paths.get(d, new String[0]))).filter(md -> md.map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false)).orElse(ConfigurationHelper.getExistHome());
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        currentDir.map(Path::toFile).ifPresent(chooser::setCurrentDirectory);
        if (chooser.showDialog(this, "Choose Data Directory") == 0) {
            this.dataDir.setText(chooser.getSelectedFile().getAbsolutePath());
            this.dataDirChanged = true;
        }
    }

    private void checkCacheBoundaries() {
        this.showCurrentMem();
        int max = (Integer)this.maxMemory.getValue();
        SpinnerNumberModel cacheModel = (SpinnerNumberModel)this.cacheSize.getModel();
        SpinnerNumberModel collectionCacheModel = (SpinnerNumberModel)this.collectionCache.getModel();
        int maxCache = max <= 2048 ? max / 3 : max / 2;
        cacheModel.setMaximum(Integer.valueOf(maxCache - 48));
        if (((Integer)cacheModel.getMaximum()).compareTo((Integer)cacheModel.getValue()) < 0) {
            cacheModel.setValue(cacheModel.getMaximum());
        }
        collectionCacheModel.setMaximum(Integer.valueOf(maxCache - (Integer)cacheModel.getValue()));
        if (((Integer)collectionCacheModel.getMaximum()).compareTo((Integer)collectionCacheModel.getValue()) < 0) {
            collectionCacheModel.setValue(collectionCacheModel.getMaximum());
        }
    }

    private void showCurrentMem() {
        this.lbCurrentUsage.setText("Memory usage: " + Runtime.getRuntime().freeMemory() / 1024L / 1024L + " free/" + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " max mb");
    }
}

