/*
 * Decompiled with CFR 0.152.
 */
package org.exist.launcher;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.lang3.SystemUtils;
import org.exist.EXistException;
import org.exist.jetty.JettyStart;
import org.exist.launcher.ConfigurationDialog;
import org.exist.launcher.ConfigurationUtility;
import org.exist.launcher.LauncherWrapper;
import org.exist.launcher.ServiceManager;
import org.exist.launcher.SplashScreen;
import org.exist.launcher.UtilityPanel;
import org.exist.repo.ExistRepository;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.ConfigurationHelper;
import org.exist.util.FileUtils;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class Launcher
extends Observable
implements Observer {
    private MenuItem stopItem;
    private MenuItem startItem;
    private MenuItem dashboardItem;
    private MenuItem eXideItem;
    private MenuItem monexItem;
    private MenuItem installServiceItem;
    private MenuItem uninstallServiceItem;
    private MenuItem showServices;
    private MenuItem quitItem;
    public static final String PACKAGE_DASHBOARD = "http://exist-db.org/apps/dashboard";
    public static final String PACKAGE_EXIDE = "http://exist-db.org/apps/eXide";
    public static final String PACKAGE_MONEX = "http://exist-db.org/apps/monex";
    private final ReentrantLock serviceLock = new ReentrantLock();
    private ServiceManager serviceManager;
    private SystemTray tray = null;
    private TrayIcon trayIcon = null;
    private SplashScreen splash;
    private Optional<JettyStart> jetty = Optional.empty();
    private final Path jettyConfig;
    private UtilityPanel utilityPanel;
    private ConfigurationDialog configDialog;
    private boolean isInstallingService = false;

    public static void main(String[] args) {
        String os = System.getProperty("os.name", "");
        if (!"Linux".equals(os)) {
            String nativeLF = UIManager.getSystemLookAndFeelClassName();
            try {
                UIManager.setLookAndFeel(nativeLF);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SwingUtilities.invokeLater(() -> new Launcher(args));
    }

    Launcher(String[] args) {
        if (SystemTray.isSupported()) {
            this.tray = SystemTray.getSystemTray();
        }
        this.captureConsole();
        this.jettyConfig = this.getJettyConfig();
        this.serviceManager = new ServiceManager(this);
        boolean initSystemTray = true;
        if (this.isSystemTraySupported()) {
            initSystemTray = this.initSystemTray();
        }
        this.serviceManager.queryState();
        this.configDialog = new ConfigurationDialog(this::shutdown);
        this.splash = new SplashScreen(this);
        this.splash.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                Launcher.this.serviceLock.lock();
                try {
                    if (Launcher.this.serviceManager.isInstalled()) {
                        Launcher.this.splash.setStatus("eXist-db is already installed as service! Attaching to it ...");
                        Timer timer = new Timer(3000, event -> Launcher.this.splash.setVisible(false));
                        timer.setRepeats(false);
                        timer.start();
                    } else if (ConfigurationUtility.isFirstStart()) {
                        Launcher.this.splash.setVisible(false);
                        Launcher.this.configDialog.open(true);
                        Launcher.this.configDialog.requestFocus();
                    } else {
                        Launcher.this.startJetty();
                    }
                }
                finally {
                    Launcher.this.serviceLock.unlock();
                }
            }
        });
        boolean systemTrayReady = this.tray != null && initSystemTray && this.tray.getTrayIcons().length > 0;
        SwingUtilities.invokeLater(() -> {
            this.utilityPanel = new UtilityPanel(this, systemTrayReady);
        });
    }

    void startJetty() {
        new Thread(() -> {
            this.serviceLock.lock();
            try {
                if (!this.jetty.isPresent()) {
                    this.jetty = Optional.of(new JettyStart());
                    this.jetty.get().run(new String[]{this.jettyConfig.toAbsolutePath().toString()}, (Observer)this.splash);
                }
            }
            catch (Exception e) {
                this.showMessageAndExit("Error Occurred", "An error occurred during eXist-db startup. Please check console output and logs.", true);
                System.exit(1);
            }
            finally {
                this.serviceLock.unlock();
            }
        }).start();
    }

    boolean isSystemTraySupported() {
        return this.tray != null;
    }

    private boolean initSystemTray() {
        Dimension iconDim = this.tray.getTrayIconSize();
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("icon32.png"));
        }
        catch (IOException e) {
            this.showMessageAndExit("Launcher failed", "Failed to read system tray icon.", false);
        }
        this.trayIcon = new TrayIcon(image.getScaledInstance(iconDim.width, iconDim.height, 4), "eXist-db Launcher");
        final JDialog hiddenFrame = new JDialog();
        hiddenFrame.setUndecorated(true);
        hiddenFrame.setIconImage(image);
        final PopupMenu popup = this.createMenu();
        this.trayIcon.setPopupMenu(popup);
        this.trayIcon.addActionListener(actionEvent -> this.trayIcon.displayMessage(null, "Right click for menu", TrayIcon.MessageType.INFO));
        if (!SystemUtils.IS_OS_LINUX) {
            this.trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        hiddenFrame.add(popup);
                        popup.show(hiddenFrame, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
                    }
                }
            });
        }
        try {
            hiddenFrame.setResizable(false);
            hiddenFrame.pack();
            hiddenFrame.setVisible(true);
            this.tray.add(this.trayIcon);
        }
        catch (AWTException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PopupMenu createMenu() {
        PopupMenu popup = new PopupMenu();
        this.serviceLock.lock();
        try {
            this.startItem = new MenuItem("Start server");
            popup.add(this.startItem);
            this.startItem.addActionListener(actionEvent -> {
                this.serviceLock.lock();
                try {
                    if (this.serviceManager.isInstalled()) {
                        this.showTrayMessage("Starting the eXistdb service. Please wait...", TrayIcon.MessageType.INFO);
                        if (this.serviceManager.start()) {
                            this.showTrayMessage("eXistdb service started", TrayIcon.MessageType.INFO);
                        } else {
                            this.showTrayMessage("Starting eXistdb service failed", TrayIcon.MessageType.ERROR);
                        }
                    } else if (this.jetty.isPresent()) {
                        this.jetty.ifPresent(server -> {
                            if (server.isStarted()) {
                                this.showTrayMessage("Server already started", TrayIcon.MessageType.WARNING);
                            } else {
                                server.run(new String[]{this.jettyConfig.toAbsolutePath().toString()}, null);
                                if (server.isStarted()) {
                                    this.showTrayMessage("eXist-db server running on port " + server.getPrimaryPort(), TrayIcon.MessageType.INFO);
                                }
                            }
                            this.setServiceState();
                        });
                    } else {
                        this.startJetty();
                    }
                }
                finally {
                    this.serviceLock.unlock();
                }
            });
            this.stopItem = new MenuItem("Stop server");
            popup.add(this.stopItem);
            this.stopItem.addActionListener(actionEvent -> {
                this.serviceLock.lock();
                try {
                    if (this.jetty.isPresent()) {
                        this.jetty.get().shutdown();
                        this.setServiceState();
                        this.showTrayMessage("eXist-db stopped", TrayIcon.MessageType.INFO);
                    } else if (this.serviceManager.isRunning()) {
                        if (this.serviceManager.stop()) {
                            this.showTrayMessage("eXistdb service stopped", TrayIcon.MessageType.INFO);
                        } else {
                            this.showTrayMessage("Stopping eXistdb service failed", TrayIcon.MessageType.ERROR);
                        }
                    }
                }
                finally {
                    this.serviceLock.unlock();
                }
            });
            popup.addSeparator();
            MenuItem configItem = new MenuItem("System Configuration");
            popup.add(configItem);
            configItem.addActionListener(e -> EventQueue.invokeLater(() -> {
                this.configDialog.open(false);
                this.configDialog.toFront();
                this.configDialog.repaint();
                this.configDialog.requestFocus();
            }));
            String requiresRootMsg = this.serviceManager.canUseServices() ? "" : " (requires root)";
            this.installServiceItem = new MenuItem("Install as service" + requiresRootMsg);
            popup.add(this.installServiceItem);
            this.installServiceItem.setEnabled(this.serviceManager.canUseServices());
            this.installServiceItem.addActionListener(e -> SwingUtilities.invokeLater(this::installAsService));
            this.uninstallServiceItem = new MenuItem("Uninstall service" + requiresRootMsg);
            popup.add(this.uninstallServiceItem);
            this.uninstallServiceItem.setEnabled(this.serviceManager.canUseServices());
            this.uninstallServiceItem.addActionListener(e -> SwingUtilities.invokeLater(this.serviceManager::uninstall));
            if (SystemUtils.IS_OS_WINDOWS) {
                this.showServices = new MenuItem("Show services console");
                popup.add(this.showServices);
                this.showServices.addActionListener(e -> SwingUtilities.invokeLater(this.serviceManager::showServicesConsole));
            }
            popup.addSeparator();
            MenuItem toolbar = new MenuItem("Show tool window");
            popup.add(toolbar);
            toolbar.addActionListener(actionEvent -> EventQueue.invokeLater(() -> {
                this.utilityPanel.toFront();
                this.utilityPanel.setVisible(true);
            }));
            if (Desktop.isDesktopSupported()) {
                MenuItem item;
                popup.addSeparator();
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.BROWSE)) {
                    this.dashboardItem = new MenuItem("Open Dashboard");
                    popup.add(this.dashboardItem);
                    this.dashboardItem.addActionListener(actionEvent -> this.dashboard(desktop));
                    this.eXideItem = new MenuItem("Open eXide");
                    popup.add(this.eXideItem);
                    this.eXideItem.addActionListener(actionEvent -> this.eXide(desktop));
                    item = new MenuItem("Open Java Admin Client");
                    popup.add(item);
                    item.addActionListener(actionEvent -> this.client());
                    this.monexItem = new MenuItem("Open Monitoring and Profiling");
                    popup.add(this.monexItem);
                    this.monexItem.addActionListener(actionEvent -> this.monex(desktop));
                }
                if (desktop.isSupported(Desktop.Action.OPEN)) {
                    popup.addSeparator();
                    item = new MenuItem("Open exist.log");
                    popup.add(item);
                    item.addActionListener(new LogActionListener());
                }
                popup.addSeparator();
                this.quitItem = new MenuItem("Quit");
                popup.add(this.quitItem);
                this.quitItem.addActionListener(actionEvent -> {
                    if (this.serviceManager.isInstalled()) {
                        if (this.tray != null) {
                            this.tray.remove(this.trayIcon);
                        }
                        System.exit(0);
                    } else {
                        this.shutdown(false);
                    }
                });
            }
        }
        finally {
            this.serviceLock.unlock();
        }
        return popup;
    }

    private void installAsService() {
        this.serviceLock.lock();
        try {
            this.jetty.ifPresent(server -> {
                if (server.isStarted()) {
                    this.showTrayMessage("Stopping eXistdb...", TrayIcon.MessageType.INFO);
                    server.shutdown();
                }
            });
            this.jetty = Optional.empty();
            this.serviceManager.installAsService();
            this.isInstallingService = false;
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    void setServiceState() {
        this.serviceLock.lock();
        try {
            if (this.serviceManager.isInstalled()) {
                boolean serverRunning = this.serviceManager.isRunning();
                this.installServiceItem.setEnabled(false);
                this.uninstallServiceItem.setEnabled(true);
                this.quitItem.setLabel("Quit");
                this.stopItem.setEnabled(serverRunning);
                this.startItem.setEnabled(!serverRunning);
                if (this.dashboardItem != null) {
                    this.dashboardItem.setEnabled(serverRunning);
                    this.monexItem.setEnabled(serverRunning);
                    this.eXideItem.setEnabled(serverRunning);
                }
            } else {
                boolean serverRunning;
                boolean bl = serverRunning = this.jetty.isPresent() && this.jetty.get().isStarted();
                if (this.serviceManager.canUseServices() && this.installServiceItem != null && this.uninstallServiceItem != null) {
                    this.installServiceItem.setEnabled(true);
                    this.uninstallServiceItem.setEnabled(false);
                }
                this.quitItem.setLabel("Quit (and stop server)");
                this.stopItem.setEnabled(serverRunning);
                this.startItem.setEnabled(!serverRunning);
                if (this.dashboardItem != null) {
                    this.dashboardItem.setEnabled(serverRunning);
                    this.monexItem.setEnabled(serverRunning);
                    this.eXideItem.setEnabled(serverRunning);
                }
            }
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    void shutdown(boolean restart) {
        this.utilityPanel.setStatus("Shutting down ...");
        SwingUtilities.invokeLater(() -> {
            this.serviceLock.lock();
            try {
                if (this.serviceManager.isRunning() && restart) {
                    if (this.serviceManager.stop()) {
                        this.serviceManager.start();
                        this.trayIcon.displayMessage(null, "Database stopped", TrayIcon.MessageType.INFO);
                    } else {
                        this.trayIcon.displayMessage(null, "Failed to stop. Please stop service manually.", TrayIcon.MessageType.INFO);
                    }
                } else {
                    if (this.tray != null) {
                        this.tray.remove(this.trayIcon);
                    }
                    if (this.jetty.isPresent()) {
                        this.jetty.get().shutdown();
                        if (restart) {
                            LauncherWrapper wrapper = new LauncherWrapper(Launcher.class.getName());
                            wrapper.launch();
                        }
                    }
                    System.exit(0);
                }
            }
            finally {
                this.serviceLock.unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dashboard(Desktop desktop) {
        this.utilityPanel.setStatus("Opening dashboard in browser ...");
        this.serviceLock.lock();
        try {
            int port = this.jetty.isPresent() ? this.jetty.get().getPrimaryPort() : 8080;
            URI url = new URI("http://localhost:" + port + "/exist/apps/dashboard/");
            desktop.browse(url);
        }
        catch (URISyntaxException e) {
            if (this.isSystemTraySupported()) {
                this.trayIcon.displayMessage(null, "Failed to open URL", TrayIcon.MessageType.ERROR);
            }
            this.utilityPanel.setStatus("Unable to launch browser");
        }
        catch (IOException e) {
            if (this.isSystemTraySupported()) {
                this.trayIcon.displayMessage(null, "Failed to open URL", TrayIcon.MessageType.ERROR);
            }
            this.utilityPanel.setStatus("Unable to launch browser");
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eXide(Desktop desktop) {
        this.utilityPanel.setStatus("Opening dashboard in browser ...");
        this.serviceLock.lock();
        try {
            int port = this.jetty.isPresent() ? this.jetty.get().getPrimaryPort() : 8080;
            URI url = new URI("http://localhost:" + port + "/exist/apps/eXide/");
            desktop.browse(url);
        }
        catch (URISyntaxException e) {
            if (this.isSystemTraySupported()) {
                this.trayIcon.displayMessage(null, "Failed to open URL", TrayIcon.MessageType.ERROR);
            }
            this.utilityPanel.setStatus("Unable to launch browser");
        }
        catch (IOException e) {
            if (this.isSystemTraySupported()) {
                this.trayIcon.displayMessage(null, "Failed to open URL", TrayIcon.MessageType.ERROR);
            }
            this.utilityPanel.setStatus("Unable to launch browser");
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void monex(Desktop desktop) {
        this.utilityPanel.setStatus("Opening Monitoring and Profiling in browser ...");
        this.serviceLock.lock();
        try {
            int port = this.jetty.isPresent() ? this.jetty.get().getPrimaryPort() : 8080;
            URI url = new URI("http://localhost:" + port + "/exist/apps/monex/");
            desktop.browse(url);
        }
        catch (URISyntaxException e) {
            if (this.isSystemTraySupported()) {
                this.trayIcon.displayMessage(null, "Failed to open URL", TrayIcon.MessageType.ERROR);
            }
            this.utilityPanel.setStatus("Unable to launch browser");
        }
        catch (IOException e) {
            if (this.isSystemTraySupported()) {
                this.trayIcon.displayMessage(null, "Failed to open URL", TrayIcon.MessageType.ERROR);
            }
            this.utilityPanel.setStatus("Unable to launch browser");
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    void client() {
        LauncherWrapper wrapper = new LauncherWrapper("client");
        wrapper.launch();
    }

    void signalStarted() {
        if (this.isSystemTraySupported()) {
            this.startItem.setEnabled(false);
            this.stopItem.setEnabled(true);
            this.checkInstalledApps();
            this.registerObserver();
        }
        if (SystemUtils.IS_OS_WINDOWS && !this.isInstallingService && !this.serviceManager.isInstalled()) {
            this.isInstallingService = true;
            SwingUtilities.invokeLater(() -> {
                if (JOptionPane.showConfirmDialog(this.splash, "It is recommended to run eXist as a service on Windows.\nNot doing so may lead to data loss if you shut down the computer before eXist.\n\nWould you like to install the service?", "Install as Service?", 0, 3) == 0) {
                    SwingUtilities.invokeLater(() -> this.installAsService());
                }
            });
        }
    }

    void signalShutdown() {
        if (this.isSystemTraySupported()) {
            this.trayIcon.setToolTip("eXist-db server stopped");
            if (!this.isInstallingService) {
                this.startItem.setEnabled(true);
                this.stopItem.setEnabled(false);
            }
        }
    }

    private void checkInstalledApps() {
        try {
            BrokerPool pool = BrokerPool.getInstance();
            try (DBBroker broker = pool.get(Optional.of(pool.getSecurityManager().getSystemSubject()));){
                XQuery xquery = pool.getXQueryService();
                Sequence pkgs = xquery.execute(broker, "repo:list()", null);
                SequenceIterator i = pkgs.iterate();
                while (i.hasNext()) {
                    ExistRepository.Notification notification = new ExistRepository.Notification(ExistRepository.Action.INSTALL, i.nextItem().getStringValue());
                    Optional<ExistRepository> expathRepo = pool.getExpathRepo();
                    if (expathRepo.isPresent()) {
                        this.update(expathRepo.get(), notification);
                        this.utilityPanel.update(expathRepo.get(), notification);
                    }
                    expathRepo.orElseThrow(() -> new XPathException("expath repository is not available."));
                }
            }
        }
        catch (EXistException e) {
            System.err.println("Failed to check installed packages: " + e.getMessage());
            e.printStackTrace();
        }
        catch (XPathException e) {
            System.err.println("Failed to check installed packages: " + e.getMessage());
            e.printStackTrace();
        }
        catch (PermissionDeniedException e) {
            System.err.println("Failed to check installed packages: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void registerObserver() {
        try {
            BrokerPool pool = BrokerPool.getInstance();
            Optional<ExistRepository> repo = pool.getExpathRepo();
            if (repo.isPresent()) {
                repo.get().addObserver(this);
                repo.get().addObserver(this.utilityPanel);
            } else {
                System.err.println("expath repository is not available.");
            }
        }
        catch (EXistException e) {
            System.err.println("Failed to register as observer for package manager events");
            e.printStackTrace();
        }
    }

    @Override
    public void update(Observable observable, Object o) {
        ExistRepository.Notification notification = (ExistRepository.Notification)o;
        if (notification.getPackageURI().equals(PACKAGE_DASHBOARD) && this.dashboardItem != null) {
            this.dashboardItem.setEnabled(notification.getAction() == ExistRepository.Action.INSTALL);
        } else if (notification.getPackageURI().equals(PACKAGE_EXIDE) && this.eXideItem != null) {
            this.eXideItem.setEnabled(notification.getAction() == ExistRepository.Action.INSTALL);
        } else if (notification.getPackageURI().equals(PACKAGE_MONEX) && this.monexItem != null) {
            this.monexItem.setEnabled(notification.getAction() == ExistRepository.Action.INSTALL);
        }
    }

    private Path getJettyConfig() {
        String jettyProperty = Optional.ofNullable(System.getProperty("jetty.home")).orElseGet(() -> {
            Optional<Path> home = ConfigurationHelper.getExistHome();
            Path jettyHome = FileUtils.resolve(home, "tools").resolve("jetty");
            String jettyPath = jettyHome.toAbsolutePath().toString();
            System.setProperty("jetty.home", jettyPath);
            return jettyPath;
        });
        return Paths.get(jettyProperty, new String[0]).normalize().resolve("etc").resolve("standard.enabled-jetty-configs");
    }

    void showMessageAndExit(String title, String message, boolean logs) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel label = new JLabel(message);
        label.setHorizontalAlignment(0);
        panel.add((Component)label, "Center");
        if (logs) {
            JButton displayLogs = new JButton("View Log");
            displayLogs.addActionListener(new LogActionListener());
            label.setHorizontalAlignment(0);
            panel.add((Component)displayLogs, "South");
        }
        this.utilityPanel.showMessages();
        this.utilityPanel.toFront();
        this.utilityPanel.setVisible(true);
        JOptionPane.showMessageDialog(this.splash, panel, title, 2);
    }

    void showTrayMessage(String message, TrayIcon.MessageType type) {
        if (this.isSystemTraySupported()) {
            this.trayIcon.displayMessage(message, message, type);
        }
    }

    private void captureConsole() {
        System.setOut(this.createLoggingProxy(System.out));
        System.setErr(this.createLoggingProxy(System.err));
    }

    private PrintStream createLoggingProxy(final PrintStream realStream) {
        OutputStream out = new OutputStream(){

            @Override
            public void write(int i) throws IOException {
                realStream.write(i);
                String s = String.valueOf((char)i);
                Launcher.this.setChanged();
                Launcher.this.notifyObservers(s);
            }

            @Override
            public void write(byte[] bytes) throws IOException {
                realStream.write(bytes);
                String s = new String(bytes);
                Launcher.this.setChanged();
                Launcher.this.notifyObservers(s);
            }

            @Override
            public void write(byte[] bytes, int offset, int len) throws IOException {
                realStream.write(bytes, offset, len);
                String s = new String(bytes, offset, len);
                Launcher.this.setChanged();
                Launcher.this.notifyObservers(s);
            }
        };
        return new PrintStream(out);
    }

    private class LogActionListener
    implements ActionListener {
        private LogActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!Desktop.isDesktopSupported()) {
                return;
            }
            Desktop desktop = Desktop.getDesktop();
            Optional<Path> home = ConfigurationHelper.getExistHome();
            Path logFile = FileUtils.resolve(home, "webapp/WEB-INF/logs/exist.log");
            if (!Files.isReadable(logFile)) {
                Launcher.this.trayIcon.displayMessage(null, "Log file not found", TrayIcon.MessageType.ERROR);
            } else {
                try {
                    desktop.open(logFile.toFile());
                }
                catch (IOException e) {
                    Launcher.this.trayIcon.displayMessage(null, "Failed to open log file", TrayIcon.MessageType.ERROR);
                }
            }
        }
    }
}

