/*
 * Decompiled with CFR 0.152.
 */
package org.exist.launcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.exist.SystemProperties;
import org.exist.launcher.Launcher;

public class SplashScreen
extends JFrame
implements Observer,
Comparable {
    private static final long serialVersionUID = -8449133653386075548L;
    private JLabel statusLabel;
    private JLabel versionLabel;
    private Launcher launcher;

    public SplashScreen(Launcher launcher) {
        this.launcher = launcher;
        this.setUndecorated(true);
        this.setBackground(new Color(255, 255, 255, 255));
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setBackground(new Color(255, 255, 255, 255));
        URL imageURL = SplashScreen.class.getResource("logo.png");
        ImageIcon icon = new ImageIcon(imageURL, "eXist-db Logo");
        this.getContentPane().setLayout(new BorderLayout());
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(icon);
        EmptyBorder border = new EmptyBorder(20, 20, 10, 20);
        imageLabel.setBorder(border);
        this.getContentPane().add((Component)imageLabel, "North");
        StringBuilder builder = new StringBuilder();
        builder.append("Version ");
        builder.append(SystemProperties.getInstance().getSystemProperty("product-version", "unknown"));
        if (!"".equals(SystemProperties.getInstance().getSystemProperty("git-commit", ""))) {
            builder.append(" (");
            builder.append(SystemProperties.getInstance().getSystemProperty("git-commit", "(unknown Git commit ID)"));
            builder.append(")");
        }
        this.versionLabel = new JLabel(builder.toString(), 0);
        this.versionLabel.setFont(new Font(this.versionLabel.getFont().getName(), 1, 10));
        this.versionLabel.setForeground(Color.black);
        this.versionLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.versionLabel.setSize(new Dimension(icon.getIconWidth(), 60));
        this.getContentPane().add((Component)this.versionLabel, "Center");
        this.statusLabel = new JLabel("Launching ...", 0);
        this.statusLabel.setFont(new Font(this.statusLabel.getFont().getName(), 0, 16));
        this.statusLabel.setForeground(Color.black);
        this.statusLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.statusLabel.setSize(new Dimension(icon.getIconWidth(), 60));
        this.getContentPane().add((Component)this.statusLabel, "South");
        this.setSize(new Dimension(icon.getIconWidth() + 40, icon.getIconHeight() + 50));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void setStatus(String status) {
        SwingUtilities.invokeLater(() -> this.statusLabel.setText(status));
    }

    @Override
    public void update(Observable o, Object arg) {
        if ("jetty started".equals(arg)) {
            this.setStatus("Server started!");
            this.setVisible(false);
            this.launcher.signalStarted();
        } else if ("startup".equals(arg)) {
            this.setStatus("Starting eXist-db ...");
        } else if ("aborted".equals(arg)) {
            this.setVisible(false);
            this.launcher.showMessageAndExit("Startup aborted", "eXist-db detected an error during recovery. This may not be fatal, but to avoid possible damage, the db will now stop. Please consider running a consistency check via the export tool and create a backup if problems are reported. The db should come up again if you restart it.", true);
        } else if ("writable".equals(arg)) {
            this.setStatus("eXist-db is up. Waiting for web server ...");
        } else if ("error".equals(arg)) {
            this.setVisible(false);
            this.launcher.showMessageAndExit("Error Occurred", "An error occurred during startup. Please check the logs.", true);
        } else if ("shutdown".equals(arg)) {
            this.launcher.signalShutdown();
        } else {
            this.setStatus(arg.toString());
        }
    }

    public int compareTo(Object other) {
        return other == this ? 0 : -1;
    }
}

