/*
 * Decompiled with CFR 0.152.
 */
package org.exist.launcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.exist.launcher.Launcher;
import org.exist.repo.ExistRepository;

public class UtilityPanel
extends JFrame
implements Observer {
    private TextArea messages;
    private JLabel statusLabel;
    private JButton dashboardButton;
    private JButton eXideButton;

    public UtilityPanel(Launcher launcher, boolean hideOnStart) {
        Desktop desktop;
        this.setAlwaysOnTop(false);
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("icon32.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setIconImage(image);
        if (!launcher.isSystemTraySupported()) {
            this.setDefaultCloseOperation(0);
        }
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.setBackground(new Color(255, 255, 255, 255));
        JToolBar toolbar = new JToolBar();
        toolbar.setOpaque(false);
        toolbar.setBorderPainted(false);
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            this.dashboardButton = this.createButton(toolbar, "dashboard.png", "Dashboard");
            this.dashboardButton.setEnabled(false);
            this.dashboardButton.addActionListener(actionEvent -> launcher.dashboard(desktop));
            toolbar.add(this.dashboardButton);
            this.eXideButton = this.createButton(toolbar, "exide.png", "eXide");
            this.eXideButton.setEnabled(false);
            this.eXideButton.addActionListener(actionEvent -> launcher.eXide(desktop));
            toolbar.add(this.eXideButton);
        }
        JButton button = this.createButton(toolbar, "browsing.png", "Java Client");
        button.addActionListener(actionEvent -> launcher.client());
        toolbar.add(button);
        button = this.createButton(toolbar, "shutdown.png", "Quit");
        button.addActionListener(actionEvent -> launcher.shutdown(false));
        toolbar.add(button);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.getContentPane().add((Component)toolbar, c);
        this.statusLabel = new JLabel("", 0);
        this.statusLabel.setFont(new Font("Dialog", 0, 10));
        this.statusLabel.setPreferredSize(new Dimension(200, 16));
        if (!launcher.isSystemTraySupported()) {
            this.statusLabel.setText("System tray icon not supported.");
        }
        c.gridy = 1;
        this.getContentPane().add((Component)this.statusLabel, c);
        JCheckBox showMessages = new JCheckBox("Show console messages");
        showMessages.setHorizontalAlignment(2);
        showMessages.setOpaque(false);
        showMessages.addItemListener(itemEvent -> {
            boolean showMessages1;
            boolean bl = showMessages1 = itemEvent.getStateChange() == 1;
            if (showMessages1) {
                this.messages.setVisible(true);
            } else {
                this.messages.setVisible(false);
            }
            this.pack();
        });
        c.gridy = 2;
        this.getContentPane().add((Component)showMessages, c);
        Font messagesFont = new Font("Monospaced", 0, 12);
        this.messages = new TextArea();
        this.messages.setBackground(new Color(20, 20, 20, 255));
        this.messages.setPreferredSize(new Dimension(800, 200));
        this.messages.setForeground(new Color(255, 255, 255));
        this.messages.setFont(messagesFont);
        c.gridy = 3;
        c.weighty = 1.0;
        c.fill = 1;
        this.getContentPane().add((Component)this.messages, c);
        this.messages.setVisible(false);
        this.setMinimumSize(new Dimension(350, 90));
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width - this.getWidth() - 40, 60);
        launcher.addObserver(this);
        if (!hideOnStart) {
            this.setVisible(true);
            this.toFront();
        }
    }

    private JButton createButton(JToolBar toolbar, String image, String title) {
        URL imageURL = UtilityPanel.class.getResource(image);
        ImageIcon icon = new ImageIcon(imageURL, title);
        JButton button = new JButton(title, icon);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setOpaque(false);
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        return button;
    }

    protected void showMessages() {
        this.messages.setVisible(true);
        this.pack();
    }

    protected void setStatus(String message) {
        SwingUtilities.invokeLater(() -> this.statusLabel.setText(message));
    }

    @Override
    public void update(Observable observable, Object o) {
        if (o instanceof ExistRepository.Notification) {
            ExistRepository.Notification notification = (ExistRepository.Notification)o;
            if (notification.getPackageURI().equals("http://exist-db.org/apps/dashboard") && this.dashboardButton != null) {
                this.dashboardButton.setEnabled(notification.getAction() == ExistRepository.Action.INSTALL);
            } else if (notification.getPackageURI().equals("http://exist-db.org/apps/eXide") && this.eXideButton != null) {
                this.eXideButton.setEnabled(notification.getAction() == ExistRepository.Action.INSTALL);
            }
        } else {
            SwingUtilities.invokeLater(() -> this.messages.append(o.toString()));
        }
    }
}

