/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;

public class TaskStatus
implements Serializable {
    private static final long serialVersionUID = -8405783622910875893L;
    private Status status = Status.NA;
    private Date _statusChangeTime = Calendar.getInstance().getTime();
    private Object _reason = null;
    private int _percentageDone = 0;

    public TaskStatus(Status newStatus) {
        this.setStatus(newStatus);
    }

    public Object getReason() {
        return this._reason;
    }

    public void setReason(Object reason) {
        if (reason != null) {
            this._reason = reason;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status newStatus) {
        this.status = newStatus;
    }

    public String getStatusString() {
        String percentageInfo = "";
        switch (this.status) {
            case INIT: 
            case NA: 
            case NEVER_RUN: 
            case STOPPED_OK: 
            case PING_ERROR: 
            case PING_OK: 
            case PING_WAIT: {
                break;
            }
            default: {
                percentageInfo = " - " + this._percentageDone + "% done";
            }
        }
        return this.toString() + percentageInfo;
    }

    public Date getStatusChangeTime() {
        return this._statusChangeTime;
    }

    public void setStatusChangeTime() {
        this._statusChangeTime = Calendar.getInstance().getTime();
    }

    public void setPercentage(int percentage) {
        if (percentage > 0 && percentage < 101) {
            this._percentageDone = percentage;
        }
    }

    public int getPercentage() {
        return this._percentageDone;
    }

    public CompositeDataSupport getCompositeData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        CompositeDataSupport compositeData = null;
        data.put("status", (Object)this.status);
        data.put("statusChangeTime", this._statusChangeTime);
        data.put("reason", this._reason);
        data.put("percentage", this._percentageDone);
        try {
            compositeData = new CompositeDataSupport(new CompositeType("TaskStatus", "Status of the task", new String[]{"status", "statusChangeTime", "reason", "percentage"}, new String[]{"status of the task", "reason for this status", "time when the status has changed", "percentage of work"}, new SimpleType[]{SimpleType.INTEGER, SimpleType.DATE, SimpleType.OBJECTNAME, SimpleType.INTEGER}), data);
        }
        catch (OpenDataException openDataException) {
            // empty catch block
        }
        return compositeData;
    }

    public static TaskStatus getTaskStatus(CompositeDataSupport compositeData) {
        TaskStatus status = new TaskStatus((Status)((Object)compositeData.get("status")));
        status._reason = compositeData.get("reason");
        status._statusChangeTime = (Date)compositeData.get("statusChangeTime");
        status._percentageDone = (Integer)compositeData.get("percentage");
        return status;
    }

    public String toString() {
        return this.status.toString();
    }

    public static enum Status {
        NA,
        NEVER_RUN,
        INIT,
        PAUSED,
        STOPPED_OK,
        STOPPED_ERROR,
        RUNNING_CHECK,
        RUNNING_BACKUP,
        PING_OK,
        PING_ERROR,
        PING_WAIT;

    }
}

