/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.exist.util.ArgumentUtil;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentBuilder;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.Arguments;
import se.softhouse.jargo.CommandLineParser;
import se.softhouse.jargo.ParsedArguments;

public class JMXClient {
    private MBeanServerConnection connection;
    private String instance;
    private static final int DEFAULT_PORT = 1099;
    private static final int DEFAULT_WAIT_TIME = 0;
    private static final Argument<?> helpArg = Arguments.helpArgument((String)"-h", (String[])new String[]{"--help"});
    private static final Argument<String> addressArg = ((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-a", "--address"}).description("RMI address of the server")).required()).defaultValue((Object)"localhost")).build();
    private static final Argument<Integer> portArg = ((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.integerArgument((String[])new String[]{"-p", "--port"}).description("RMI port of the server")).required()).defaultValue((Object)1099)).build();
    private static final Argument<String> instanceArg = ((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-i", "--instance"}).description("The ID of the database instance to connect to")).required()).defaultValue((Object)"exist")).build();
    private static final Argument<Integer> waitArg = ((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.integerArgument((String[])new String[]{"-w", "--wait"}).description("while displaying server statistics: keep retrieving statistics, but wait the specified number of seconds between calls.")).defaultValue((Object)0)).build();
    private static final Argument<Boolean> cacheDisplayArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-c", (String[])new String[]{"--cache"}).description("displays server statistics on cache and memory usage.")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> locksDisplayArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-l", (String[])new String[]{"--locks"}).description("lock manager: display locking information on all threads currently waiting for a lock on a resource or collection. Useful to debug deadlocks. During normal operation, the list will usually be empty (means: no blocked threads).")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> dbInfoArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-d", (String[])new String[]{"--db"}).description("display general info about the db instance.")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> memoryInfoArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-m", (String[])new String[]{"--memory"}).description("display info on free and total memory. Can be combined with other parameters.")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> sanityCheckInfoArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-s", (String[])new String[]{"--report"}).description("retrieve sanity check report from the db")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> jobsInfoArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-j", (String[])new String[]{"--jobs"}).description("retrieve sanity check report from the db")).defaultValue(Boolean.valueOf(false)).build();

    public JMXClient(String instanceName) {
        this.instance = instanceName;
    }

    public void connect(String address, int port) throws IOException {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + address + ":" + port + "/jmxrmi");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] creds = new String[]{"guest", "guest"};
        env.put("jmx.remote.credentials", creds);
        JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
        this.connection = jmxc.getMBeanServerConnection();
        this.echo("Connected to MBean server.");
    }

    public void memoryStats() {
        try {
            ObjectName name = new ObjectName("java.lang:type=Memory");
            CompositeData composite = (CompositeData)this.connection.getAttribute(name, "HeapMemoryUsage");
            if (composite != null) {
                this.echo("\nMEMORY:");
                this.echo(String.format("Current heap: %,12d k        Committed memory:  %,12d k", (Long)composite.get("used") / 1024L, (Long)composite.get("committed") / 1024L));
                this.echo(String.format("Max memory:   %,12d k", (Long)composite.get("max") / 1024L));
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void instanceStats() {
        try {
            this.echo("\nINSTANCE:");
            ObjectName name = new ObjectName("org.exist.management." + this.instance + ":type=Database");
            Long memReserved = (Long)this.connection.getAttribute(name, "ReservedMem");
            this.echo(String.format("%25s: %10d k", "Reserved memory", memReserved / 1024L));
            Long memCache = (Long)this.connection.getAttribute(name, "CacheMem");
            this.echo(String.format("%25s: %10d k", "Cache memory", memCache / 1024L));
            Long memCollCache = (Long)this.connection.getAttribute(name, "CollectionCacheMem");
            this.echo(String.format("%25s: %10d k", "Collection cache memory", memCollCache / 1024L));
            String[] cols = new String[]{"MaxBrokers", "AvailableBrokers", "ActiveBrokers"};
            this.echo(String.format("\n%17s %17s %17s", cols[0], cols[1], cols[2]));
            AttributeList attrs = this.connection.getAttributes(name, cols);
            Object[] values = this.getValues(attrs);
            this.echo(String.format("%17d %17d %17d", values[0], values[1], values[2]));
            TabularData table = (TabularData)this.connection.getAttribute(name, "ActiveBrokersMap");
            if (table.size() > 0) {
                this.echo("\nCurrently active threads:");
            }
            for (CompositeData data : table.values()) {
                this.echo(String.format("\t%20s: %3d", data.get("owner"), data.get("referenceCount")));
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void cacheStats() {
        try {
            ObjectName name2 = new ObjectName("org.exist.management." + this.instance + ":type=CacheManager");
            String[] cols = new String[]{"MaxTotal", "CurrentSize"};
            AttributeList attrs = this.connection.getAttributes(name2, cols);
            Object[] values = this.getValues(attrs);
            this.echo(String.format("\nCACHE [%8d pages max. / %8d pages allocated]", values[0], values[1]));
            Set<ObjectName> beans = this.connection.queryNames(new ObjectName("org.exist.management." + this.instance + ":type=CacheManager.Cache,*"), null);
            cols = new String[]{"Type", "FileName", "Size", "Used", "Hits", "Fails"};
            this.echo(String.format("%10s %20s %10s %10s %10s %10s", cols[0], cols[1], cols[2], cols[3], cols[4], cols[5]));
            for (ObjectName name2 : beans) {
                attrs = this.connection.getAttributes(name2, cols);
                values = this.getValues(attrs);
                this.echo(String.format("%10s %20s %,10d %,10d %,10d %,10d", values[0], values[1], values[2], values[3], values[4], values[5]));
            }
            this.echo("");
            name2 = new ObjectName("org.exist.management." + this.instance + ":type=CollectionCacheManager");
            cols = new String[]{"MaxTotal", "CurrentSize"};
            attrs = this.connection.getAttributes(name2, cols);
            values = this.getValues(attrs);
            this.echo(String.format("Collection Cache: %10d k max / %10d k allocated", (Long)values[0] / 1024L, (Long)values[1] / 1024L));
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void lockTable() {
        this.echo("\nList of threads currently waiting for a lock:");
        this.echo("-----------------------------------------------");
        try {
            TabularData table = (TabularData)this.connection.getAttribute(new ObjectName("org.exist.management:type=LockManager"), "WaitingThreads");
            for (CompositeData data : table.values()) {
                Object[] writers;
                this.echo("Thread " + data.get("waitingThread"));
                this.echo(String.format("%20s: %s", "Lock type", data.get("lockType")));
                this.echo(String.format("%20s: %s", "Lock mode", data.get("lockMode")));
                this.echo(String.format("%20s: %s", "Lock id", data.get("id")));
                this.echo(String.format("%20s: %s", "Held by", Arrays.toString((String[])data.get("owner"))));
                Object[] readers = (String[])data.get("waitingForRead");
                if (readers.length > 0) {
                    this.echo(String.format("%20s: %s", "Wait for read", Arrays.toString(readers)));
                }
                if ((writers = (String[])data.get("waitingForWrite")).length <= 0) continue;
                this.echo(String.format("%20s: %s", "Wait for write", Arrays.toString(writers)));
            }
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            this.error(e);
        }
    }

    public void sanityReport() {
        this.echo("\nSanity report");
        this.echo("-----------------------------------------------");
        try {
            ObjectName name = new ObjectName("org.exist.management." + this.instance + ".tasks:type=SanityReport");
            String status = (String)this.connection.getAttribute(name, "Status");
            Date lastCheckStart = (Date)this.connection.getAttribute(name, "LastCheckStart");
            Date lastCheckEnd = (Date)this.connection.getAttribute(name, "LastCheckEnd");
            this.echo(String.format("%22s: %s", "Status", status));
            this.echo(String.format("%22s: %s", "Last check start", lastCheckStart));
            this.echo(String.format("%22s: %s", "Last check end", lastCheckEnd));
            if (lastCheckStart != null && lastCheckEnd != null) {
                this.echo(String.format("%22s: %dms", "Check took", lastCheckEnd.getTime() - lastCheckStart.getTime()));
            }
            TabularData table = (TabularData)this.connection.getAttribute(name, "Errors");
            for (CompositeData data : table.values()) {
                this.echo(String.format("%22s: %s", "Error code", data.get("errcode")));
                this.echo(String.format("%22s: %s", "Description", data.get("description")));
            }
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            this.error(e);
        }
    }

    public void jobReport() {
        this.echo("\nRunning jobs report");
        this.echo("-----------------------------------------------");
        try {
            ObjectName name = new ObjectName("org.exist.management." + this.instance + ":type=ProcessReport");
            TabularData table = (TabularData)this.connection.getAttribute(name, "RunningJobs");
            String[] cols = new String[]{"ID", "Action", "Info"};
            this.echo(String.format("%15s %30s %30s", cols[0], cols[1], cols[2]));
            for (CompositeData data : table.values()) {
                this.echo(String.format("%15s %30s %30s", data.get("id"), data.get("action"), data.get("info")));
            }
            this.echo("\nRunning queries");
            this.echo("-----------------------------------------------");
            table = (TabularData)this.connection.getAttribute(name, "RunningQueries");
            cols = new String[]{"ID", "Type", "Key", "Terminating"};
            this.echo(String.format("%10s %10s %30s %s", cols[0], cols[1], cols[2], cols[3]));
            for (CompositeData data : table.values()) {
                this.echo(String.format("%15s %15s %30s %6s", data.get("id"), data.get("sourceType"), data.get("sourceKey"), data.get("terminating")));
            }
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            this.error(e);
        }
    }

    private Object[] getValues(AttributeList attribs) {
        Object[] v = new Object[attribs.size()];
        for (int i = 0; i < attribs.size(); ++i) {
            v[i] = ((Attribute)attribs.get(i)).getValue();
        }
        return v;
    }

    private void echo(String msg) {
        System.out.println(msg);
    }

    private void error(Exception e) {
        System.err.println("ERROR: " + e.getMessage());
        e.printStackTrace();
    }

    public static void main(String[] args) {
        try {
            ParsedArguments arguments = CommandLineParser.withArguments((Argument[])new Argument[]{addressArg, portArg, instanceArg, waitArg}).andArguments(new Argument[]{cacheDisplayArg, locksDisplayArg}).andArguments(new Argument[]{dbInfoArg, memoryInfoArg, sanityCheckInfoArg, jobsInfoArg}).andArguments(new Argument[]{helpArg}).parse(args);
            JMXClient.process(arguments);
        }
        catch (ArgumentException e) {
            System.out.println(e.getMessageAndUsage());
            System.exit(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process(ParsedArguments arguments) {
        String address = (String)arguments.get(addressArg);
        int port = (Integer)Optional.ofNullable(arguments.get(portArg)).orElse(1099);
        String dbInstance = (String)arguments.get(instanceArg);
        long waitTime = ((Integer)Optional.ofNullable(arguments.get(waitArg)).orElse(0)).intValue();
        Mode mode = Mode.STATS;
        if (ArgumentUtil.getBool(arguments, cacheDisplayArg)) {
            mode = Mode.STATS;
        }
        if (ArgumentUtil.getBool(arguments, locksDisplayArg)) {
            mode = Mode.LOCKS;
        }
        boolean displayInstance = ArgumentUtil.getBool(arguments, dbInfoArg);
        boolean displayMem = ArgumentUtil.getBool(arguments, memoryInfoArg);
        boolean displayReport = ArgumentUtil.getBool(arguments, sanityCheckInfoArg);
        boolean jobReport = ArgumentUtil.getBool(arguments, jobsInfoArg);
        try {
            JMXClient stats = new JMXClient(dbInstance);
            stats.connect(address, port);
            stats.memoryStats();
            while (true) {
                switch (mode) {
                    case STATS: {
                        stats.cacheStats();
                        break;
                    }
                    case LOCKS: {
                        stats.lockTable();
                    }
                }
                if (displayInstance) {
                    stats.instanceStats();
                }
                if (displayMem) {
                    stats.memoryStats();
                }
                if (displayReport) {
                    stats.sanityReport();
                }
                if (jobReport) {
                    stats.jobReport();
                }
                if (waitTime <= 0L) break;
                JMXClient jMXClient = stats;
                synchronized (jMXClient) {
                    try {
                        stats.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        System.err.println("INTERRUPTED: " + e.getMessage());
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private static enum Mode {
        STATS,
        LOCKS;

    }
}

