/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.management.impl.Job;
import org.exist.management.impl.ProcessReportMXBean;
import org.exist.management.impl.RecentQueryHistory;
import org.exist.management.impl.RunningQuery;
import org.exist.scheduler.ScheduledJobInfo;
import org.exist.scheduler.Scheduler;
import org.exist.storage.BrokerPool;
import org.exist.storage.ProcessMonitor;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.XQueryWatchDog;

public class ProcessReport
implements ProcessReportMXBean {
    private static final Logger LOG = LogManager.getLogger(ProcessReport.class);
    private ProcessMonitor processMonitor;
    private Scheduler scheduler;

    public ProcessReport(BrokerPool pool) {
        this.processMonitor = pool.getProcessMonitor();
        this.scheduler = pool.getScheduler();
    }

    @Override
    public List<Job> getScheduledJobs() {
        ArrayList<Job> jobList = new ArrayList<Job>();
        List<ScheduledJobInfo> jobs = this.scheduler.getScheduledJobs();
        for (ScheduledJobInfo job : jobs) {
            jobList.add(new Job(job.getName(), job.getGroup(), job.getTriggerExpression()));
        }
        return jobList;
    }

    @Override
    public List<Job> getRunningJobs() {
        ProcessMonitor.JobInfo[] jobs;
        ArrayList<Job> jobList = new ArrayList<Job>();
        for (ProcessMonitor.JobInfo job : jobs = this.processMonitor.runningJobs()) {
            jobList.add(new Job(job.getThread().getName(), job.getAction(), job.getAddInfo().toString()));
        }
        return jobList;
    }

    @Override
    public List<RunningQuery> getRunningQueries() {
        XQueryWatchDog[] watchdogs;
        ArrayList<RunningQuery> queries = new ArrayList<RunningQuery>();
        for (XQueryWatchDog watchdog : watchdogs = this.processMonitor.getRunningXQueries()) {
            String requestURI = null;
            if (this.processMonitor.getTrackRequestURI()) {
                requestURI = ProcessMonitor.getRequestURI(watchdog);
            }
            queries.add(new RunningQuery(watchdog, requestURI));
        }
        return queries;
    }

    @Override
    public void killQuery(int id) {
        XQueryWatchDog[] watchdogs;
        for (XQueryWatchDog watchdog : watchdogs = this.processMonitor.getRunningXQueries()) {
            XQueryContext context = watchdog.getContext();
            if (id != context.hashCode()) continue;
            if (watchdog.isTerminating()) break;
            watchdog.kill(1000L);
            break;
        }
    }

    @Override
    public List<RecentQueryHistory> getRecentQueryHistory() {
        ArrayList<RecentQueryHistory> history = new ArrayList<RecentQueryHistory>();
        ProcessMonitor.QueryHistory[] queryHistories = this.processMonitor.getRecentQueryHistory();
        int i = 0;
        for (ProcessMonitor.QueryHistory queryHistory : queryHistories) {
            history.add(new RecentQueryHistory(i++, queryHistory));
        }
        return history;
    }

    @Override
    public void setHistoryTimespan(long time) {
        this.processMonitor.setHistoryTimespan(time);
    }

    @Override
    public long getHistoryTimespan() {
        return this.processMonitor.getHistoryTimespan();
    }

    @Override
    public void setMinTime(long time) {
        this.processMonitor.setMinTime(time);
    }

    @Override
    public long getMinTime() {
        return this.processMonitor.getMinTime();
    }

    @Override
    public void setTrackRequestURI(boolean track) {
        this.processMonitor.setTrackRequestURI(track);
    }

    @Override
    public boolean getTrackRequestURI() {
        return this.processMonitor.getTrackRequestURI();
    }

    @Override
    public void configure(long minTimeRecorded, long historyTimespan, boolean trackURI) {
        this.processMonitor.setMinTime(minTimeRecorded);
        this.processMonitor.setHistoryTimespan(historyTimespan);
        this.processMonitor.setTrackRequestURI(trackURI);
    }
}

