/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import org.exist.xquery.XQueryWatchDog;

public class RunningQuery {
    int id;
    String sourceType;
    String sourceKey;
    boolean terminating;
    String requestURI;
    String thread;
    long elapsed;

    public RunningQuery(XQueryWatchDog watchdog, String requestURI) {
        this.id = watchdog.getContext().hashCode();
        this.sourceType = watchdog.getContext().getSource().type();
        this.sourceKey = watchdog.getContext().getSource().path();
        this.terminating = watchdog.isTerminating();
        this.requestURI = requestURI;
        this.thread = watchdog.getRunningThread();
        this.elapsed = System.currentTimeMillis() - watchdog.getStartTime();
    }

    public int getId() {
        return this.id;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public boolean isTerminating() {
        return this.terminating;
    }

    public String getThread() {
        return this.thread;
    }

    public long getElapsed() {
        return this.elapsed;
    }
}

