/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.ErrorReport;
import org.exist.management.TaskStatus;
import org.exist.management.impl.Error;
import org.exist.management.impl.SanityReportMXBean;
import org.exist.source.StringSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.ConsistencyCheckTask;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;

public class SanityReport
extends NotificationBroadcasterSupport
implements SanityReportMXBean {
    private static final Logger LOG = LogManager.getLogger((String)SanityReport.class.getName());
    public static final String STATUS_OK = "OK";
    public static final String STATUS_FAIL = "FAIL";
    public static final StringSource TEST_XQUERY = new StringSource("<r>{current-dateTime()}</r>");
    public static final int PING_WAITING = -1;
    public static final int PING_ERROR = -2;
    private static List<ErrorReport> NO_ERRORS = new LinkedList<ErrorReport>();
    private int seqNum = 0;
    private Date actualCheckStart = null;
    private Date lastCheckStart = null;
    private Date lastCheckEnd = null;
    private String lastActionInfo = "nothing done";
    private long lastPingRespTime = 0L;
    private String output = "";
    private TaskStatus taskstatus = new TaskStatus(TaskStatus.Status.NEVER_RUN);
    private List<ErrorReport> errors = NO_ERRORS;
    private BrokerPool pool;

    public SanityReport(BrokerPool pool) {
        this.pool = pool;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"jmx.attribute.change"};
        String name = AttributeChangeNotification.class.getName();
        String description = "The status attribute of this MBean has changed";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, "The status attribute of this MBean has changed");
        return new MBeanNotificationInfo[]{info};
    }

    @Override
    public Date getLastCheckEnd() {
        return this.lastCheckEnd;
    }

    @Override
    public Date getLastCheckStart() {
        return this.lastCheckStart;
    }

    @Override
    public Date getActualCheckStart() {
        return this.actualCheckStart;
    }

    @Override
    public String getStatus() {
        return this.taskstatus.getStatusString();
    }

    @Override
    public String getLastActionInfo() {
        return this.lastActionInfo;
    }

    @Override
    public long getPingTime() {
        return this.lastPingRespTime;
    }

    @Override
    public List<Error> getErrors() {
        ArrayList<Error> errorList = new ArrayList<Error>();
        for (ErrorReport error : this.errors) {
            errorList.add(new Error(error.getErrcodeString(), error.getMessage()));
        }
        return errorList;
    }

    @Override
    public void triggerCheck(String output, String backup, String incremental) {
        try {
            this.output = output;
            ConsistencyCheckTask task = new ConsistencyCheckTask();
            Properties properties = this.parseParameter(output, backup, incremental);
            task.configure(this.pool.getConfiguration(), properties);
            this.pool.triggerSystemTask(task);
        }
        catch (EXistException existException) {
            this.taskstatus.setStatus(TaskStatus.Status.STOPPED_ERROR);
            ArrayList<ErrorReport> errors = new ArrayList<ErrorReport>();
            errors.add(new ErrorReport(7, existException.getMessage(), existException));
            this.taskstatus.setReason(errors);
            this.changeStatus(this.taskstatus);
            this.taskstatus.setStatusChangeTime();
            this.taskstatus.setReason(existException.toString());
            LOG.warn("Failed to trigger db sanity check: " + existException.getMessage(), (Throwable)existException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ping(boolean checkQueryEngine) {
        block21: {
            long start = System.currentTimeMillis();
            this.lastPingRespTime = -1L;
            this.lastActionInfo = "Ping";
            this.taskstatus.setStatus(TaskStatus.Status.PING_WAIT);
            try (DBBroker broker = this.pool.get(Optional.of(this.pool.getSecurityManager().getGuestSubject()));){
                if (!checkQueryEngine) break block21;
                XQuery xquery = this.pool.getXQueryService();
                XQueryPool xqPool = this.pool.getXQueryPool();
                CompiledXQuery compiled = xqPool.borrowCompiledXQuery(broker, TEST_XQUERY);
                if (compiled == null) {
                    XQueryContext context = new XQueryContext(this.pool);
                    compiled = xquery.compile(broker, context, TEST_XQUERY);
                }
                try {
                    xquery.execute(broker, compiled, null);
                }
                finally {
                    compiled.getContext().runCleanupTasks();
                    xqPool.returnCompiledXQuery(TEST_XQUERY, compiled);
                }
            }
            catch (Exception e) {
                this.lastPingRespTime = -2L;
                this.taskstatus.setStatus(TaskStatus.Status.PING_ERROR);
                this.taskstatus.setStatusChangeTime();
                this.taskstatus.setReason(e.getMessage());
                this.changeStatus(this.taskstatus);
            }
            finally {
                this.lastPingRespTime = System.currentTimeMillis() - start;
                this.taskstatus.setStatus(TaskStatus.Status.PING_OK);
                this.taskstatus.setStatusChangeTime();
                this.taskstatus.setReason("ping response time: " + this.lastPingRespTime);
                this.changeStatus(this.taskstatus);
            }
        }
        return this.lastPingRespTime;
    }

    private Properties parseParameter(String output, String backup, String incremental) {
        Properties properties = new Properties();
        boolean doBackup = backup.equalsIgnoreCase("YES");
        if (backup != null && doBackup || backup.equalsIgnoreCase("no")) {
            properties.put("backup", backup);
        }
        if (incremental != null && (incremental.equalsIgnoreCase("YES") || incremental.equalsIgnoreCase("no"))) {
            properties.put("incremental", incremental);
        }
        if (output != null) {
            properties.put("output", output);
        } else {
            properties.put("backup", "no");
        }
        return properties;
    }

    protected void updateErrors(List<ErrorReport> errorList) {
        try {
            if (errorList == null || errorList.isEmpty()) {
                this.taskstatus.setStatus(TaskStatus.Status.STOPPED_OK);
                this.errors = NO_ERRORS;
            } else {
                this.errors = errorList;
                this.taskstatus.setStatus(TaskStatus.Status.STOPPED_ERROR);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void changeStatus(TaskStatus status) {
        status.setStatusChangeTime();
        switch (status.getStatus()) {
            case INIT: {
                this.actualCheckStart = status.getStatusChangeTime();
                break;
            }
            case STOPPED_ERROR: 
            case STOPPED_OK: {
                this.lastCheckStart = this.actualCheckStart;
                this.actualCheckStart = null;
                this.lastCheckEnd = status.getStatusChangeTime();
                if (status.getReason() != null) {
                    this.errors = (List)status.getReason();
                }
                this.lastActionInfo = this.taskstatus.toString() + " to [" + this.output + "] ended with status [" + status.toString() + "]";
                break;
            }
        }
        TaskStatus oldState = this.taskstatus;
        try {
            this.taskstatus = status;
            AttributeChangeNotification event = new AttributeChangeNotification(this, this.seqNum++, this.taskstatus.getStatusChangeTime().getTime(), "Status change", "status", "String", oldState.toString(), this.taskstatus.toString());
            event.setUserData(this.taskstatus.getCompositeData());
            this.sendNotification(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateStatus(int percentage) {
        try {
            int oldPercentage = this.taskstatus.getPercentage();
            this.taskstatus.setPercentage(percentage);
            AttributeChangeNotification event = new AttributeChangeNotification(this, this.seqNum++, this.taskstatus.getStatusChangeTime().getTime(), "Work percentage change", "status", "int", String.valueOf(oldPercentage), String.valueOf(this.taskstatus.getPercentage()));
            event.setUserData(this.taskstatus.getCompositeData());
            this.sendNotification(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

