/*
 * Decompiled with CFR 0.152.
 */
package org.exist.plugin.command;

import java.util.HashMap;
import java.util.Map;
import org.exist.plugin.command.CommandException;
import org.exist.plugin.command.CommandNotFoundException;
import org.exist.plugin.command.CommandResolver;
import org.exist.xmldb.XmldbURI;

public class Commands {
    private static Map<String, CommandResolver> commands = new HashMap<String, CommandResolver>();

    public static void plug(String command, CommandResolver resolver) {
        commands.put(command, resolver);
    }

    private static void plugin(String name) {
        try {
            Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void command(XmldbURI collection, String[] params) throws CommandException {
        CommandResolver runner = commands.get(params[0]);
        if (runner == null) {
            throw new CommandNotFoundException("Command '" + params[0] + "' not found.");
        }
        String[] commandData = new String[params.length - 1];
        System.arraycopy(params, 1, commandData, 0, params.length - 1);
        runner.execute(collection, commandData);
    }

    static {
        Commands.plugin("org.exist.commands.info.InfoCommandResolver");
        Commands.plugin("org.exist.commands.threads.ThreadsCommandResolver");
        Commands.plugin("org.exist.commands.svn.SvnCommandResolver");
    }
}

