/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.protocolhandler.Mode;
import org.exist.protocolhandler.eXistURLStreamHandlerFactory;
import org.exist.storage.DBBroker;
import org.exist.storage.StartupTrigger;

public class URLStreamHandlerStartupTrigger
implements StartupTrigger {
    private static final Logger LOG = LogManager.getLogger(URLStreamHandlerStartupTrigger.class);
    public static final String JAVA_PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    public static final String EXIST_PROTOCOL_HANDLER = "org.exist.protocolhandler.protocols";
    private static final AtomicBoolean registered = new AtomicBoolean();

    @Override
    public void execute(DBBroker sysBroker, Map<String, List<? extends Object>> params) {
        List<? extends Object> list;
        String mode = null;
        if (params != null && (list = params.get("mode")) != null && list.size() == 1) {
            mode = list.get(0).toString();
        }
        this.registerStreamHandlerFactory(mode == null ? Mode.THREADS : Mode.valueOf(mode.toUpperCase()));
    }

    private void registerStreamHandlerFactory(Mode mode) {
        if (registered.compareAndSet(false, true)) {
            try {
                URL.setURLStreamHandlerFactory(new eXistURLStreamHandlerFactory(mode));
                LOG.info("Successfully registered eXistURLStreamHandlerFactory.");
            }
            catch (Error ex) {
                LOG.warn("The JVM already has a URLStreamHandlerFactory registered, skipping...");
                String currentSystemProperty = System.getProperty(JAVA_PROTOCOL_HANDLER_PKGS);
                if (currentSystemProperty == null) {
                    LOG.info("Setting java.protocol.handler.pkgs to org.exist.protocolhandler.protocols");
                    System.setProperty(JAVA_PROTOCOL_HANDLER_PKGS, EXIST_PROTOCOL_HANDLER);
                }
                if (!currentSystemProperty.contains(EXIST_PROTOCOL_HANDLER)) {
                    currentSystemProperty = currentSystemProperty + "|" + EXIST_PROTOCOL_HANDLER;
                    LOG.info("Setting java.protocol.handler.pkgs to " + currentSystemProperty);
                    System.setProperty(JAVA_PROTOCOL_HANDLER_PKGS, currentSystemProperty);
                }
                LOG.info("System property java.protocol.handler.pkgs has not been updated.");
            }
        }
    }
}

