/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.protocolhandler.embedded.EmbeddedUser;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.xmldb.XmldbURI;

public class EmbeddedDownload {
    private static final Logger LOG = LogManager.getLogger(EmbeddedDownload.class);
    private BrokerPool pool;

    public void setBrokerPool(BrokerPool brokerPool) {
        this.pool = brokerPool;
    }

    public void stream(XmldbURL xmldbURL, OutputStream os) throws IOException {
        this.stream(xmldbURL, os, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stream(XmldbURL xmldbURL, OutputStream os, Subject user) throws IOException {
        block42: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Begin document download");
            }
            try {
                XmldbURI path = XmldbURI.create(xmldbURL.getPath());
                if (this.pool == null) {
                    this.pool = BrokerPool.getInstance();
                }
                if (user == null) {
                    if (xmldbURL.hasUserInfo()) {
                        user = EmbeddedUser.authenticate(xmldbURL, this.pool);
                        if (user == null) {
                            throw new IOException("Unauthorized user " + xmldbURL.getUsername());
                        }
                    } else {
                        user = EmbeddedUser.getUserGuest(this.pool);
                    }
                }
                try (DBBroker broker = this.pool.get(Optional.of(user));){
                    DocumentImpl resource = null;
                    Collection collection = null;
                    try {
                        resource = broker.getXMLResource(path, Lock.LockMode.READ_LOCK);
                        if (resource == null) {
                            collection = broker.openCollection(path, Lock.LockMode.READ_LOCK);
                            if (collection == null) {
                                throw new IOException("Resource " + xmldbURL.getPath() + " not found.");
                            }
                            throw new IOException("Resource " + xmldbURL.getPath() + " is a collection.");
                        }
                        if (resource.getResourceType() == 0) {
                            Serializer serializer = broker.getSerializer();
                            serializer.reset();
                            serializer.setProperty("output-doctype", "yes");
                            try (OutputStreamWriter w = new OutputStreamWriter(os, "UTF-8");){
                                serializer.serialize(resource, (Writer)w);
                                break block42;
                            }
                        }
                        broker.readBinaryResource((BinaryDocument)resource, os);
                    }
                    finally {
                        if (collection != null) {
                            collection.release(Lock.LockMode.READ_LOCK);
                        }
                        if (resource != null) {
                            resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("End document download");
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
                throw ex;
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                throw new IOException(ex.getMessage(), ex);
            }
        }
    }
}

