/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.protocolhandler.embedded.EmbeddedDownloadThread;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.storage.BrokerPool;

public class EmbeddedInputStream
extends InputStream {
    private static final Logger LOG = LogManager.getLogger(EmbeddedInputStream.class);
    private final PipedInputStream bis;
    private final PipedOutputStream bos;
    private final EmbeddedDownloadThread rt;

    public EmbeddedInputStream(XmldbURL xmldbURL) throws IOException {
        this(null, xmldbURL);
    }

    public EmbeddedInputStream(BrokerPool brokerPool, XmldbURL xmldbURL) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing EmbeddedInputStream");
        }
        this.bis = new PipedInputStream(4096);
        this.bos = new PipedOutputStream(this.bis);
        this.rt = new EmbeddedDownloadThread(brokerPool, xmldbURL, this.bos);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing EmbeddedInputStream done");
        }
        this.rt.start();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.bis.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.bis.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.bis.skip(n);
    }

    @Override
    public void reset() throws IOException {
        this.bis.reset();
    }

    @Override
    public int read() throws IOException {
        return this.bis.read();
    }

    @Override
    public void close() throws IOException {
        this.bis.close();
    }

    @Override
    public int available() throws IOException {
        return this.bis.available();
    }
}

