/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.protocolhandler.embedded.EmbeddedUser;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.InputSource;

public class EmbeddedUpload {
    private static final Logger LOG = LogManager.getLogger(EmbeddedUpload.class);

    public void stream(XmldbURL xmldbURL, InputStream is) throws IOException {
        this.stream(xmldbURL, is, null);
    }

    public void stream(XmldbURL xmldbURL, InputStream is, Subject user) throws IOException {
        Path tmp = null;
        try {
            tmp = Files.createTempFile("EMBEDDED", "tmp", new FileAttribute[0]);
            Files.copy(is, tmp, StandardCopyOption.REPLACE_EXISTING);
            this.stream(xmldbURL, tmp.toFile(), user);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            throw ex;
        }
        finally {
            if (tmp != null) {
                Files.delete(tmp);
            }
        }
    }

    public void stream(XmldbURL xmldbURL, File tmp) throws IOException {
        this.stream(xmldbURL, tmp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stream(XmldbURL xmldbURL, File tmp, Subject user) throws IOException {
        LOG.debug("Begin document upload");
        try {
            BrokerPool pool = BrokerPool.getInstance();
            if (user == null) {
                if (xmldbURL.hasUserInfo()) {
                    user = EmbeddedUser.authenticate(xmldbURL, pool);
                    if (user == null) {
                        LOG.debug("Unauthorized user " + xmldbURL.getUsername());
                        throw new IOException("Unauthorized user " + xmldbURL.getUsername());
                    }
                } else {
                    user = EmbeddedUser.getUserGuest(pool);
                }
            }
            Collection collection = null;
            try (DBBroker broker = pool.get(Optional.of(user));){
                XmldbURI collectionUri = XmldbURI.create(xmldbURL.getCollection());
                XmldbURI documentUri = XmldbURI.create(xmldbURL.getDocumentName());
                collection = broker.openCollection(collectionUri, Lock.LockMode.WRITE_LOCK);
                if (collection == null) {
                    throw new IOException("Resource " + collectionUri.toString() + " is not a collection.");
                }
                if (collection.hasChildCollection(broker, documentUri)) {
                    throw new IOException("Resource " + documentUri.toString() + " is a collection.");
                }
                MimeType mime = MimeTable.getInstance().getContentTypeFor(documentUri);
                String contentType = null;
                if (mime != null) {
                    contentType = mime.getName();
                } else {
                    mime = MimeType.BINARY_TYPE;
                }
                TransactionManager transact = pool.getTransactionManager();
                try (Txn txn = transact.beginTransaction();){
                    if (mime.isXMLType()) {
                        LOG.debug("storing XML resource");
                        InputSource inputsource = new InputSource(tmp.toURI().toASCIIString());
                        IndexInfo info = collection.validateXMLResource(txn, broker, documentUri, inputsource);
                        DocumentImpl doc = info.getDocument();
                        doc.getMetadata().setMimeType(contentType);
                        collection.store(txn, broker, info, inputsource);
                        LOG.debug("done");
                    } else {
                        LOG.debug("storing Binary resource");
                        try (FileInputStream is = new FileInputStream(tmp);){
                            collection.addBinaryResource(txn, broker, documentUri, is, contentType, tmp.length());
                        }
                        LOG.debug("done");
                    }
                    LOG.debug("commit");
                    txn.commit();
                }
            }
            finally {
                if (collection != null) {
                    collection.release(Lock.LockMode.WRITE_LOCK);
                }
            }
        }
        catch (IOException ex) {
            LOG.debug((Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.debug((Object)ex);
            throw new IOException(ex.getMessage(), ex);
        }
        finally {
            LOG.debug("Done.");
        }
    }
}

