/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.protocolhandler.embedded.InMemoryOutputStream;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.xmldb.XmldbURI;

public class InMemoryInputStream {
    private static final Logger LOG = LogManager.getLogger(InMemoryOutputStream.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream stream(XmldbURL xmldbURL) throws IOException {
        ByteArrayOutputStream os;
        block37: {
            BrokerPool db;
            try {
                db = BrokerPool.getInstance();
            }
            catch (EXistException e) {
                throw new IOException(e);
            }
            os = new ByteArrayOutputStream();
            try (DBBroker broker = db.getBroker();){
                XmldbURI path = XmldbURI.create(xmldbURL.getPath());
                DocumentImpl resource = null;
                Collection collection = null;
                try {
                    resource = broker.getXMLResource(path, Lock.LockMode.READ_LOCK);
                    if (resource == null) {
                        collection = broker.openCollection(path, Lock.LockMode.READ_LOCK);
                        if (collection == null) {
                            throw new IOException("Resource " + xmldbURL.getPath() + " not found.");
                        }
                        throw new IOException("Resource " + xmldbURL.getPath() + " is a collection.");
                    }
                    if (resource.getResourceType() == 0) {
                        Serializer serializer = broker.getSerializer();
                        serializer.reset();
                        serializer.setProperty("output-doctype", "yes");
                        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, "UTF-8");){
                            serializer.serialize(resource, (Writer)w);
                            break block37;
                        }
                    }
                    broker.readBinaryResource((BinaryDocument)resource, os);
                }
                finally {
                    if (collection != null) {
                        collection.release(Lock.LockMode.READ_LOCK);
                    }
                    if (resource != null) {
                        resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                    }
                }
            }
            catch (IOException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                throw new IOException(ex.getMessage(), ex);
            }
        }
        return new ByteArrayInputStream(os.toByteArray());
    }
}

