/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.InputSource;

public class InMemoryOutputStream
extends ByteArrayOutputStream {
    private static final Logger LOG = LogManager.getLogger(InMemoryOutputStream.class);
    XmldbURL xmldbURL;

    public InMemoryOutputStream(XmldbURL xmldbURL) {
        this.xmldbURL = xmldbURL;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.stream(this.xmldbURL, this.toByteArray());
    }

    public void stream(XmldbURL xmldbURL, byte[] data) throws IOException {
        BrokerPool db;
        try {
            db = BrokerPool.getInstance();
        }
        catch (EXistException e) {
            throw new IOException(e);
        }
        try (DBBroker broker = db.getBroker();){
            XmldbURI collectionUri = XmldbURI.create(xmldbURL.getCollection());
            XmldbURI documentUri = XmldbURI.create(xmldbURL.getDocumentName());
            TransactionManager transact = db.getTransactionManager();
            try (Txn txn = transact.beginTransaction();){
                Collection collection = broker.getOrCreateCollection(txn, collectionUri);
                if (collection == null) {
                    throw new IOException("Resource " + collectionUri.toString() + " is not a collection.");
                }
                Lock lock = collection.getLock();
                if (!lock.isLockedForWrite()) {
                    txn.acquireLock(lock, Lock.LockMode.WRITE_LOCK);
                }
                if (collection.hasChildCollection(broker, documentUri)) {
                    throw new IOException("Resource " + documentUri.toString() + " is a collection.");
                }
                MimeType mime = MimeTable.getInstance().getContentTypeFor(documentUri);
                String contentType = null;
                if (mime != null) {
                    contentType = mime.getName();
                } else {
                    mime = MimeType.BINARY_TYPE;
                }
                if (mime.isXMLType()) {
                    InputSource inputsource = new InputSource(new ByteArrayInputStream(data));
                    IndexInfo info = collection.validateXMLResource(txn, broker, documentUri, inputsource);
                    DocumentImpl doc = info.getDocument();
                    doc.getMetadata().setMimeType(contentType);
                    collection.store(txn, broker, info, inputsource);
                } else {
                    try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
                        collection.addBinaryResource(txn, broker, documentUri, is, contentType, data.length);
                    }
                }
                txn.commit();
            }
        }
        catch (IOException ex) {
            LOG.debug((Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.debug((Object)ex);
            throw new IOException(ex.getMessage(), ex);
        }
    }
}

