/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.xmldb;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.exist.xmldb.XmldbURI;

public class XmldbURL {
    private static final int USERNAME = 1;
    private static final int PASSWORD = 2;
    private URL myUrl;

    public XmldbURL(XmldbURI xmldbURI) throws MalformedURLException {
        this(xmldbURI.toURL());
    }

    public XmldbURL(URL url) throws MalformedURLException {
        if (!"xmldb".equals(url.getProtocol())) {
            throw new MalformedURLException("URL is not an \"xmldb:\" URL: " + url.toString());
        }
        this.myUrl = url;
    }

    public XmldbURL(URI uri) throws MalformedURLException {
        this(uri.toURL());
    }

    public XmldbURL(String txt) throws MalformedURLException {
        this(new URL(txt));
    }

    public String getUserInfo() {
        return this.myUrl.getUserInfo();
    }

    public String getUsername() {
        return this.extractCredentials(1);
    }

    public String getPassword() {
        return this.extractCredentials(2);
    }

    public URL getURL() {
        return this.myUrl;
    }

    public String getAuthority() {
        return this.myUrl.getAuthority();
    }

    public String getContext() {
        String path = this.myUrl.getPath();
        int dbPosition = path.indexOf("/db");
        String context = null;
        if (dbPosition != -1) {
            context = path.substring(0, dbPosition);
        }
        if (context != null && "".equals(context)) {
            context = null;
        }
        return context;
    }

    public String getCollection() {
        int lastSep;
        String path = this.myUrl.getPath();
        String collectionName = null;
        int dbLocation = path.indexOf("/db");
        collectionName = dbLocation != -1 ? (path.endsWith("/") ? path.substring(dbLocation, path.length() - 1) : ((lastSep = path.lastIndexOf(47)) == 0 ? "/" : (lastSep != -1 ? path.substring(dbLocation, lastSep) : path))) : (path.endsWith("/") ? path.substring(0, path.length() - 1) : ((lastSep = path.lastIndexOf(47)) != -1 ? path.substring(0, lastSep) : "/"));
        return collectionName;
    }

    public String getDocumentName() {
        String serverPath = this.myUrl.getPath();
        String documentName = null;
        if (!serverPath.endsWith("/")) {
            int lastSep = serverPath.lastIndexOf(47);
            documentName = lastSep == -1 ? serverPath : serverPath.substring(lastSep + 1);
        }
        return documentName;
    }

    private String extractCredentials(int part) {
        String userInfo = this.myUrl.getUserInfo();
        String username = null;
        String password = null;
        if (userInfo != null) {
            int separator = userInfo.indexOf(58);
            if (separator == -1) {
                username = userInfo;
                password = null;
            } else {
                username = userInfo.substring(0, separator);
                password = userInfo.substring(separator + 1);
            }
        }
        if (username != null && "".equals(username)) {
            username = null;
        }
        if (password != null && "".equals(password)) {
            password = null;
        }
        if (part == 1) {
            return username;
        }
        if (part == 2) {
            return password;
        }
        return null;
    }

    public String getProtocol() {
        return this.myUrl.getProtocol();
    }

    public String getHost() {
        String hostname = this.myUrl.getHost();
        if ("".equals(hostname)) {
            return null;
        }
        return hostname;
    }

    public int getPort() {
        return this.myUrl.getPort();
    }

    public String getPath() {
        return this.myUrl.getPath();
    }

    public String getQuery() {
        return this.myUrl.getQuery();
    }

    public String getCollectionPath() {
        return this.myUrl.getPath().substring(13);
    }

    public String getXmlRpcURL() {
        return "http://" + this.myUrl.getAuthority() + this.getContext();
    }

    public boolean hasUserInfo() {
        return this.getUserInfo() != null && this.getUsername() != null;
    }

    public String getInstanceName() {
        return "exist";
    }

    public String toString() {
        return this.myUrl.toString();
    }

    public boolean isEmbedded() {
        return this.getHost() == null;
    }
}

