/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.protocolhandler.xmlrpc.XmlrpcDownloadThread;
import org.exist.storage.io.BlockingInputStream;
import org.exist.storage.io.BlockingOutputStream;

public class XmlrpcInputStream
extends InputStream {
    private static final Logger logger = LogManager.getLogger(XmlrpcInputStream.class);
    private BlockingInputStream bis;
    private BlockingOutputStream bos;
    private XmlrpcDownloadThread rt;

    public XmlrpcInputStream(XmldbURL xmldbURL) {
        logger.debug("Initializing ResourceInputStream");
        this.bis = new BlockingInputStream();
        this.bos = this.bis.getOutputStream();
        this.rt = new XmlrpcDownloadThread(xmldbURL, this.bos);
        this.rt.start();
        logger.debug("Initializing ResourceInputStream done");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.bis.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.bis.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.bis.skip(n);
    }

    @Override
    public void reset() throws IOException {
        this.bis.reset();
    }

    @Override
    public int read() throws IOException {
        return this.bis.read();
    }

    @Override
    public void close() throws IOException {
        this.bis.close();
    }

    @Override
    public int available() throws IOException {
        return this.bis.available();
    }
}

