/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;

public class XmlrpcUpload {
    private static final Logger LOG = LogManager.getLogger(XmlrpcUpload.class);

    public void stream(XmldbURL xmldbURL, InputStream is) throws IOException {
        block11: {
            LOG.debug("Begin document upload");
            try {
                int len;
                XmlRpcClient client = new XmlRpcClient();
                XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
                config.setEncoding("UTF-8");
                config.setEnabledForExtensions(true);
                config.setServerURL(new URL(xmldbURL.getXmlRpcURL()));
                if (xmldbURL.hasUserInfo()) {
                    config.setBasicUserName(xmldbURL.getUsername());
                    config.setBasicPassword(xmldbURL.getPassword());
                }
                client.setConfig((XmlRpcClientConfig)config);
                String contentType = MimeType.BINARY_TYPE.getName();
                MimeType mime = MimeTable.getInstance().getContentTypeFor(xmldbURL.getDocumentName());
                if (mime != null) {
                    contentType = mime.getName();
                }
                ArrayList<Object> params = new ArrayList<Object>(5);
                String handle = null;
                byte[] buf = new byte[4096];
                while ((len = is.read(buf)) > 0) {
                    params.clear();
                    if (handle != null) {
                        params.add(handle);
                    }
                    params.add(buf);
                    params.add(len);
                    handle = (String)client.execute("upload", params);
                }
                params.clear();
                params.add(handle);
                params.add(xmldbURL.getCollectionPath());
                params.add(true);
                params.add(contentType);
                Boolean result = (Boolean)client.execute("parseLocal", params);
                if (result.booleanValue()) {
                    LOG.debug("Document stored.");
                    break block11;
                }
                LOG.debug("Could not store document.");
                throw new IOException("Could not store document.");
            }
            catch (IOException ex) {
                LOG.debug((Object)ex);
                throw ex;
            }
            catch (Exception ex) {
                LOG.debug((Object)ex);
                throw new IOException(ex.getMessage(), ex);
            }
            finally {
                LOG.debug("Finished document upload");
            }
        }
    }
}

