/*
 * Decompiled with CFR 0.152.
 */
package org.exist.repo;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.repo.Deployment;
import org.exist.repo.PackageLoader;
import org.exist.storage.DBBroker;
import org.exist.storage.StartupTrigger;
import org.exist.util.FileUtils;
import org.expath.pkg.repo.PackageException;

public class AutoDeploymentTrigger
implements StartupTrigger {
    private static final Logger LOG = LogManager.getLogger(AutoDeploymentTrigger.class);
    public static final String AUTODEPLOY_DIRECTORY = "autodeploy";
    public static final String AUTODEPLOY_PROPERTY = "exist.autodeploy";

    @Override
    public void execute(DBBroker sysBroker, Map<String, List<? extends Object>> params) {
        String property = System.getProperty(AUTODEPLOY_PROPERTY, "on");
        if (property.equalsIgnoreCase("off")) {
            return;
        }
        Optional<Path> homeDir = sysBroker.getConfiguration().getExistHome();
        Path autodeployDir = FileUtils.resolve(homeDir, AUTODEPLOY_DIRECTORY);
        if (!Files.isReadable(autodeployDir) && Files.isDirectory(autodeployDir, new LinkOption[0])) {
            return;
        }
        try {
            List xars = Files.find(autodeployDir, 1, (path, attrs) -> !attrs.isDirectory() && FileUtils.fileName(path).endsWith(".xar"), new FileVisitOption[0]).sorted(Comparator.comparing(Path::getFileName)).collect(Collectors.toList());
            LOG.info("Scanning autodeploy directory. Found " + xars.size() + " app packages.");
            Deployment deployment = new Deployment(sysBroker);
            HashMap<String, Path> packages = new HashMap<String, Path>();
            for (Path xar : xars) {
                try {
                    Optional<String> name2 = deployment.getNameFromDescriptor(xar);
                    if (name2.isPresent()) {
                        packages.put(name2.get(), xar);
                        continue;
                    }
                    LOG.warn("No descriptor name for: " + xar.toAbsolutePath().toString());
                }
                catch (IOException | PackageException e) {
                    LOG.warn("Caught exception while reading app package " + xar.toAbsolutePath().toString(), e);
                }
            }
            PackageLoader loader = (name, version) -> (Path)packages.get(name);
            for (Path xar : xars) {
                try {
                    deployment.installAndDeploy(xar, loader, false);
                }
                catch (IOException | PackageException e) {
                    LOG.warn("Exception during deployment of app " + FileUtils.fileName(xar) + ": " + e.getMessage(), e);
                    sysBroker.getBrokerPool().reportStatus("An error occurred during app deployment: " + e.getMessage());
                }
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
        }
    }
}

