/*
 * Decompiled with CFR 0.152.
 */
package org.exist.repo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.SystemProperties;
import org.exist.repo.ExistRepository;
import org.exist.repo.PackageLoader;
import org.exist.start.Classpath;
import org.exist.start.EXistClassLoader;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.expath.pkg.repo.FileSystemStorage;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Packages;
import org.expath.pkg.repo.deps.ProcessorDependency;

public class ClasspathHelper
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(ClasspathHelper.class);
    private static final PackageLoader.Version DEFAULT_VERSION = new PackageLoader.Version("1.4.0", "2.2.1");

    @Override
    public void prepare(BrokerPool brokerPool) throws BrokerPoolServiceException {
        ClassLoader loader = brokerPool.getClassLoader();
        if (!(loader instanceof EXistClassLoader)) {
            return;
        }
        Classpath cp = new Classpath();
        ClasspathHelper.scanPackages(brokerPool, cp);
        ((EXistClassLoader)loader).addURLs(cp);
    }

    public static void updateClasspath(BrokerPool pool, Package pkg) throws PackageException {
        ClassLoader loader = pool.getClassLoader();
        if (!(loader instanceof EXistClassLoader)) {
            return;
        }
        if (!ClasspathHelper.isCompatible(pkg)) {
            LOG.warn("Package " + pkg.getName() + " is not compatible with this version of eXist. To avoid conflicts, Java libraries shipping with this package are not loaded.");
            return;
        }
        FileSystemStorage.FileSystemResolver resolver = (FileSystemStorage.FileSystemResolver)pkg.getResolver();
        File packageDir = resolver.resolveResourceAsFile(".");
        Classpath cp = new Classpath();
        try {
            ClasspathHelper.scanPackageDir(cp, packageDir);
            ((EXistClassLoader)loader).addURLs(cp);
        }
        catch (IOException e) {
            LOG.warn("An error occurred while updating classpath for package " + pkg.getName(), (Throwable)e);
        }
    }

    private static void scanPackages(BrokerPool pool, Classpath classpath) {
        try {
            Optional<ExistRepository> repo = pool.getExpathRepo();
            if (repo.isPresent()) {
                for (Packages pkgs : repo.get().getParentRepo().listPackages()) {
                    Package pkg = pkgs.latest();
                    if (!ClasspathHelper.isCompatible(pkg)) {
                        LOG.warn("Package " + pkg.getName() + " is not compatible with this version of eXist. To avoid conflicts, Java libraries shipping with this package are not loaded.");
                        continue;
                    }
                    try {
                        FileSystemStorage.FileSystemResolver resolver = (FileSystemStorage.FileSystemResolver)pkg.getResolver();
                        File packageDir = resolver.resolveResourceAsFile(".");
                        ClasspathHelper.scanPackageDir(classpath, packageDir);
                    }
                    catch (IOException e) {
                        LOG.warn("An error occurred while updating classpath for package " + pkg.getName(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred while updating classpath for packages", (Throwable)e);
        }
    }

    private static boolean isCompatible(Package pkg) throws PackageException {
        Collection processorDeps = pkg.getProcessorDeps();
        String procVersion = SystemProperties.getInstance().getSystemProperty("product-version", "1.0");
        PackageLoader.Version processorVersion = DEFAULT_VERSION;
        for (ProcessorDependency dependency : processorDeps) {
            if (!"http://exist-db.org".equals(dependency.getProcessor())) continue;
            if (dependency.getSemver() != null) {
                processorVersion = new PackageLoader.Version(dependency.getSemver(), true);
                break;
            }
            if (dependency.getSemverMax() != null || dependency.getSemverMin() != null) {
                processorVersion = new PackageLoader.Version(dependency.getSemverMin(), dependency.getSemverMax());
                break;
            }
            if (dependency.getVersions() == null) break;
            processorVersion = new PackageLoader.Version(dependency.getVersions(), false);
            break;
        }
        return processorVersion.getDependencyVersion().isCompatible(procVersion);
    }

    private static void scanPackageDir(Classpath classpath, File module) throws IOException {
        Path dotExist = module.toPath().resolve(".exist");
        if (Files.exists(dotExist, new LinkOption[0])) {
            if (!Files.isDirectory(dotExist, new LinkOption[0])) {
                throw new IOException("The .exist config dir is not a dir: " + dotExist);
            }
            Path cp = dotExist.resolve("classpath.txt");
            if (Files.exists(cp, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(cp);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        classpath.addComponent(line);
                    }
                }
            }
        }
    }
}

