/*
 * Decompiled with CFR 0.152.
 */
package org.exist.repo;

import com.evolvedbinary.j8fu.Either;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.SystemProperties;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.ElementImpl;
import org.exist.dom.memtree.InMemoryNodeSet;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.repo.ClasspathHelper;
import org.exist.repo.ExistPkgInfo;
import org.exist.repo.ExistRepository;
import org.exist.repo.PackageLoader;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.internal.aider.GroupAider;
import org.exist.security.internal.aider.UserAider;
import org.exist.source.FileSource;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.SyntaxException;
import org.exist.util.serializer.AttrList;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.NameTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.DocUtils;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.expath.pkg.repo.FileSystemStorage;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Packages;
import org.expath.pkg.repo.UserInteractionStrategy;
import org.expath.pkg.repo.deps.DependencyVersion;
import org.expath.pkg.repo.tui.BatchUserInteraction;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Deployment {
    public static final String PROPERTY_APP_ROOT = "repo.root-collection";
    private static final Logger LOG = LogManager.getLogger(Deployment.class);
    public static final String PROCESSOR_NAME = "http://exist-db.org";
    private static final String REPO_NAMESPACE = "http://exist-db.org/xquery/repo";
    private static final String PKG_NAMESPACE = "http://expath.org/ns/pkg";
    private static final QName SETUP_ELEMENT = new QName("setup", "http://exist-db.org/xquery/repo");
    private static final QName PRE_SETUP_ELEMENT = new QName("prepare", "http://exist-db.org/xquery/repo");
    private static final QName POST_SETUP_ELEMENT = new QName("finish", "http://exist-db.org/xquery/repo");
    private static final QName TARGET_COLL_ELEMENT = new QName("target", "http://exist-db.org/xquery/repo");
    private static final QName PERMISSIONS_ELEMENT = new QName("permissions", "http://exist-db.org/xquery/repo");
    private static final QName CLEANUP_ELEMENT = new QName("cleanup", "http://exist-db.org/xquery/repo");
    private static final QName DEPLOYED_ELEMENT = new QName("deployed", "http://exist-db.org/xquery/repo");
    private static final QName DEPENDENCY_ELEMENT = new QName("dependency", "http://expath.org/ns/pkg");
    private static final QName RESOURCES_ELEMENT = new QName("resources", "http://exist-db.org/xquery/repo");
    private static final String RESOURCES_PATH_ATTRIBUTE = "path";
    private final DBBroker broker;

    public Deployment(DBBroker broker) {
        this.broker = broker;
    }

    protected Optional<Path> getPackageDir(String pkgName, Optional<ExistRepository> repo) throws PackageException {
        Optional<Path> packageDir = Optional.empty();
        if (repo.isPresent()) {
            for (Packages pp : repo.get().getParentRepo().listPackages()) {
                Package pkg = pp.latest();
                if (!pkg.getName().equals(pkgName)) continue;
                packageDir = Optional.of(this.getPackageDir(pkg));
            }
        }
        return packageDir;
    }

    protected Path getPackageDir(Package pkg) {
        FileSystemStorage.FileSystemResolver resolver = (FileSystemStorage.FileSystemResolver)pkg.getResolver();
        return resolver.resolveResourceAsFile("").toPath();
    }

    protected Optional<Package> getPackage(String pkgName, Optional<ExistRepository> repo) throws PackageException {
        if (repo.isPresent()) {
            for (Packages pp : repo.get().getParentRepo().listPackages()) {
                Package pkg = pp.latest();
                if (!pkg.getName().equals(pkgName)) continue;
                return Optional.ofNullable(pkg);
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DocumentImpl getRepoXML(Path packageDir) throws PackageException {
        Path repoFile = packageDir.resolve("repo.xml");
        if (!Files.isReadable(repoFile)) {
            return null;
        }
        try (InputStream is = Files.newInputStream(repoFile, new OpenOption[0]);){
            DocumentImpl documentImpl = DocUtils.parse(this.broker.getBrokerPool(), null, is);
            return documentImpl;
        }
        catch (IOException | XPathException e) {
            throw new PackageException("Failed to parse repo.xml: " + e.getMessage(), (Throwable)e);
        }
    }

    public Optional<String> installAndDeploy(Path xar, PackageLoader loader) throws PackageException, IOException {
        return this.installAndDeploy(xar, loader, true);
    }

    public Optional<String> installAndDeploy(Path xar, PackageLoader loader, boolean enforceDeps) throws PackageException, IOException {
        Optional<DocumentImpl> descriptor = this.getDescriptor(xar);
        if (!descriptor.isPresent()) {
            throw new PackageException("Missing descriptor from package: " + xar.toAbsolutePath());
        }
        DocumentImpl document = descriptor.get();
        ElementImpl root = (ElementImpl)document.getDocumentElement();
        String name = root.getAttribute("name");
        String pkgVersion = root.getAttribute("version");
        Optional<ExistRepository> repo = this.broker.getBrokerPool().getExpathRepo();
        if (repo.isPresent()) {
            Packages packages = repo.get().getParentRepo().getPackages(name);
            if (packages != null && (!enforceDeps || pkgVersion.equals(packages.latest().getVersion()))) {
                LOG.info("Application package " + name + " already installed. Skipping.");
                Package pkg = packages.latest();
                return Optional.of(this.getTargetCollection(pkg, this.getPackageDir(pkg)));
            }
            try {
                InMemoryNodeSet deps = this.findElements(root, DEPENDENCY_ELEMENT);
                SequenceIterator i = deps.iterate();
                while (i.hasNext()) {
                    Element dependency = (Element)((Object)i.nextItem());
                    String pkgName = dependency.getAttribute("package");
                    String processor = dependency.getAttribute("processor");
                    String versionStr = dependency.getAttribute("version");
                    String semVer = dependency.getAttribute("semver");
                    String semVerMin = dependency.getAttribute("semver-min");
                    String semVerMax = dependency.getAttribute("semver-max");
                    PackageLoader.Version version = null;
                    if (semVer != null) {
                        version = new PackageLoader.Version(semVer, true);
                    } else if (semVerMax != null || semVerMin != null) {
                        version = new PackageLoader.Version(semVerMin, semVerMax);
                    } else if (pkgVersion != null) {
                        version = new PackageLoader.Version(versionStr, false);
                    }
                    if (processor != null && processor.equals(PROCESSOR_NAME) && version != null) {
                        this.checkProcessorVersion(version);
                        continue;
                    }
                    if (pkgName == null) continue;
                    LOG.info("Package " + name + " depends on " + pkgName);
                    boolean isInstalled = false;
                    if (repo.get().getParentRepo().getPackages(pkgName) != null) {
                        LOG.debug("Package " + pkgName + " already installed");
                        Packages pkgs = repo.get().getParentRepo().getPackages(pkgName);
                        if (pkgs != null) {
                            if (version != null) {
                                Package latest = pkgs.latest();
                                DependencyVersion depVersion = version.getDependencyVersion();
                                if (depVersion.isCompatible(latest.getVersion())) {
                                    isInstalled = true;
                                } else {
                                    LOG.debug("Package " + pkgName + " needs to be upgraded");
                                    if (enforceDeps) {
                                        throw new PackageException("Package requires version " + version.toString() + " of package " + pkgName + ". Installed version is " + latest.getVersion() + ". Please upgrade!");
                                    }
                                }
                            } else {
                                isInstalled = true;
                            }
                            if (isInstalled) {
                                LOG.debug("Package " + pkgName + " already installed");
                            }
                        }
                    }
                    if (isInstalled || loader == null) continue;
                    Path depFile = loader.load(pkgName, version);
                    if (depFile != null) {
                        this.installAndDeploy(depFile, loader);
                        continue;
                    }
                    if (enforceDeps) {
                        LOG.warn("Missing dependency: package " + pkgName + " could not be resolved. This error is not fatal, but the package may not work as expected");
                        continue;
                    }
                    throw new PackageException("Missing dependency: package " + pkgName + " could not be resolved.");
                }
            }
            catch (XPathException e) {
                throw new PackageException("Invalid descriptor found in " + xar.toAbsolutePath().toString());
            }
            LOG.info("Installing package " + xar.toAbsolutePath().toString());
            BatchUserInteraction interact = new BatchUserInteraction();
            Package pkg = repo.get().getParentRepo().installPackage(xar, true, (UserInteractionStrategy)interact);
            ExistPkgInfo info = (ExistPkgInfo)pkg.getInfo("exist");
            if (info != null && !info.getJars().isEmpty()) {
                ClasspathHelper.updateClasspath(this.broker.getBrokerPool(), pkg);
            }
            this.broker.getBrokerPool().getXQueryPool().clear();
            String pkgName = pkg.getName();
            this.broker.getBrokerPool().reportStatus("Installing app: " + pkg.getAbbrev());
            repo.get().reportAction(ExistRepository.Action.INSTALL, pkg.getName());
            LOG.info("Deploying package " + pkgName);
            return this.deploy(pkgName, repo, null);
        }
        return Optional.empty();
    }

    private void checkProcessorVersion(PackageLoader.Version version) throws PackageException {
        String procVersion = SystemProperties.getInstance().getSystemProperty("product-version", "1.0");
        DependencyVersion depVersion = version.getDependencyVersion();
        if (!depVersion.isCompatible(procVersion)) {
            throw new PackageException("Package requires eXistdb version " + version.toString() + ". Installed version is " + procVersion);
        }
    }

    public Optional<String> undeploy(String pkgName, Optional<ExistRepository> repo) throws PackageException {
        DocumentImpl repoXML;
        Optional<Path> maybePackageDir = this.getPackageDir(pkgName, repo);
        if (!maybePackageDir.isPresent()) {
            return Optional.empty();
        }
        Path packageDir = maybePackageDir.get();
        Optional<Package> pkg = this.getPackage(pkgName, repo);
        try {
            repoXML = this.getRepoXML(packageDir);
        }
        catch (PackageException e2) {
            if (pkg.isPresent()) {
                this.uninstall(pkg.get(), Optional.empty());
            }
            throw new PackageException("Failed to remove package from database due to error in repo.xml: " + e2.getMessage(), (Throwable)e2);
        }
        if (repoXML != null) {
            try {
                Optional<ElementImpl> cleanup = this.findElement(repoXML, CLEANUP_ELEMENT);
                if (cleanup.isPresent()) {
                    this.runQuery(null, packageDir, cleanup.get().getStringValue(), false);
                }
                Optional<ElementImpl> target = this.findElement(repoXML, TARGET_COLL_ELEMENT);
                if (pkg.isPresent()) {
                    this.uninstall(pkg.get(), target);
                }
                return target.map(e -> Optional.ofNullable(e.getStringValue())).orElseGet(() -> Optional.of(this.getTargetFallback((Package)pkg.get()).getCollectionPath()));
            }
            catch (XPathException e3) {
                throw new PackageException("Error found while processing repo.xml: " + e3.getMessage(), (Throwable)e3);
            }
            catch (IOException e4) {
                throw new PackageException("Error found while processing repo.xml: " + e4.getMessage(), (Throwable)e4);
            }
        }
        if (pkg.isPresent()) {
            this.uninstall(pkg.get(), Optional.empty());
        }
        return Optional.empty();
    }

    public Optional<String> deploy(String pkgName, Optional<ExistRepository> repo, String userTarget) throws PackageException, IOException {
        Optional<Path> maybePackageDir = this.getPackageDir(pkgName, repo);
        if (!maybePackageDir.isPresent()) {
            throw new PackageException("Package not found: " + pkgName);
        }
        Path packageDir = maybePackageDir.get();
        DocumentImpl repoXML = this.getRepoXML(packageDir);
        if (repoXML == null) {
            return Optional.empty();
        }
        try {
            Optional<ElementImpl> setup = this.findElement(repoXML, SETUP_ELEMENT);
            Optional<String> setupPath = setup.map(NodeImpl::getStringValue).filter(s -> !s.isEmpty());
            if (setupPath.isPresent()) {
                this.runQuery(null, packageDir, setupPath.get(), true);
                return Optional.empty();
            }
            XmldbURI targetCollection = null;
            if (userTarget != null) {
                try {
                    targetCollection = XmldbURI.create(userTarget);
                }
                catch (IllegalArgumentException e) {
                    throw new PackageException("Bad collection URI: " + userTarget, (Throwable)e);
                }
            } else {
                Optional<ElementImpl> target = this.findElement(repoXML, TARGET_COLL_ELEMENT);
                Optional<String> targetPath = target.map(NodeImpl::getStringValue).filter(s -> !s.isEmpty());
                if (targetPath.isPresent()) {
                    try {
                        targetCollection = XmldbURI.create(this.getTargetCollection(targetPath.get()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new PackageException("Bad collection URI for <target> element: " + targetPath.get(), (Throwable)e);
                    }
                } else {
                    LOG.warn("EXPath Package '" + pkgName + "' does not contain a <target> in its repo.xml, no files will be deployed to /apps");
                }
            }
            if (targetCollection == null) {
                Optional<Package> pkg = this.getPackage(pkgName, repo);
                pkg.orElseThrow(() -> new XPathException("expath repository is not available so the package was not stored."));
                String pkgColl = pkg.get().getAbbrev() + "-" + pkg.get().getVersion();
                targetCollection = XmldbURI.SYSTEM.append("repo/" + pkgColl);
            }
            Optional<ElementImpl> permissions = this.findElement(repoXML, PERMISSIONS_ELEMENT);
            Optional<RequestedPerms> requestedPerms = permissions.flatMap(elem -> {
                Optional<RequestedPerms> perms = Optional.ofNullable(elem.getAttribute("mode")).flatMap(mode -> {
                    try {
                        return Optional.of(Either.Left((Object)Integer.parseInt(mode, 8)));
                    }
                    catch (NumberFormatException e) {
                        if (mode.matches("^[rwx-]{9}")) {
                            return Optional.of(Either.Right((Object)mode));
                        }
                        return Optional.empty();
                    }
                });
                return perms.map(p -> new RequestedPerms(elem.getAttribute("user"), elem.getAttribute("password"), Optional.ofNullable(elem.getAttribute("group")), (Either)p));
            });
            if (permissions.isPresent() && !requestedPerms.isPresent()) {
                String mode = permissions.map(elem -> elem.getAttribute("mode")).orElse(null);
                throw new PackageException("Bad format for mode attribute in <permissions>: " + mode);
            }
            Optional<ElementImpl> preSetup = this.findElement(repoXML, PRE_SETUP_ELEMENT);
            Optional<String> preSetupPath = preSetup.map(NodeImpl::getStringValue).filter(s -> !s.isEmpty());
            if (preSetupPath.isPresent()) {
                this.runQuery(targetCollection, packageDir, preSetupPath.get(), true);
            }
            if (requestedPerms.isPresent()) {
                this.checkUserSettings((RequestedPerms)requestedPerms.get());
            }
            InMemoryNodeSet resources = this.findElements(repoXML, RESOURCES_ELEMENT);
            List<String> errors = this.scanDirectory(packageDir, targetCollection, resources, true, false, requestedPerms);
            Optional<ElementImpl> postSetup = this.findElement(repoXML, POST_SETUP_ELEMENT);
            Optional<String> postSetupPath = postSetup.map(NodeImpl::getStringValue).filter(s -> !s.isEmpty());
            if (postSetupPath.isPresent()) {
                this.runQuery(targetCollection, packageDir, postSetupPath.get(), false);
            }
            this.storeRepoXML(repoXML, targetCollection, requestedPerms);
            if (!errors.isEmpty()) {
                throw new PackageException("Deployment incomplete, " + errors.size() + " issues found: " + errors.stream().collect(Collectors.joining("; ")));
            }
            return Optional.ofNullable(targetCollection.getCollectionPath());
        }
        catch (XPathException e) {
            throw new PackageException("Error found while processing repo.xml: " + e.getMessage(), (Throwable)e);
        }
    }

    private void cleanup(String pkgName, Optional<ExistRepository> repo) throws PackageException {
        if (repo.isPresent()) {
            Optional<Package> pkg = this.getPackage(pkgName, repo);
            Optional<Path> maybePackageDir = pkg.map(this::getPackageDir);
            if (!maybePackageDir.isPresent()) {
                throw new PackageException("Cleanup: package dir for package " + pkgName + " not found");
            }
            Path packageDir = maybePackageDir.get();
            String abbrev = pkg.get().getAbbrev();
            try (Stream<Path> filesToDelete = Files.find(packageDir, 1, (path, attrs) -> {
                if (path.equals(packageDir)) {
                    return false;
                }
                String name = FileUtils.fileName(path);
                if (attrs.isDirectory()) {
                    return !name.equals(abbrev) && !name.equals("content");
                }
                return !name.equals("expath-pkg.xml") && !name.equals("repo.xml") && !"exist.xml".equals(name) && !name.startsWith("icon");
            }, new FileVisitOption[0]);){
                filesToDelete.forEach(path -> {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException ioe) {
                        LOG.warn("Cleanup: failed to delete file " + path.toAbsolutePath().toString() + " in package " + pkgName);
                    }
                });
            }
            catch (IOException ioe) {
                LOG.warn("Cleanup: failed to delete files", (Throwable)ioe);
            }
        }
    }

    private String getTargetCollection(Package pkg, Path pkgDir) throws PackageException {
        DocumentImpl repoXML = this.getRepoXML(pkgDir);
        if (repoXML != null) {
            try {
                Optional<ElementImpl> target = this.findElement(repoXML, TARGET_COLL_ELEMENT);
                return target.map(NodeImpl::getStringValue).map(this::getTargetCollection).map(XmldbURI::create).map(XmldbURI::getCollectionPath).orElseGet(() -> this.getTargetFallback(pkg).getCollectionPath());
            }
            catch (XPathException e) {
                throw new PackageException("Failed to determine target collection");
            }
        }
        return this.getTargetFallback(pkg).getCollectionPath();
    }

    private XmldbURI getTargetFallback(Package pkg) {
        String pkgColl = pkg.getAbbrev() + "-" + pkg.getVersion();
        return XmldbURI.SYSTEM.append("repo/" + pkgColl);
    }

    private String getTargetCollection(String targetFromRepo) {
        String appRoot = (String)this.broker.getConfiguration().getProperty(PROPERTY_APP_ROOT);
        if (appRoot != null) {
            if (targetFromRepo.startsWith("/db/")) {
                targetFromRepo = targetFromRepo.substring(4);
            }
            return appRoot + targetFromRepo;
        }
        if (targetFromRepo.startsWith("/db")) {
            return targetFromRepo;
        }
        return "/db/" + targetFromRepo;
    }

    private void uninstall(Package pkg, Optional<ElementImpl> target) throws PackageException {
        Optional<String> targetPath = target.map(NodeImpl::getStringValue).filter(s -> !s.isEmpty());
        XmldbURI targetCollection = targetPath.map(s -> XmldbURI.create(this.getTargetCollection((String)s))).orElseGet(() -> this.getTargetFallback(pkg));
        TransactionManager mgr = this.broker.getBrokerPool().getTransactionManager();
        try (Txn transaction = mgr.beginTransaction();){
            XmldbURI configCollection;
            Collection collection = this.broker.getOrCreateCollection(transaction, targetCollection);
            if (collection != null) {
                this.broker.removeCollection(transaction, collection);
            }
            if (target != null && (collection = this.broker.getOrCreateCollection(transaction, configCollection = XmldbURI.CONFIG_COLLECTION_URI.append(targetCollection))) != null) {
                this.broker.removeCollection(transaction, collection);
            }
            mgr.commit(transaction);
        }
        catch (IOException | TriggerException | PermissionDeniedException | TransactionException e) {
            LOG.error("Exception occurred while removing package.", (Throwable)e);
        }
    }

    private void storeRepoXML(DocumentImpl repoXML, XmldbURI targetCollection, Optional<RequestedPerms> requestedPerms) throws PackageException, XPathException {
        DateTimeValue time = new DateTimeValue(new Date());
        MemTreeBuilder builder = new MemTreeBuilder();
        builder.startDocument();
        UpdatingDocumentReceiver receiver = new UpdatingDocumentReceiver(builder, time.getStringValue());
        try {
            repoXML.copyTo(this.broker, (DocumentBuilderReceiver)receiver);
        }
        catch (SAXException e) {
            throw new PackageException("Error while updating repo.xml in-memory: " + e.getMessage(), (Throwable)e);
        }
        builder.endDocument();
        DocumentImpl updatedXML = builder.getDocument();
        TransactionManager mgr = this.broker.getBrokerPool().getTransactionManager();
        try (Txn transaction = mgr.beginTransaction();){
            Collection collection = this.broker.getOrCreateCollection(transaction, targetCollection);
            XmldbURI name = XmldbURI.createInternal("repo.xml");
            IndexInfo info = collection.validateXMLResource(transaction, this.broker, name, updatedXML);
            Permission permission = info.getDocument().getPermissions();
            this.setPermissions(requestedPerms, false, MimeType.XML_TYPE, permission);
            collection.store(transaction, this.broker, info, updatedXML);
            mgr.commit(transaction);
        }
        catch (IOException | EXistException | PermissionDeniedException | LockException | SAXException e) {
            throw new PackageException("Error while storing updated repo.xml: " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkUserSettings(RequestedPerms requestedPerms) throws PackageException {
        Objects.requireNonNull(requestedPerms);
        SecurityManager secman = this.broker.getBrokerPool().getSecurityManager();
        try {
            if (requestedPerms.group.filter(g -> !secman.hasGroup((String)g)).isPresent()) {
                secman.addGroup(this.broker, (Group)new GroupAider(requestedPerms.group.get()));
            }
            if (!secman.hasAccount(requestedPerms.user)) {
                UserAider aider = new UserAider(requestedPerms.user);
                aider.setPassword(requestedPerms.password);
                requestedPerms.group.ifPresent(groupName -> aider.addGroup((String)groupName));
                secman.addAccount(this.broker, aider);
            }
        }
        catch (EXistException | PermissionDeniedException e) {
            throw new PackageException("Failed to create user: " + requestedPerms.user, (Throwable)e);
        }
    }

    private Sequence runQuery(XmldbURI targetCollection, Path tempDir, String fileName, boolean preInstall) throws PackageException, IOException, XPathException {
        Path xquery = tempDir.resolve(fileName);
        if (!Files.isReadable(xquery)) {
            LOG.warn("The XQuery resource specified in the <setup> element was not found");
            return Sequence.EMPTY_SEQUENCE;
        }
        XQuery xqs = this.broker.getBrokerPool().getXQueryService();
        XQueryContext ctx = new XQueryContext(this.broker.getBrokerPool());
        ctx.declareVariable("dir", (Object)tempDir.toAbsolutePath().toString());
        Optional<Path> home = this.broker.getConfiguration().getExistHome();
        if (home.isPresent()) {
            ctx.declareVariable("home", (Object)home.get().toAbsolutePath().toString());
        }
        if (targetCollection != null) {
            ctx.declareVariable("target", (Object)targetCollection.toString());
            ctx.setModuleLoadPath(XmldbURI.EMBEDDED_SERVER_URI + targetCollection.toString());
        } else {
            ctx.declareVariable("target", (Object)Sequence.EMPTY_SEQUENCE);
        }
        if (preInstall) {
            ctx.setModuleLoadPath(tempDir.toAbsolutePath().toString());
        }
        try {
            CompiledXQuery compiled = xqs.compile(this.broker, ctx, new FileSource(xquery, false));
            return xqs.execute(this.broker, compiled, null);
        }
        catch (PermissionDeniedException e) {
            throw new PackageException(e.getMessage(), (Throwable)e);
        }
    }

    private List<String> scanDirectory(Path directory, XmldbURI target, InMemoryNodeSet resources, boolean inRootDir, boolean isResourcesDir, Optional<RequestedPerms> requestedPerms) {
        return this.scanDirectory(directory, target, resources, inRootDir, isResourcesDir, requestedPerms, new ArrayList<String>());
    }

    private List<String> scanDirectory(Path directory, XmldbURI target, InMemoryNodeSet resources, boolean inRootDir, boolean isResourcesDir, Optional<RequestedPerms> requestedPerms, List<String> errors) {
        boolean isResources;
        TransactionManager mgr = this.broker.getBrokerPool().getTransactionManager();
        Collection collection = null;
        try (Txn transaction = mgr.beginTransaction();){
            collection = this.broker.getOrCreateCollection(transaction, target);
            this.setPermissions(requestedPerms, true, null, collection.getPermissionsNoLock());
            this.broker.saveCollection(transaction, collection);
            mgr.commit(transaction);
        }
        catch (IOException | TriggerException | PermissionDeniedException | TransactionException e) {
            LOG.warn((Object)e);
            errors.add(e.getMessage());
        }
        boolean bl = isResources = isResourcesDir || this.isResourceDir(target, resources);
        if (!inRootDir && isResources) {
            try {
                this.storeBinaryResources(directory, collection, requestedPerms, errors);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        } else {
            this.storeFiles(directory, collection, inRootDir, requestedPerms, errors);
        }
        try (Stream<Path> subDirs = Files.find(directory, 1, (path, attrs) -> !path.equals(directory) && attrs.isDirectory(), new FileVisitOption[0]);){
            subDirs.forEach(path -> this.scanDirectory((Path)path, target.append(FileUtils.fileName(path)), resources, false, isResources, requestedPerms, errors));
        }
        catch (IOException ioe) {
            LOG.warn("Unable to scan sub-directories", (Throwable)ioe);
        }
        return errors;
    }

    private boolean isResourceDir(XmldbURI target, InMemoryNodeSet resources) {
        try {
            SequenceIterator i = resources.iterate();
            while (i.hasNext()) {
                ElementImpl child = (ElementImpl)i.nextItem();
                String resourcePath = child.getAttribute(RESOURCES_PATH_ATTRIBUTE);
                if (!target.toString().endsWith(resourcePath)) continue;
                return true;
            }
        }
        catch (XPathException e) {
            LOG.warn("Caught exception while reading resource list in repo.xml: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private void storeFiles(Path directory, Collection targetCollection, boolean inRootDir, Optional<RequestedPerms> requestedPerms, List<String> errors) {
        List files;
        try {
            files = FileUtils.list(directory);
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
            errors.add(FileUtils.fileName(directory) + ": " + ioe.getMessage());
            files = Collections.EMPTY_LIST;
        }
        MimeTable mimeTab = MimeTable.getInstance();
        TransactionManager mgr = this.broker.getBrokerPool().getTransactionManager();
        for (Path file : files) {
            if (inRootDir && FileUtils.fileName(file).equals("repo.xml") || Files.isDirectory(file, new LinkOption[0])) continue;
            MimeType mime = mimeTab.getContentTypeFor(FileUtils.fileName(file));
            if (mime == null) {
                mime = MimeType.BINARY_TYPE;
            }
            XmldbURI name = XmldbURI.create(FileUtils.fileName(file));
            try {
                Txn transaction = mgr.beginTransaction();
                Throwable throwable = null;
                try {
                    block33: {
                        if (mime.isXMLType()) {
                            try {
                                InputSource is = new InputSource(file.toUri().toASCIIString());
                                IndexInfo info = targetCollection.validateXMLResource(transaction, this.broker, name, is);
                                info.getDocument().getMetadata().setMimeType(mime.getName());
                                Permission permission = info.getDocument().getPermissions();
                                this.setPermissions(requestedPerms, false, mime, permission);
                                targetCollection.store(transaction, this.broker, info, is);
                            }
                            catch (Exception e) {
                                if (mime.getName().equals(MimeType.HTML_TYPE.getName())) {
                                    this.storeBinary(targetCollection, file, mime, name, requestedPerms, transaction);
                                    break block33;
                                }
                                errors.add(FileUtils.fileName(file) + ": " + e.getMessage());
                            }
                        } else {
                            long size = Files.size(file);
                            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                                BinaryDocument doc = targetCollection.addBinaryResource(transaction, this.broker, name, is, mime.getName(), size);
                                Permission permission = doc.getPermissions();
                                this.setPermissions(requestedPerms, false, mime, permission);
                                doc.getMetadata().setMimeType(mime.getName());
                                this.broker.storeXMLResource(transaction, doc);
                            }
                        }
                    }
                    mgr.commit(transaction);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (transaction == null) continue;
                    if (throwable != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    transaction.close();
                }
            }
            catch (IOException | EXistException | TriggerException | PermissionDeniedException | LockException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                errors.add(FileUtils.fileName(file) + ": " + e.getMessage());
            }
        }
    }

    private void storeBinary(Collection targetCollection, Path file, MimeType mime, XmldbURI name, Optional<RequestedPerms> requestedPerms, Txn transaction) throws IOException, EXistException, PermissionDeniedException, LockException, TriggerException {
        long size = Files.size(file);
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            BinaryDocument doc = targetCollection.addBinaryResource(transaction, this.broker, name, is, mime.getName(), size);
            Permission permission = doc.getPermissions();
            this.setPermissions(requestedPerms, false, mime, permission);
            doc.getMetadata().setMimeType(mime.getName());
            this.broker.storeXMLResource(transaction, doc);
        }
    }

    private void storeBinaryResources(Path directory, Collection targetCollection, Optional<RequestedPerms> requestedPerms, List<String> errors) throws IOException, EXistException, PermissionDeniedException, LockException, TriggerException {
        TransactionManager mgr = this.broker.getBrokerPool().getTransactionManager();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0])) continue;
                XmldbURI name = XmldbURI.create(FileUtils.fileName(entry));
                try {
                    Txn transaction = mgr.beginTransaction();
                    Throwable throwable = null;
                    try {
                        this.storeBinary(targetCollection, entry, MimeType.BINARY_TYPE, name, requestedPerms, transaction);
                        mgr.commit(transaction);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (transaction == null) continue;
                        if (throwable != null) {
                            try {
                                transaction.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        transaction.close();
                    }
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    errors.add(e.getMessage());
                }
            }
        }
    }

    private void setPermissions(Optional<RequestedPerms> requestedPerms, boolean isCollection, MimeType mime, Permission permission) throws PermissionDeniedException {
        int mode = permission.getMode();
        if (requestedPerms.isPresent()) {
            RequestedPerms perms = requestedPerms.get();
            permission.setOwner(perms.user);
            if (perms.group.isPresent()) {
                permission.setGroup(perms.group.get());
            }
            mode = (Integer)perms.permissions.map(permStr -> {
                try {
                    permission.setMode((String)permStr);
                    return permission.getMode();
                }
                catch (PermissionDeniedException | SyntaxException e) {
                    LOG.warn("Unable to set permissions string: " + permStr + ". Falling back to default.");
                    return permission.getMode();
                }
            }).fold(l -> l, r -> r);
        }
        if (isCollection || mime != null && mime.getName().equals(MimeType.XQUERY_TYPE.getName())) {
            mode |= 0x49;
        }
        permission.setMode(mode);
    }

    private Optional<ElementImpl> findElement(NodeImpl root, QName qname) throws XPathException {
        InMemoryNodeSet setupNodes = new InMemoryNodeSet();
        root.selectDescendants(false, new NameTest(1, qname), setupNodes);
        if (setupNodes.getItemCount() == 0) {
            return Optional.empty();
        }
        return Optional.of((ElementImpl)setupNodes.itemAt(0));
    }

    private InMemoryNodeSet findElements(NodeImpl root, QName qname) throws XPathException {
        InMemoryNodeSet setupNodes = new InMemoryNodeSet();
        root.selectDescendants(false, new NameTest(1, qname), setupNodes);
        return setupNodes;
    }

    public Optional<String> getNameFromDescriptor(Path xar) throws IOException, PackageException {
        Optional<DocumentImpl> doc = this.getDescriptor(xar);
        return doc.map(DocumentImpl::getDocumentElement).map(root -> root.getAttribute("name"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<DocumentImpl> getDescriptor(Path jar) throws IOException, PackageException {
        Throwable throwable = null;
        try (JarInputStream jis = new JarInputStream(Files.newInputStream(jar, new OpenOption[0]));){
            JarEntry entry;
            while ((entry = jis.getNextJarEntry()) != null) {
                if (entry.isDirectory() || !"expath-pkg.xml".equals(entry.getName())) continue;
                try {
                    Optional<DocumentImpl> optional = Optional.of(DocUtils.parse(this.broker.getBrokerPool(), null, jis));
                    return optional;
                }
                catch (XPathException e) {
                    try {
                        throw new PackageException("Error while parsing expath-pkg.xml: " + e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        return Optional.empty();
                    }
                }
            }
        }
    }

    private static class UpdatingDocumentReceiver
    extends DocumentBuilderReceiver {
        private final String time;
        private final Deque<String> stack = new ArrayDeque<String>();

        public UpdatingDocumentReceiver(MemTreeBuilder builder, String time) {
            super(builder, false);
            this.time = time;
        }

        @Override
        public void startElement(QName qname, AttrList attribs) {
            this.stack.push(qname.getLocalPart());
            AttrList newAttrs = attribs;
            if (attribs != null && "permissions".equals(qname.getLocalPart())) {
                newAttrs = new AttrList();
                for (int i = 0; i < attribs.getLength(); ++i) {
                    if ("password".equals(attribs.getQName(i).getLocalPart())) continue;
                    newAttrs.addAttribute(attribs.getQName(i), attribs.getValue(i), attribs.getType(i));
                }
            }
            if (!"deployed".equals(qname.getLocalPart())) {
                super.startElement(qname, newAttrs);
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            this.stack.push(localName);
            if (!"deployed".equals(localName)) {
                super.startElement(namespaceURI, localName, qName, attrs);
            }
        }

        @Override
        public void endElement(QName qname) throws SAXException {
            this.stack.pop();
            if ("meta".equals(qname.getLocalPart())) {
                this.addDeployTime();
            }
            if (!"deployed".equals(qname.getLocalPart())) {
                super.endElement(qname);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.stack.pop();
            if ("meta".equals(localName)) {
                this.addDeployTime();
            }
            if (!"deployed".equals(localName)) {
                super.endElement(uri, localName, qName);
            }
        }

        @Override
        public void attribute(QName qname, String value) throws SAXException {
            String current = this.stack.peek();
            if (!"permissions".equals(current) || !"password".equals(qname.getLocalPart())) {
                super.attribute(qname, value);
            }
        }

        @Override
        public void characters(char[] ch, int start, int len) throws SAXException {
            String current = this.stack.peek();
            if (!"deployed".equals(current)) {
                super.characters(ch, start, len);
            }
        }

        @Override
        public void characters(CharSequence seq) throws SAXException {
            String current = this.stack.peek();
            if (!"deployed".equals(current)) {
                super.characters(seq);
            }
        }

        private void addDeployTime() throws SAXException {
            super.startElement(DEPLOYED_ELEMENT, null);
            super.characters(this.time);
            super.endElement(DEPLOYED_ELEMENT);
        }
    }

    private static class RequestedPerms {
        final String user;
        final String password;
        final Optional<String> group;
        final Either<Integer, String> permissions;

        private RequestedPerms(String user, String password, Optional<String> group, Either<Integer, String> permissions) {
            this.user = user;
            this.password = password;
            this.group = group;
            this.permissions = permissions;
        }
    }
}

