/*
 * Decompiled with CFR 0.152.
 */
package org.exist.repo;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Optional;
import javax.xml.transform.Source;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.repo.ExistPkgExtension;
import org.exist.repo.ExistPkgInfo;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.util.Configuration;
import org.exist.util.FileUtils;
import org.exist.xquery.Module;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.expath.pkg.repo.Extension;
import org.expath.pkg.repo.FileSystemStorage;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Packages;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.URISpace;

public class ExistRepository
extends Observable
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(ExistRepository.class);
    public static final String EXPATH_REPO_DIR = "expathrepo";
    public static final String EXPATH_REPO_DEFAULT = "webapp/WEB-INF/expathrepo";
    private Path expathDir;
    private Repository myParent;

    @Override
    public void configure(Configuration configuration) throws BrokerPoolServiceException {
        Path dataDir = Optional.ofNullable((Path)configuration.getProperty("db-connection.data-dir")).orElse(Paths.get("data", new String[0]));
        this.expathDir = dataDir.resolve(EXPATH_REPO_DIR);
    }

    @Override
    public void prepare(BrokerPool brokerPool) throws BrokerPoolServiceException {
        if (!Files.exists(this.expathDir, new LinkOption[0])) {
            ExistRepository.moveOldRepo(brokerPool.getConfiguration().getExistHome(), this.expathDir);
        }
        try {
            Files.createDirectories(this.expathDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BrokerPoolServiceException("Unable to access EXPath repository", e);
        }
        LOG.info("Using directory " + this.expathDir.toAbsolutePath().toString() + " for expath package repository");
        try {
            FileSystemStorage storage = new FileSystemStorage(this.expathDir.toFile());
            storage.setErrorIfNoContentDir(false);
            this.myParent = new Repository((Storage)storage);
            this.myParent.registerExtension((Extension)new ExistPkgExtension());
        }
        catch (PackageException e) {
            throw new BrokerPoolServiceException("Unable to prepare EXPath Package Repository: " + this.expathDir.toAbsolutePath().toString(), e);
        }
    }

    public Repository getParentRepo() {
        return this.myParent;
    }

    public Module resolveJavaModule(String namespace, XQueryContext ctxt) throws XPathException {
        URI uri;
        try {
            uri = new URI(namespace);
        }
        catch (URISyntaxException ex) {
            throw new XPathException("Invalid URI: " + namespace, (Throwable)ex);
        }
        for (Packages pp : this.myParent.listPackages()) {
            String clazz;
            Package pkg = pp.latest();
            ExistPkgInfo info = (ExistPkgInfo)pkg.getInfo("exist");
            if (info == null || (clazz = info.getJava(uri)) == null) continue;
            return this.getModule(clazz, namespace, ctxt);
        }
        return null;
    }

    private Module getModule(String name, String namespace, XQueryContext ctxt) throws XPathException {
        try {
            ClassLoader existClassLoader = ctxt.getBroker().getBrokerPool().getClassLoader();
            Class<Module> clazz = Class.forName(name, false, existClassLoader);
            Module module = this.instantiateModule(clazz);
            String ns = module.getNamespaceURI();
            if (!ns.equals(namespace)) {
                throw new XPathException("The namespace in the Java module does not match the namespace in the package descriptor: " + namespace + " - " + ns);
            }
            return ctxt.loadBuiltInModule(namespace, name);
        }
        catch (ClassNotFoundException ex) {
            throw new XPathException("Cannot find module class from EXPath repository: " + name, (Throwable)ex);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new XPathException("Problem instantiating module class from EXPath repository: " + name, (Throwable)ex);
        }
        catch (ClassCastException ex) {
            throw new XPathException("The class configured in EXPath repository is not a Module: " + name, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new XPathException("Illegal argument passed to the module ctor", (Throwable)ex);
        }
    }

    private Module instantiateModule(Class<Module> clazz) throws XPathException, InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            Constructor<Module> ctor = clazz.getConstructor(Map.class);
            return ctor.newInstance(Collections.emptyMap());
        }
        catch (NoSuchMethodException ex) {
            try {
                Constructor<Module> ctor = clazz.getConstructor(new Class[0]);
                return ctor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException exx) {
                throw new XPathException("Cannot find suitable constructor for module from expath repository", (Throwable)exx);
            }
        }
    }

    public Path resolveXQueryModule(String namespace) throws XPathException {
        URI uri;
        try {
            uri = new URI(namespace);
        }
        catch (URISyntaxException ex) {
            throw new XPathException("Invalid URI: " + namespace, (Throwable)ex);
        }
        for (Packages pp : this.myParent.listPackages()) {
            String f;
            Package pkg = pp.latest();
            FileSystemStorage.FileSystemResolver resolver = (FileSystemStorage.FileSystemResolver)pkg.getResolver();
            ExistPkgInfo info = (ExistPkgInfo)pkg.getInfo("exist");
            if (info != null && (f = info.getXQuery(uri)) != null) {
                return resolver.resolveComponentAsFile(f).toPath();
            }
            String sysid = null;
            try {
                Source src = pkg.resolve(namespace, URISpace.XQUERY);
                if (src == null) continue;
                sysid = src.getSystemId();
                return Paths.get(new URI(sysid));
            }
            catch (URISyntaxException ex) {
                throw new XPathException("Error parsing the URI of the query library: " + sysid, (Throwable)ex);
            }
            catch (PackageException ex) {
                throw new XPathException("Error resolving the query library: " + namespace, (Throwable)ex);
            }
        }
        return null;
    }

    public List<URI> getJavaModules() {
        ArrayList<URI> modules = new ArrayList<URI>();
        for (Packages pp : this.myParent.listPackages()) {
            Package pkg = pp.latest();
            ExistPkgInfo info = (ExistPkgInfo)pkg.getInfo("exist");
            if (info == null) continue;
            modules.addAll(info.getJavaModules());
        }
        return modules;
    }

    public static Path getRepositoryDir(Configuration config) throws IOException {
        Path dataDir = Optional.ofNullable((Path)config.getProperty("db-connection.data-dir")).orElse(Paths.get("data", new String[0]));
        Path expathDir = dataDir.resolve(EXPATH_REPO_DIR);
        if (!Files.exists(expathDir, new LinkOption[0])) {
            ExistRepository.moveOldRepo(config.getExistHome(), expathDir);
        }
        Files.createDirectories(expathDir, new FileAttribute[0]);
        return expathDir;
    }

    private static void moveOldRepo(Optional<Path> home, Path newRepo) {
        Path repo_dir = home.map(h -> {
            if (FileUtils.fileName(h).equals("WEB-INF")) {
                return h.resolve(EXPATH_REPO_DIR);
            }
            return h.resolve(EXPATH_REPO_DEFAULT);
        }).orElse(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(EXPATH_REPO_DIR));
        if (Files.isReadable(repo_dir)) {
            LOG.info("Found old expathrepo directory. Moving to new default location: " + newRepo.toAbsolutePath().toString());
            try {
                Files.move(repo_dir, newRepo, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                LOG.error("Failed to move old expathrepo directory to new default location. Keeping it.", (Throwable)e);
            }
        }
    }

    public void reportAction(Action action, String packageURI) {
        this.notifyObservers(new Notification(action, packageURI));
        this.setChanged();
    }

    public static final class Notification {
        private final Action action;
        private final String packageURI;

        public Notification(Action action, String packageURI) {
            this.action = action;
            this.packageURI = packageURI;
        }

        public Action getAction() {
            return this.action;
        }

        public String getPackageURI() {
            return this.packageURI;
        }
    }

    public static enum Action {
        INSTALL,
        UNINSTALL;

    }
}

