/*
 * Decompiled with CFR 0.152.
 */
package org.exist.repo;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.repo.ExistRepository;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.lock.Lock;
import org.exist.util.FileUtils;
import org.exist.xmldb.XmldbURI;

public class RepoBackup {
    public static final String REPO_ARCHIVE = "expathrepo.zip";

    public static Path backup(DBBroker broker) throws IOException {
        Path tempFile = Files.createTempFile("expathrepo", "zip", new FileAttribute[0]);
        try (ZipOutputStream os = new ZipOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]));){
            Path directory = ExistRepository.getRepositoryDir(broker.getConfiguration());
            RepoBackup.zipDir(directory.toAbsolutePath(), os, "");
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restore(DBBroker broker) throws IOException, PermissionDeniedException {
        XmldbURI docPath = XmldbURI.createInternal("/db/expathrepo.zip");
        DocumentImpl doc = null;
        try {
            doc = broker.getXMLResource(docPath, Lock.LockMode.READ_LOCK);
            if (doc == null) {
                return;
            }
            if (doc.getResourceType() != 1) {
                throw new IOException(docPath + " is not a binary resource");
            }
            Path file = ((NativeBroker)broker).getCollectionBinaryFileFsPath(doc.getURI());
            Path directory = ExistRepository.getRepositoryDir(broker.getConfiguration());
            RepoBackup.unzip(file, directory);
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
    }

    public static void zipDir(Path directory, ZipOutputStream zos, String path) throws IOException {
        List<Path> dirList = FileUtils.list(directory);
        for (Path f : dirList) {
            if (Files.isDirectory(f, new LinkOption[0])) {
                RepoBackup.zipDir(f, zos, path + FileUtils.fileName(f) + "/");
                continue;
            }
            ZipEntry anEntry = new ZipEntry(path + FileUtils.fileName(f));
            zos.putNextEntry(anEntry);
            Files.copy(f, zos);
        }
    }

    public static void unzip(Path zipfile, Path outdir) throws IOException {
        try (ZipInputStream zin = new ZipInputStream(Files.newInputStream(zipfile, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory()) {
                    Files.createDirectories(outdir.resolve(name), new FileAttribute[0]);
                    continue;
                }
                String dir = RepoBackup.dirpart(name);
                if (dir != null) {
                    Files.createDirectories(outdir.resolve(name), new FileAttribute[0]);
                }
                Files.copy(zin, outdir.resolve(name), new CopyOption[0]);
            }
        }
    }

    private static String dirpart(String name) {
        int s = name.lastIndexOf(File.separatorChar);
        return s == -1 ? null : name.substring(0, s);
    }
}

