/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler;

import java.util.Properties;
import org.exist.scheduler.JobException;
import org.exist.scheduler.JobType;
import org.exist.util.Configuration;

public final class JobConfig {
    public static final String CONFIGURATION_ELEMENT_NAME = "scheduler";
    public static final String CONFIGURATION_JOB_ELEMENT_NAME = "job";
    public static final String JOB_TYPE_ATTRIBUTE = "type";
    public static final String JOB_CLASS_ATTRIBUTE = "class";
    public static final String JOB_XQUERY_ATTRIBUTE = "xquery";
    public static final String JOB_CRON_TRIGGER_ATTRIBUTE = "cron-trigger";
    public static final String JOB_PERIOD_ATTRIBUTE = "period";
    public static final String JOB_DELAY_ATTRIBUTE = "delay";
    public static final String JOB_REPEAT_ATTRIBUTE = "repeat";
    public static final String JOB_NAME_ATTRIBUTE = "name";
    public static final String JOB_UNSCHEDULE_ON_EXCEPTION = "unschedule-on-exception";
    public static final String PROPERTY_SCHEDULER_JOBS = "scheduler.jobs";
    private final JobType jobType;
    private final String jobName;
    private final String resourceName;
    private final String schedule;
    private final boolean unscheduleOnException;
    private long delay = -1L;
    private int repeat = -1;
    private final Properties parameters = new Properties();

    public JobConfig(JobType jobType, String jobName, String resourceName, String schedule, String unscheduleOnException) throws JobException {
        this.jobType = jobType != null ? jobType : JobType.USER;
        this.jobName = jobName;
        if (resourceName == null) {
            throw new JobException(JobException.JobExceptionAction.JOB_ABORT, "Job must have a resource for execution");
        }
        this.resourceName = resourceName;
        if (schedule == null) {
            throw new JobException(JobException.JobExceptionAction.JOB_ABORT, "Job must have a schedule");
        }
        this.schedule = schedule;
        this.unscheduleOnException = Configuration.parseBoolean(unscheduleOnException, true);
    }

    public JobType getType() {
        return this.jobType;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public boolean unscheduleOnException() {
        return this.unscheduleOnException;
    }
}

