/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler;

import java.util.Date;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class ScheduledJobInfo {
    private final Scheduler scheduler;
    private final Trigger trigger;

    public ScheduledJobInfo(Scheduler scheduler, Trigger trigger) {
        this.scheduler = scheduler;
        this.trigger = trigger;
    }

    public String getName() {
        return this.trigger.getJobKey().getName();
    }

    public String getGroup() {
        return this.trigger.getJobKey().getGroup();
    }

    public String getTriggerName() {
        return this.trigger.getKey().getName();
    }

    public Date getStartTime() {
        return this.trigger.getStartTime();
    }

    public Date getEndTime() {
        return this.trigger.getEndTime();
    }

    public Date getPreviousFireTime() {
        return this.trigger.getPreviousFireTime();
    }

    public Date getNextFireTime() {
        return this.trigger.getNextFireTime();
    }

    public Date getFinalFireTime() {
        return this.trigger.getFinalFireTime();
    }

    public String getTriggerExpression() {
        if (this.trigger instanceof CronTrigger) {
            return ((CronTrigger)this.trigger).getCronExpression();
        }
        if (this.trigger instanceof SimpleTrigger) {
            return String.valueOf(((SimpleTrigger)this.trigger).getRepeatInterval());
        }
        return null;
    }

    public TriggerState getTriggerState() {
        try {
            switch (this.scheduler.getTriggerState(this.trigger.getKey())) {
                case ERROR: {
                    return TriggerState.ERROR;
                }
                case NONE: {
                    return TriggerState.NONE;
                }
                case NORMAL: {
                    return TriggerState.NORMAL;
                }
                case PAUSED: {
                    return TriggerState.PAUSED;
                }
                case BLOCKED: {
                    return TriggerState.BLOCKED;
                }
                case COMPLETE: {
                    return TriggerState.COMPLETE;
                }
            }
            return TriggerState.ERROR;
        }
        catch (SchedulerException se) {
            return TriggerState.ERROR;
        }
    }

    public static enum TriggerState {
        ERROR,
        NONE,
        NORMAL,
        PAUSED,
        BLOCKED,
        COMPLETE;

    }
}

