/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler.impl;

import org.exist.scheduler.SystemTaskJob;
import org.exist.storage.BrokerPool;
import org.exist.storage.SystemTask;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class SystemTaskJobImpl
implements SystemTaskJob,
StatefulJob {
    private static final String JOB_GROUP = "eXist.System";
    private String name = "SystemTask";
    private SystemTask task = null;

    public SystemTaskJobImpl() {
    }

    public SystemTaskJobImpl(String jobName, SystemTask task) {
        this.task = task;
        this.name = jobName == null ? this.name + ": " + task.getClass().getName() : jobName;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public final String getGroup() {
        return JOB_GROUP;
    }

    protected SystemTask getSystemTask() {
        return this.task;
    }

    @Override
    public final void execute(JobExecutionContext jec) throws JobExecutionException {
        JobDataMap jobDataMap = jec.getJobDetail().getJobDataMap();
        BrokerPool pool = (BrokerPool)jobDataMap.get((Object)"database");
        SystemTask task = (SystemTask)jobDataMap.get((Object)"systemtask");
        if (pool == null || task == null) {
            JobExecutionException jaa = new JobExecutionException("SystemTaskJob Failed: BrokerPool or SystemTask was null! Unscheduling SystemTask", false);
            jaa.setUnscheduleAllTriggers(true);
            throw jaa;
        }
        pool.triggerSystemTask(task);
    }
}

