/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.config.annotation.ConfigurationFieldSettings;
import org.exist.config.annotation.ConfigurationReferenceBy;
import org.exist.security.AXSchemaType;
import org.exist.security.AbstractPrincipal;
import org.exist.security.AbstractRealm;
import org.exist.security.AbstractSubject;
import org.exist.security.Account;
import org.exist.security.Credential;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SchemaType;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;

@ConfigurationClass(value="")
public abstract class AbstractAccount
extends AbstractPrincipal
implements Account {
    @ConfigurationFieldAsElement(value="group")
    @ConfigurationReferenceBy(value="name")
    protected List<Group> groups = new ArrayList<Group>();
    private boolean accountLocked = false;
    @ConfigurationFieldAsElement(value="expired")
    private boolean accountExpired = false;
    private boolean credentialsExpired = false;
    @ConfigurationFieldAsElement(value="enabled")
    private boolean enabled = true;
    @ConfigurationFieldAsElement(value="umask")
    @ConfigurationFieldSettings(value="octalString")
    private int umask = 18;
    @ConfigurationFieldAsElement(value="metadata")
    private Map<String, String> metadata = new HashMap<String, String>();
    protected Credential _cred = null;
    protected boolean hasDbaRole = false;

    protected AbstractAccount(DBBroker broker, AbstractRealm realm, int id, String name) throws ConfigurationException {
        super(broker, realm, realm.collectionAccounts, id, name);
    }

    public AbstractAccount(AbstractRealm realm, Configuration configuration) throws ConfigurationException {
        super(realm, configuration);
    }

    public boolean checkCredentials(Object credentials) {
        return this._cred == null ? false : this._cred.check(credentials);
    }

    @Override
    public Group addGroup(String name) throws PermissionDeniedException {
        Group group = this.getRealm().getGroup(name);
        if (group == null) {
            group = this.getRealm().getSecurityManager().getGroup(name);
        }
        return this.addGroup(group);
    }

    protected final Group addGroup(Configuration conf) throws PermissionDeniedException {
        if (conf == null) {
            return null;
        }
        String name = conf.getProperty("name");
        if (name == null) {
            return null;
        }
        return this.addGroup(name);
    }

    @Override
    public Group addGroup(Group group) throws PermissionDeniedException {
        if (group == null) {
            return null;
        }
        Subject user = this.getDatabase().getActiveBroker().getCurrentSubject();
        group.assertCanModifyGroup(user);
        if (!this.groups.contains(group)) {
            this.groups.add(group);
            if ("dba".equals(group.getName())) {
                this.hasDbaRole = true;
            }
        }
        return group;
    }

    @Override
    public void setPrimaryGroup(Group group) throws PermissionDeniedException {
        Subject user = this.getDatabase().getActiveBroker().getCurrentSubject();
        group.assertCanModifyGroup(user);
        if (!this.groups.contains(group)) {
            this.addGroup(group);
        }
        Collections.sort(this.groups, (o1, o2) -> {
            if (o1.getName().equals(group.getName())) {
                return -1;
            }
            return 1;
        });
    }

    @Override
    public final void remGroup(String name) throws PermissionDeniedException {
        Subject subject = this.getDatabase().getActiveBroker().getCurrentSubject();
        for (Group group : this.groups) {
            if (!group.getName().equals(name)) continue;
            group.assertCanModifyGroup(subject);
            this.groups.remove(group);
            break;
        }
        if ("dba".equals(name)) {
            this.hasDbaRole = false;
        }
    }

    @Override
    public final void setGroups(String[] groups) {
    }

    @Override
    public String[] getGroups() {
        if (this.groups == null) {
            return new String[0];
        }
        int i = 0;
        String[] names = new String[this.groups.size()];
        for (Group role : this.groups) {
            names[i++] = role.getName();
        }
        return names;
    }

    @Override
    public int[] getGroupIds() {
        if (this.groups == null) {
            return new int[0];
        }
        int i = 0;
        int[] ids = new int[this.groups.size()];
        for (Group group : this.groups) {
            ids[i++] = group.getId();
        }
        return ids;
    }

    @Override
    public final boolean hasGroup(String name) {
        if (this.groups == null) {
            return false;
        }
        for (Group group : this.groups) {
            if (!group.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasDbaRole() {
        return this.hasDbaRole;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<account name=\"");
        buf.append(this.name);
        buf.append("\" ");
        buf.append("id=\"");
        buf.append(Integer.toString(this.id));
        buf.append("\"");
        buf.append(">");
        if (this.groups != null) {
            for (Group group : this.groups) {
                buf.append(group.toString());
            }
        }
        buf.append("</account>");
        return buf.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).flatMap(other -> {
            if (other instanceof AbstractSubject) {
                return Optional.of(((AbstractSubject)other).account);
            }
            if (other instanceof AbstractAccount) {
                return Optional.of((AbstractAccount)other);
            }
            return Optional.empty();
        }).map(otherAccount -> this.getRealm().equals(otherAccount.getRealm()) && this.name.equals(otherAccount.name)).orElse(false);
    }

    @Override
    public final String getPrimaryGroup() {
        Group defaultGroup = this.getDefaultGroup();
        if (defaultGroup != null) {
            return defaultGroup.getName();
        }
        return null;
    }

    @Override
    @Deprecated
    public Group getDefaultGroup() {
        if (this.groups != null && this.groups.size() > 0) {
            return this.groups.get(0);
        }
        return null;
    }

    @Override
    public String getUsername() {
        return this.getName();
    }

    @Override
    public boolean isAccountNonExpired() {
        return !this.accountExpired;
    }

    @Override
    public boolean isAccountNonLocked() {
        return !this.accountLocked;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return !this.credentialsExpired;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getMetadataValue(SchemaType schemaType) {
        return this.metadata.get(schemaType.getNamespace());
    }

    @Override
    public void setMetadataValue(SchemaType schemaType, String value) {
        this.metadata.put(schemaType.getNamespace(), value);
    }

    @Override
    public Set<SchemaType> getMetadataKeys() {
        HashSet<SchemaType> metadataKeys = new HashSet<SchemaType>();
        for (String key : this.metadata.keySet()) {
            if (AXSchemaType.valueOfNamespace(key) != null) {
                metadataKeys.add(AXSchemaType.valueOfNamespace(key));
                continue;
            }
            if (EXistSchemaType.valueOfNamespace(key) == null) continue;
            metadataKeys.add(EXistSchemaType.valueOfNamespace(key));
        }
        return metadataKeys;
    }

    @Override
    public void clearMetadata() {
        if (this.metadata != null) {
            this.metadata.clear();
        }
    }

    @Override
    public void assertCanModifyAccount(Account user) throws PermissionDeniedException {
        if (user == null) {
            throw new PermissionDeniedException("Unspecified User is not allowed to modify account '" + this.getName() + "'");
        }
        if (!user.hasDbaRole() && !user.getName().equals(this.getName())) {
            throw new PermissionDeniedException("User '" + user.getName() + "' is not allowed to modify account '" + this.getName() + "'");
        }
    }

    @Override
    public void setUserMask(int umask) {
        this.umask = umask;
    }

    @Override
    public int getUserMask() {
        return this.umask;
    }
}

