/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.Configurator;
import org.exist.config.Reference;
import org.exist.config.ReferenceImpl;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.config.annotation.ConfigurationReferenceBy;
import org.exist.security.AXSchemaType;
import org.exist.security.AbstractPrincipal;
import org.exist.security.AbstractRealm;
import org.exist.security.Account;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SchemaType;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.internal.GroupImpl;
import org.exist.storage.DBBroker;

@ConfigurationClass(value="")
public abstract class AbstractGroup
extends AbstractPrincipal
implements Comparable<Object>,
Group {
    private static final Logger LOG = LogManager.getLogger(AbstractGroup.class);
    @ConfigurationFieldAsElement(value="manager")
    @ConfigurationReferenceBy(value="name")
    private List<Reference<SecurityManager, Account>> managers = new ArrayList<Reference<SecurityManager, Account>>();
    @ConfigurationFieldAsElement(value="metadata")
    private Map<String, String> metadata = new HashMap<String, String>();

    public AbstractGroup(DBBroker broker, AbstractRealm realm, int id, String name, List<Account> managers) throws ConfigurationException {
        super(broker, realm, realm.collectionGroups, id, name);
        if (managers != null) {
            for (Account manager : managers) {
                this._addManager(manager);
            }
        }
    }

    public AbstractGroup(DBBroker broker, AbstractRealm realm, String name) throws ConfigurationException {
        super(broker, realm, realm.collectionGroups, -1, name);
    }

    public AbstractGroup(AbstractRealm realm, Configuration configuration) throws ConfigurationException {
        super(realm, configuration);
        if (this.configuration != null) {
            this.configuration = Configurator.configure(this, this.configuration);
        }
    }

    @Override
    public int compareTo(Object other) {
        if (!(other instanceof GroupImpl)) {
            throw new IllegalArgumentException("wrong type");
        }
        return this.name.compareTo(((GroupImpl)other).name);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<group name=\"");
        buf.append(this.name);
        buf.append("\" id=\"");
        buf.append(Integer.toString(this.id));
        buf.append("\">");
        try {
            for (Account manager : this.getManagers()) {
                buf.append("<manager name=\"").append(manager.getUsername()).append("\"/>");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            buf.append("<manager error=\"").append(e.getMessage()).append("\"/>");
        }
        buf.append("</group>");
        return buf.toString();
    }

    @Override
    public void assertCanModifyGroup(Account user) throws PermissionDeniedException {
        if (user == null) {
            throw new PermissionDeniedException("Unspecified Account is not allowed to modify group '" + this.getName() + "'");
        }
        if (!user.hasDbaRole() && !this.isManager(user)) {
            throw new PermissionDeniedException("Account '" + user.getName() + "' is not allowed to modify group '" + this.getName() + "'");
        }
    }

    @Override
    public boolean isManager(Account account) {
        for (Reference<SecurityManager, Account> manager : this.managers) {
            Account acc = manager.resolve();
            if (acc == null || !acc.equals(account)) continue;
            return true;
        }
        return false;
    }

    protected void _addManager(Account account) {
        for (Reference<SecurityManager, Account> manager : this.managers) {
            String refName = manager.getName();
            if (refName == null || !refName.equals(account.getName())) continue;
            return;
        }
        this.managers.add(new ReferenceImpl<SecurityManager, Account>(this.getRealm().getSecurityManager(), account, account.getName()));
    }

    @Override
    public void addManager(Account manager) throws PermissionDeniedException {
        Subject subject = this.getDatabase().getActiveBroker().getCurrentSubject();
        this.assertCanModifyGroup(subject);
        this._addManager(manager);
    }

    @Override
    public void addManagers(List<Account> managers) throws PermissionDeniedException {
        if (managers != null) {
            for (Account manager : managers) {
                this.addManager(manager);
            }
        }
    }

    public void addManager(String name) throws PermissionDeniedException {
        Subject subject = this.getDatabase().getActiveBroker().getCurrentSubject();
        this.assertCanModifyGroup(subject);
        for (Reference<SecurityManager, Account> ref : this.managers) {
            String refName = ref.getName();
            if (refName == null || !refName.equals(name)) continue;
            return;
        }
        this.managers.add(new ReferenceImpl<SecurityManager, String>(this.getRealm().getSecurityManager(), "getAccount", name));
    }

    @Override
    public List<Account> getManagers() {
        HashSet<Account> set = new HashSet<Account>();
        if (this.managers != null) {
            for (Reference<SecurityManager, Account> ref : this.managers) {
                Account acc = ref.resolve();
                if (acc != null) {
                    set.add(acc);
                    continue;
                }
                LOG.warn("Unable to resolve reference to group manager '" + ref.getName() + "' for group '" + this.getName() + "'");
            }
        }
        return new ArrayList<Account>(set);
    }

    @Override
    public void removeManager(Account account) throws PermissionDeniedException {
        Subject subject = this.getDatabase().getActiveBroker().getCurrentSubject();
        this.assertCanModifyGroup(subject);
        for (Reference<SecurityManager, Account> ref : this.managers) {
            Account acc = ref.resolve();
            if (!acc.getName().equals(account.getName())) continue;
            this.managers.remove(ref);
            break;
        }
    }

    public void setManagers(List<Reference<SecurityManager, Account>> managers) {
        this.managers = managers;
    }

    @Override
    public String getMetadataValue(SchemaType schemaType) {
        return this.metadata.get(schemaType.getNamespace());
    }

    @Override
    public void setMetadataValue(SchemaType schemaType, String value) {
        this.metadata.put(schemaType.getNamespace(), value);
    }

    @Override
    public Set<SchemaType> getMetadataKeys() {
        HashSet<SchemaType> metadataKeys = new HashSet<SchemaType>();
        for (String key : this.metadata.keySet()) {
            if (AXSchemaType.valueOfNamespace(key) != null) {
                metadataKeys.add(AXSchemaType.valueOfNamespace(key));
                continue;
            }
            if (EXistSchemaType.valueOfNamespace(key) == null) continue;
            metadataKeys.add(EXistSchemaType.valueOfNamespace(key));
        }
        return metadataKeys;
    }

    @Override
    public void clearMetadata() {
        this.metadata.clear();
    }
}

