/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.util.Optional;
import java.util.Set;
import org.exist.config.Configuration;
import org.exist.security.AbstractAccount;
import org.exist.security.Account;
import org.exist.security.Credential;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SchemaType;
import org.exist.security.Session;
import org.exist.security.Subject;
import org.exist.security.realm.Realm;
import org.exist.storage.DBBroker;

public abstract class AbstractSubject
implements Subject {
    protected final AbstractAccount account;
    protected final Session session;

    public AbstractSubject(AbstractAccount account) {
        this.account = account;
        this.session = new Session(this);
    }

    @Override
    public Group addGroup(String name) throws PermissionDeniedException {
        return this.account.addGroup(name);
    }

    @Override
    public Group addGroup(Group group) throws PermissionDeniedException {
        return this.account.addGroup(group);
    }

    @Override
    public void setPrimaryGroup(Group group) throws PermissionDeniedException {
        this.account.setPrimaryGroup(group);
    }

    @Override
    public void remGroup(String group) throws PermissionDeniedException {
        this.account.remGroup(group);
    }

    @Override
    public String[] getGroups() {
        return this.account.getGroups();
    }

    @Override
    public int[] getGroupIds() {
        return this.account.getGroupIds();
    }

    @Override
    public boolean hasDbaRole() {
        return this.account.hasDbaRole();
    }

    @Override
    public String getPrimaryGroup() {
        return this.account.getPrimaryGroup();
    }

    @Override
    public Group getDefaultGroup() {
        return this.account.getDefaultGroup();
    }

    @Override
    public boolean hasGroup(String group) {
        return this.account.hasGroup(group);
    }

    @Override
    public void setPassword(String passwd) {
        this.account.setPassword(passwd);
    }

    @Override
    public void setCredential(Credential credential) {
        this.account.setCredential(credential);
    }

    @Override
    public Realm getRealm() {
        return this.account.getRealm();
    }

    @Override
    public String getPassword() {
        return this.account.getPassword();
    }

    @Override
    public String getDigestPassword() {
        return this.account.getDigestPassword();
    }

    @Override
    public void setGroups(String[] groups) {
        this.account.setGroups(groups);
    }

    @Override
    public String getRealmId() {
        return this.account.getRealmId();
    }

    @Override
    public int getId() {
        return this.account.getId();
    }

    @Override
    public String getName() {
        return this.account.getName();
    }

    @Override
    public boolean isConfigured() {
        return this.account.isConfigured();
    }

    @Override
    public Configuration getConfiguration() {
        return this.account.getConfiguration();
    }

    @Override
    public String getUsername() {
        return this.account.getUsername();
    }

    @Override
    public boolean isAccountNonExpired() {
        return this.account.isAccountNonExpired();
    }

    @Override
    public boolean isAccountNonLocked() {
        return this.account.isAccountNonLocked();
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return this.account.isCredentialsNonExpired();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.account.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.account.isEnabled();
    }

    @Override
    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).flatMap(other -> other instanceof Account ? Optional.of((Account)other) : Optional.empty()).map(otherAccount -> this.account.equals(otherAccount)).orElse(false);
    }

    @Override
    public String getSessionId() {
        return this.session.getId();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void save() throws PermissionDeniedException {
    }

    @Override
    public void save(DBBroker broker) throws PermissionDeniedException {
    }

    @Override
    public String getMetadataValue(SchemaType schemaType) {
        return this.account.getMetadataValue(schemaType);
    }

    @Override
    public void setMetadataValue(SchemaType schemaType, String value) {
        this.account.setMetadataValue(schemaType, value);
    }

    @Override
    public Set<SchemaType> getMetadataKeys() {
        return this.account.getMetadataKeys();
    }

    @Override
    public void assertCanModifyAccount(Account user) throws PermissionDeniedException {
        this.account.assertCanModifyAccount(user);
    }

    @Override
    public void clearMetadata() {
        this.account.clearMetadata();
    }

    @Override
    public int getUserMask() {
        return this.account.getUserMask();
    }

    @Override
    public void setUserMask(int umask) {
        this.account.setUserMask(umask);
    }
}

