/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.util.SyntaxException;

public abstract class AbstractUnixStylePermission
implements Permission {
    private static final Logger LOG = LogManager.getLogger(AbstractUnixStylePermission.class);
    private static final Pattern unixSymbolicModePattern = Pattern.compile("((?:[augo]*(?:[+\\-=](?:[rstwx])+)+),?)+");
    private static final Pattern existSymbolicModePattern = Pattern.compile("(?:(?:user|group|other)=(?:[+-](?:read|write|execute),?)+)+");
    private static final Pattern simpleSymbolicModePattern = Pattern.compile("(?:(?:r|-)(?:w|-)(?:[xsS]|-)){2}(?:r|-)(?:w|-)(?:[xt]|-)");

    private void setUnixSymbolicMode(String symbolicMode) throws SyntaxException, PermissionDeniedException {
        String[] clauses;
        for (String clause : clauses = symbolicMode.split(",")) {
            String[] whoPerm = clause.split("[+\\-=]");
            int perm = 0;
            boolean uidgid = false;
            boolean sticky = false;
            block14: for (char c : whoPerm[1].toCharArray()) {
                switch (c) {
                    case 'r': {
                        perm |= 4;
                        continue block14;
                    }
                    case 'w': {
                        perm |= 2;
                        continue block14;
                    }
                    case 'x': {
                        perm |= 1;
                        continue block14;
                    }
                    case 's': {
                        uidgid = true;
                        continue block14;
                    }
                    case 't': {
                        sticky = true;
                        continue block14;
                    }
                    default: {
                        throw new SyntaxException("Unrecognised mode char '" + c + "'");
                    }
                }
            }
            char[] whoose = whoPerm[0].length() > 0 ? whoPerm[0].toCharArray() : new char[]{'a'};
            block15: for (char c : whoose) {
                switch (c) {
                    case 'a': {
                        int newMode = perm << 6 | perm << 3 | perm | (sticky ? 512 : 0) | (uidgid ? 3072 : 0);
                        if (clause.indexOf("+") > -1) {
                            this.setMode(this.getMode() | newMode);
                            continue block15;
                        }
                        if (clause.indexOf("-") > -1) {
                            this.setMode(this.getMode() & ~newMode);
                            continue block15;
                        }
                        if (clause.indexOf("=") <= -1) continue block15;
                        this.setMode(newMode);
                        continue block15;
                    }
                    case 'u': {
                        if (clause.indexOf("+") > -1) {
                            this.setOwnerMode(this.getOwnerMode() | perm);
                            if (!uidgid) continue block15;
                            this.setSetUid(true);
                            continue block15;
                        }
                        if (clause.indexOf("-") > -1) {
                            this.setOwnerMode(this.getOwnerMode() & ~perm);
                            if (!uidgid) continue block15;
                            this.setSetUid(false);
                            continue block15;
                        }
                        if (clause.indexOf("=") <= -1) continue block15;
                        this.setOwnerMode(perm);
                        if (!uidgid) continue block15;
                        this.setSetUid(true);
                        continue block15;
                    }
                    case 'g': {
                        if (clause.indexOf("+") > -1) {
                            this.setGroupMode(this.getGroupMode() | perm);
                            if (!uidgid) continue block15;
                            this.setSetGid(true);
                            continue block15;
                        }
                        if (clause.indexOf("-") > -1) {
                            this.setGroupMode(this.getGroupMode() & ~perm);
                            if (!uidgid) continue block15;
                            this.setSetGid(false);
                            continue block15;
                        }
                        if (clause.indexOf("=") <= -1) continue block15;
                        this.setGroupMode(perm);
                        if (!uidgid) continue block15;
                        this.setSetGid(true);
                        continue block15;
                    }
                    case 'o': {
                        if (clause.indexOf("+") > -1) {
                            this.setOtherMode(this.getOtherMode() | perm);
                            if (!sticky) continue block15;
                            this.setSticky(true);
                            continue block15;
                        }
                        if (clause.indexOf("-") > -1) {
                            this.setOtherMode(this.getOtherMode() & ~perm);
                            if (!sticky) continue block15;
                            this.setSticky(false);
                            continue block15;
                        }
                        if (clause.indexOf("=") <= -1) continue block15;
                        this.setOtherMode(perm);
                        if (!sticky) continue block15;
                        this.setSticky(true);
                        continue block15;
                    }
                    default: {
                        throw new SyntaxException("Unrecognised mode char '" + c + "'");
                    }
                }
            }
            perm = 0;
            uidgid = false;
            sticky = false;
        }
    }

    @Deprecated
    private void setExistSymbolicMode(String existSymbolicMode) throws SyntaxException, PermissionDeniedException {
        LOG.warn("Permission modes should not be set using this format '" + existSymbolicMode + "', consider using the UNIX symbolic mode instead");
        int shift = 0;
        int mode = this.getMode();
        for (String s : existSymbolicMode.toLowerCase().split("=|,")) {
            if (s.equalsIgnoreCase("user")) {
                shift = 6;
                continue;
            }
            if (s.equalsIgnoreCase("group")) {
                shift = 3;
                continue;
            }
            if (s.equalsIgnoreCase("other")) {
                shift = 0;
                continue;
            }
            int perm = 0;
            if (s.endsWith("read".toLowerCase())) {
                perm = 4;
            } else if (s.endsWith("write".toLowerCase())) {
                perm = 2;
            } else if (s.endsWith("execute".toLowerCase())) {
                perm = 1;
            } else {
                throw new SyntaxException("Unrecognised mode char '" + s + "'");
            }
            if (s.startsWith("+")) {
                mode |= perm << shift;
                continue;
            }
            if (s.startsWith("-")) {
                mode &= ~(perm << shift);
                continue;
            }
            throw new SyntaxException("Unrecognised mode char '" + s + "'");
        }
        this.setMode(mode);
    }

    private void setSimpleSymbolicMode(String simpleSymbolicMode) throws SyntaxException, PermissionDeniedException {
        this.setMode(AbstractUnixStylePermission.simpleSymbolicModeToInt(simpleSymbolicMode));
    }

    @Override
    public final void setMode(String modeStr) throws SyntaxException, PermissionDeniedException {
        Matcher simpleSymbolicModeMatcher = simpleSymbolicModePattern.matcher(modeStr);
        if (simpleSymbolicModeMatcher.matches()) {
            this.setSimpleSymbolicMode(modeStr);
        } else {
            Matcher unixSymbolicModeMatcher = unixSymbolicModePattern.matcher(modeStr);
            if (unixSymbolicModeMatcher.matches()) {
                this.setUnixSymbolicMode(modeStr);
            } else {
                Matcher existSymbolicModeMatcher = existSymbolicModePattern.matcher(modeStr);
                if (existSymbolicModeMatcher.matches()) {
                    this.setExistSymbolicMode(modeStr);
                } else {
                    throw new SyntaxException("Unknown mode String: " + modeStr);
                }
            }
        }
    }

    public static int simpleSymbolicModeToInt(String simpleModeStr) throws SyntaxException {
        int mode = 0;
        char[] modeArray = simpleModeStr.toCharArray();
        block8: for (int i = 0; i < modeArray.length; ++i) {
            char c = modeArray[i];
            int shift = i < 3 ? 6 : (i < 6 ? 3 : 0);
            switch (c) {
                case 'r': {
                    mode |= 4 << shift;
                    continue block8;
                }
                case 'w': {
                    mode |= 2 << shift;
                    continue block8;
                }
                case 'x': {
                    mode |= 1 << shift;
                    continue block8;
                }
                case 'S': 
                case 's': {
                    mode = i < 3 ? (mode |= 0x800) : (mode |= 0x400);
                    if (c != 's') continue block8;
                    mode |= 1 << shift;
                    continue block8;
                }
                case '\u0001': {
                    mode |= 0x200;
                    continue block8;
                }
                case '-': {
                    continue block8;
                }
                default: {
                    throw new SyntaxException("Unrecognised mode char '" + c + "'");
                }
            }
        }
        return mode;
    }

    public static String modeToSimpleSymbolicMode(int mode) {
        char[] ch = new char[]{(mode & 0x100) == 0 ? (char)'-' : 'r', (mode & 0x80) == 0 ? (char)'-' : 'w', (mode & 0x40) == 0 ? (char)'-' : 'x', (mode & 0x20) == 0 ? (char)'-' : 'r', (mode & 0x10) == 0 ? (char)'-' : 'w', (mode & 8) == 0 ? (char)'-' : 'x', (mode & 4) == 0 ? (char)'-' : 'r', (mode & 2) == 0 ? (char)'-' : 'w', (mode & 1) == 0 ? (char)'-' : 'x'};
        return String.valueOf(ch);
    }

    public static String typesToString(int types) {
        StringBuilder builder = new StringBuilder();
        if (types >> 8 > 0) {
            if ((types >> 8 & 4) == 4) {
                builder.append('r');
            } else {
                builder.append('-');
            }
            if ((types >> 8 & 2) == 2) {
                builder.append('w');
            } else {
                builder.append('-');
            }
            if ((types >> 8 & 1) == 1) {
                builder.append('x');
            } else {
                builder.append('-');
            }
        }
        if (types >> 4 > 0) {
            if ((types >> 4 & 4) == 4) {
                builder.append('r');
            } else {
                builder.append('-');
            }
            if ((types >> 4 & 2) == 2) {
                builder.append('w');
            } else {
                builder.append('-');
            }
            if ((types >> 4 & 1) == 1) {
                builder.append('x');
            } else {
                builder.append('-');
            }
        }
        if ((types & 4) == 4) {
            builder.append('r');
        } else {
            builder.append('-');
        }
        if ((types & 2) == 2) {
            builder.append('w');
        } else {
            builder.append('-');
        }
        if ((types & 1) == 1) {
            builder.append('x');
        } else {
            builder.append('-');
        }
        return builder.toString();
    }
}

