/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.io.IOException;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.util.SyntaxException;

public interface Permission {
    public static final int DEFAULT_COLLECTION_PERM = 511;
    public static final int DEFAULT_RESOURCE_PERM = 438;
    public static final int DEFAULT_UMASK = 18;
    public static final int DEFAULT_SYSTEM_COLLECTION_PERM = 493;
    public static final int DEFAULT_SYSTSEM_RESOURCE_PERM = 504;
    public static final int DEFAULT_SYSTEM_ETC_COLLECTION_PERM = 493;
    public static final int DEFAULT_SYSTEM_SECURITY_COLLECTION_PERM = 504;
    public static final int DEFAULT_TEMPORARY_DOCUMENT_PERM = 505;
    public static final int SET_UID = 4;
    public static final int SET_GID = 2;
    public static final int STICKY = 1;
    public static final int READ = 4;
    public static final int WRITE = 2;
    public static final int EXECUTE = 1;
    public static final String USER_STRING = "user";
    public static final String GROUP_STRING = "group";
    public static final String OTHER_STRING = "other";
    public static final String READ_STRING = "read";
    public static final String WRITE_STRING = "write";
    public static final String EXECUTE_STRING = "execute";
    public static final char SETUID_CHAR = 's';
    public static final char SETUID_CHAR_NO_EXEC = 'S';
    public static final char SETGID_CHAR = 's';
    public static final char SETGID_CHAR_NO_EXEC = 'S';
    public static final char STICKY_CHAR = 't';
    public static final char STICKY_CHAR_NO_EXEC = 'T';
    public static final char READ_CHAR = 'r';
    public static final char WRITE_CHAR = 'w';
    public static final char EXECUTE_CHAR = 'x';
    public static final char UNSET_CHAR = '-';
    public static final char ALL_CHAR = 'a';
    public static final char USER_CHAR = 'u';
    public static final char GROUP_CHAR = 'g';
    public static final char OTHER_CHAR = 'o';

    public int getGroupMode();

    public Account getOwner();

    public Group getGroup();

    public int getMode();

    public int getOtherMode();

    public int getOwnerMode();

    public void setGroup(int var1) throws PermissionDeniedException;

    public void setGroup(Group var1) throws PermissionDeniedException;

    public void setGroup(String var1) throws PermissionDeniedException;

    public void setGroupFrom(Permission var1) throws PermissionDeniedException;

    public void setGroupMode(int var1) throws PermissionDeniedException;

    public void setOwner(int var1) throws PermissionDeniedException;

    public void setOwner(Account var1) throws PermissionDeniedException;

    public void setOwner(String var1) throws PermissionDeniedException;

    public void setMode(String var1) throws SyntaxException, PermissionDeniedException;

    public void setMode(int var1) throws PermissionDeniedException;

    public void setOtherMode(int var1) throws PermissionDeniedException;

    public void setOwnerMode(int var1) throws PermissionDeniedException;

    public boolean isSetUid();

    public boolean isSetGid();

    public boolean isSticky();

    public void setSetUid(boolean var1) throws PermissionDeniedException;

    public void setSetGid(boolean var1) throws PermissionDeniedException;

    public void setSticky(boolean var1) throws PermissionDeniedException;

    public boolean validate(Subject var1, int var2);

    public void write(VariableByteOutputStream var1) throws IOException;

    public void read(VariableByteInput var1) throws IOException;

    public boolean isCurrentSubjectDBA();

    public boolean isCurrentSubjectOwner();

    public boolean isCurrentSubjectInGroup();

    public boolean isCurrentSubjectInGroup(int var1);
}

