/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import com.evolvedbinary.j8fu.function.ConsumerE;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.SimpleACLPermission;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;

public class PermissionFactory {
    private static final Logger LOG = LogManager.getLogger(PermissionFactory.class);

    public static Permission getDefaultResourcePermission(SecurityManager sm) {
        Subject currentSubject = sm.getDatabase().getActiveBroker().getCurrentSubject();
        int mode = 0x1B6 & ~currentSubject.getUserMask();
        return new SimpleACLPermission(sm, currentSubject.getId(), currentSubject.getDefaultGroup().getId(), mode);
    }

    public static Permission getDefaultCollectionPermission(SecurityManager sm) {
        Subject currentSubject = sm.getDatabase().getActiveBroker().getCurrentSubject();
        int mode = 0x1FF & ~currentSubject.getUserMask();
        return new SimpleACLPermission(sm, currentSubject.getId(), currentSubject.getDefaultGroup().getId(), mode);
    }

    public static Permission getPermission(SecurityManager sm, int mode) {
        Subject currentSubject = sm.getDatabase().getActiveBroker().getCurrentSubject();
        return new SimpleACLPermission(sm, currentSubject.getId(), currentSubject.getDefaultGroup().getId(), mode);
    }

    public static Permission getPermission(SecurityManager sm, int userId, int groupId, int mode) {
        return new SimpleACLPermission(sm, userId, groupId, mode);
    }

    public static Permission getPermission(SecurityManager sm, String userName, String groupName, int mode) {
        SimpleACLPermission permission = null;
        try {
            Account owner = sm.getAccount(userName);
            if (owner == null) {
                throw new IllegalArgumentException("User was not found '" + (userName == null ? "" : userName) + "'");
            }
            Group group = sm.getGroup(groupName);
            if (group == null) {
                throw new IllegalArgumentException("Group was not found '" + (userName == null ? "" : groupName) + "'");
            }
            permission = new SimpleACLPermission(sm, owner.getId(), group.getId(), mode);
        }
        catch (Throwable ex) {
            LOG.error("Exception while instantiating security permission class.", ex);
        }
        return permission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePermissions(DBBroker broker, XmldbURI pathUri, ConsumerE<Permission, PermissionDeniedException> permissionModifier) throws PermissionDeniedException {
        block25: {
            TransactionManager transact = broker.getBrokerPool().getTransactionManager();
            try (Txn transaction = transact.beginTransaction();){
                Collection collection = null;
                try {
                    collection = broker.openCollection(pathUri, Lock.LockMode.WRITE_LOCK);
                    if (collection == null) {
                        DocumentImpl doc = null;
                        try {
                            doc = broker.getXMLResource(pathUri, Lock.LockMode.WRITE_LOCK);
                            if (doc == null) {
                                transact.abort(transaction);
                                throw new XPathException("Resource or collection '" + pathUri.toString() + "' does not exist.");
                            }
                            transaction.acquireLock(doc.getUpdateLock(), Lock.LockMode.WRITE_LOCK);
                            Permission permissions = doc.getPermissions();
                            permissionModifier.accept((Object)permissions);
                            broker.storeXMLResource(transaction, doc);
                        }
                        finally {
                            if (doc != null) {
                                doc.getUpdateLock().release(Lock.LockMode.WRITE_LOCK);
                            }
                        }
                        transact.commit(transaction);
                        broker.flush();
                        break block25;
                    }
                    transaction.acquireLock(collection.getLock(), Lock.LockMode.WRITE_LOCK);
                    Permission permissions = collection.getPermissionsNoLock();
                    permissionModifier.accept((Object)permissions);
                    broker.saveCollection(transaction, collection);
                    transact.commit(transaction);
                    broker.flush();
                }
                finally {
                    if (collection != null) {
                        collection.release(Lock.LockMode.WRITE_LOCK);
                    }
                }
            }
            catch (IOException | TriggerException | PermissionDeniedException | TransactionException | LockException | XPathException e) {
                throw new PermissionDeniedException("Permission to modify permissions is denied for user '" + broker.getCurrentSubject().getName() + "' on '" + pathUri.toString() + "': " + e.getMessage(), e);
            }
        }
    }
}

