/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.util.Collection;
import java.util.List;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.config.Configurable;
import org.exist.config.ConfigurationException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.Account;
import org.exist.security.AuthenticationException;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Session;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.xmldb.XmldbURI;

public interface SecurityManager
extends Configurable {
    public static final XmldbURI SECURITY_COLLECTION_URI = XmldbURI.SYSTEM_COLLECTION_URI.append("security");
    public static final XmldbURI CONFIG_FILE_URI = XmldbURI.create("config.xml");
    public static final XmldbURI ACCOUNTS_COLLECTION_URI = XmldbURI.create("accounts");
    public static final XmldbURI GROUPS_COLLECTION_URI = XmldbURI.create("groups");
    public static final XmldbURI REMOVED_COLLECTION_URI = XmldbURI.create("removed");
    public static final String SYSTEM = "SYSTEM";
    public static final String DBA_GROUP = "dba";
    public static final String DBA_USER = "admin";
    public static final String GUEST_GROUP = "guest";
    public static final String GUEST_USER = "guest";

    public void attach(DBBroker var1) throws EXistException;

    public Database getDatabase();

    public Database database();

    public Account getAccount(int var1);

    public boolean hasAccount(String var1);

    public Account addAccount(Account var1) throws PermissionDeniedException, EXistException;

    public Account addAccount(DBBroker var1, Account var2) throws PermissionDeniedException, EXistException;

    public boolean deleteAccount(String var1) throws PermissionDeniedException, EXistException;

    public boolean deleteAccount(Account var1) throws PermissionDeniedException, EXistException;

    public boolean updateAccount(Account var1) throws PermissionDeniedException, EXistException;

    public boolean updateGroup(Group var1) throws PermissionDeniedException, EXistException;

    public Account getAccount(String var1);

    public Group addGroup(DBBroker var1, Group var2) throws PermissionDeniedException, EXistException;

    @Deprecated
    public void addGroup(DBBroker var1, String var2) throws PermissionDeniedException, EXistException;

    public boolean hasGroup(String var1);

    public boolean hasGroup(Group var1);

    public Group getGroup(String var1);

    public Group getGroup(int var1);

    public boolean deleteGroup(String var1) throws PermissionDeniedException, EXistException;

    public boolean hasAdminPrivileges(Account var1);

    public Subject authenticate(String var1, Object var2) throws AuthenticationException;

    public Subject getSystemSubject();

    public Subject getGuestSubject();

    public Group getDBAGroup();

    public List<Account> getGroupMembers(String var1);

    @Deprecated
    public Collection<Account> getUsers();

    @Deprecated
    public Collection<Group> getGroups();

    public void registerSession(Session var1);

    @Deprecated
    public Subject getSubjectBySessionId(String var1);

    public void addGroup(int var1, Group var2);

    public void addUser(int var1, Account var2);

    public boolean hasGroup(int var1);

    public boolean hasUser(int var1);

    public List<String> findUsernamesWhereNameStarts(String var1);

    public List<String> findUsernamesWhereUsernameStarts(String var1);

    public List<String> findAllGroupNames();

    public List<String> findAllUserNames();

    public List<String> findGroupnamesWhereGroupnameStarts(String var1);

    public List<String> findAllGroupMembers(String var1);

    public void processPramatter(DBBroker var1, DocumentImpl var2) throws ConfigurationException;

    public void processPramatterBeforeSave(DBBroker var1, DocumentImpl var2) throws ConfigurationException;

    public String getAuthenticationEntryPoint();

    public List<String> findGroupnamesWhereGroupnameContains(String var1);

    public List<String> findUsernamesWhereNamePartStarts(String var1);

    @Deprecated
    public Subject getCurrentSubject();

    public void preAllocateAccountId(PrincipalIdReceiver var1) throws PermissionDeniedException, EXistException;

    public void preAllocateGroupId(PrincipalIdReceiver var1) throws PermissionDeniedException, EXistException;

    public static interface PrincipalIdReceiver {
        public void allocate(int var1);
    }
}

