/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.security.AbstractUnixStylePermission;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.PermissionRequired;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;

public class UnixStylePermission
extends AbstractUnixStylePermission
implements Permission {
    public static final Logger LOG = LogManager.getLogger(SecurityManager.class);
    protected final SecurityManager sm;
    protected long vector = this.encodeAsBitVector(1048575, 1048575, 0);

    public UnixStylePermission(SecurityManager sm) {
        if (sm == null) {
            throw new IllegalArgumentException("Security manager can't be null");
        }
        this.sm = sm;
    }

    protected UnixStylePermission(SecurityManager sm, long vector) {
        if (sm == null) {
            throw new IllegalArgumentException("Security manager can't be null");
        }
        this.sm = sm;
        this.vector = vector;
    }

    public UnixStylePermission(SecurityManager sm, int ownerId, int groupId, int mode) {
        this(sm);
        this.vector = this.encodeAsBitVector(ownerId, groupId, mode);
    }

    @Override
    public Account getOwner() {
        int id = this.getOwnerId();
        Account account = this.sm.getAccount(id);
        if (account == null) {
            LOG.fatal("Detected a Security Database corruption. Could not find account for id: {}.", (Object)id);
            return this.sm.getSystemSubject();
        }
        return account;
    }

    private int getOwnerId() {
        return (int)(this.vector >>> 32);
    }

    @Override
    public void setOwner(Account account) {
        int accountId;
        if (account == null) {
            account = this.sm.getSystemSubject();
        }
        if ((accountId = account.getId()) != this.getOwnerId()) {
            this.setOwnerId(accountId);
        }
    }

    @Override
    public void setOwner(int id) {
        int accountId;
        Account account = this.sm.getAccount(id);
        if (account == null) {
            account = this.sm.getSystemSubject();
        }
        if ((accountId = account.getId()) != this.getOwnerId()) {
            this.setOwnerId(accountId);
        }
    }

    @Override
    public void setOwner(String name) {
        int accountId;
        Account account = this.sm.getAccount(name);
        if (account != null && (accountId = account.getId()) != this.getOwnerId()) {
            this.setOwnerId(accountId);
        }
    }

    @PermissionRequired(user=4)
    private void setOwnerId(int ownerId) {
        this.vector = (long)ownerId << 32 | this.vector & 0xFFFFFFFFL;
    }

    @Override
    public Group getGroup() {
        int id = this.getGroupId();
        Group group = this.sm.getGroup(id);
        if (group == null) {
            LOG.fatal("Detected a Security Database corruption. Could not find group for id: {}.", (Object)id);
            return this.sm.getDBAGroup();
        }
        return group;
    }

    private int getGroupId() {
        return (int)(this.vector >>> 8 & 0xFFFFFL);
    }

    @Override
    public void setGroup(String groupName) {
        Group group = this.sm.getGroup(groupName);
        if (group != null) {
            this.setGroupId(group.getId());
        }
    }

    @Override
    public void setGroup(Group group) {
        if (group != null) {
            this.setGroupId(group.getId());
        }
    }

    @Override
    public void setGroup(int id) {
        Group group = this.sm.getGroup(id);
        if (group == null) {
            group = this.sm.getDBAGroup();
        }
        this.setGroupId(group.getId());
    }

    @PermissionRequired(user=6)
    private void setGroupId(@PermissionRequired(user=44) int groupId) {
        this._setGroupId(groupId);
    }

    @Override
    @PermissionRequired(user=6)
    public void setGroupFrom(@PermissionRequired(mode=1) Permission other) {
        this._setGroupId(other.getGroup().getId());
    }

    private void _setGroupId(int groupId) {
        this.vector = this.vector >>> 28 << 28 | (long)(groupId << 8) | this.vector & 0xFFL;
    }

    @Override
    public int getMode() {
        return (int)((this.vector >>> 31 & 1L) << 11 | (this.vector >>> 7 & 1L) << 10 | (this.vector >>> 3 & 1L) << 9 | ((this.vector >>> 28 & 7L) << 6 | (this.vector >>> 4 & 7L) << 3 | this.vector & 7L));
    }

    @Override
    @PermissionRequired(user=6)
    public final void setMode(int mode) {
        this.vector = this.vector >>> 32 << 32 | (long)(mode >>> 11 & 1) << 31 | (long)((mode >>> 6 & 7) << 28) | (this.vector >>> 8 & 0xFFFFFL) << 8 | (long)((mode >>> 10 & 1) << 7) | (long)((mode >>> 3 & 7) << 4) | (long)((mode >>> 9 & 1) << 3) | (long)(mode & 7);
    }

    @Override
    public boolean isSetUid() {
        return (this.vector >>> 31 & 1L) == 1L;
    }

    @Override
    @PermissionRequired(user=6)
    public void setSetUid(boolean setUid) {
        this.vector = (this.vector >>> 32 << 1 | (long)(setUid ? 1 : 0)) << 31 | this.vector & Integer.MAX_VALUE;
    }

    @Override
    public boolean isSetGid() {
        return (this.vector >>> 7 & 1L) == 1L;
    }

    @Override
    @PermissionRequired(user=6)
    public void setSetGid(boolean setGid) {
        this.vector = (this.vector >>> 8 << 1 | (long)(setGid ? 1 : 0)) << 7 | this.vector & 0x7FL;
    }

    @Override
    public boolean isSticky() {
        return (this.vector >>> 3 & 1L) == 1L;
    }

    @Override
    @PermissionRequired(user=6)
    public void setSticky(boolean sticky) {
        this.vector = (this.vector >>> 4 << 1 | (long)(sticky ? 1 : 0)) << 3 | this.vector & 7L;
    }

    @Override
    public int getOwnerMode() {
        return (int)(this.vector >>> 28 & 7L);
    }

    @Override
    @PermissionRequired(user=6)
    public void setOwnerMode(int mode) {
        this.vector = this.vector >>> 31 << 31 | (long)((mode &= 7) << 28) | this.vector & 0xFFFFFFFL;
    }

    @Override
    public int getGroupMode() {
        return (int)(this.vector >>> 4 & 7L);
    }

    @Override
    @PermissionRequired(user=6)
    public void setGroupMode(int mode) {
        this.vector = this.vector >>> 7 << 7 | (long)((mode &= 7) << 4) | this.vector & 0xFL;
    }

    @Override
    public int getOtherMode() {
        return (int)(this.vector & 7L);
    }

    @Override
    @PermissionRequired(user=6)
    public void setOtherMode(int mode) {
        this.vector = this.vector >>> 3 << 3 | (long)(mode &= 7);
    }

    public String toString() {
        char[] cArray = new char[9];
        cArray[0] = (this.vector & 0x40000000L) == 0L ? 45 : 114;
        int n = cArray[1] = (this.vector & 0x20000000L) == 0L ? 45 : 119;
        cArray[2] = (this.vector & 0x80000000L) == 0L ? ((this.vector & 0x10000000L) == 0L ? 45 : 120) : ((this.vector & 0x10000000L) == 0L ? 83 : 115);
        cArray[3] = (this.vector & 0x40L) == 0L ? 45 : 114;
        int n2 = cArray[4] = (this.vector & 0x20L) == 0L ? 45 : 119;
        cArray[5] = (this.vector & 0x80L) == 0L ? ((this.vector & 0x10L) == 0L ? 45 : 120) : ((this.vector & 0x10L) == 0L ? 83 : 115);
        cArray[6] = (this.vector & 4L) == 0L ? 45 : 114;
        int n3 = cArray[7] = (this.vector & 2L) == 0L ? 45 : 119;
        cArray[8] = (this.vector & 8L) == 0L ? ((this.vector & 1L) == 0L ? 45 : 120) : ((this.vector & 1L) == 0L ? 84 : 116);
        char[] ch = cArray;
        return String.valueOf(ch);
    }

    @Override
    public boolean validate(Subject user, int mode) {
        if (user.hasDbaRole()) {
            return true;
        }
        if ((long)user.getId() == this.vector >>> 32) {
            return ((long)mode & (this.vector >>> 28 & 7L)) == (long)mode;
        }
        int[] userGroupIds = user.getGroupIds();
        int groupId = (int)(this.vector >>> 8 & 0xFFFFFL);
        for (int userGroupId : userGroupIds) {
            if (userGroupId != groupId) continue;
            return ((long)mode & (this.vector >>> 4 & 7L)) == (long)mode;
        }
        return ((long)mode & (this.vector & 7L)) == (long)mode;
    }

    @Override
    public void read(VariableByteInput istream) throws IOException {
        this.vector = istream.readLong();
    }

    @Override
    public void write(VariableByteOutputStream ostream) throws IOException {
        ostream.writeLong(this.vector);
    }

    protected final long getVector() {
        return this.vector;
    }

    protected final long encodeAsBitVector(int userId, int groupId, int mode) {
        userId &= 0xFFFFF;
        groupId &= 0xFFFFF;
        int setUid = (mode &= 0xFFF) >>> 11 & 1;
        int setGid = mode >>> 10 & 1;
        int sticky = mode >>> 9 & 1;
        int userPerm = mode >>> 6 & 7;
        int groupPerm = mode >>> 3 & 7;
        int otherPerm = mode & 7;
        return (long)userId << 32 | (long)setUid << 31 | (long)(userPerm << 28) | (long)(groupId << 8) | (long)(setGid << 7) | (long)(groupPerm << 4) | (long)(sticky << 3) | (long)otherPerm;
    }

    protected Subject getCurrentSubject() {
        return this.sm.getDatabase().getActiveBroker().getCurrentSubject();
    }

    @Override
    public boolean isCurrentSubjectDBA() {
        return this.getCurrentSubject().hasDbaRole();
    }

    @Override
    public boolean isCurrentSubjectOwner() {
        return this.getCurrentSubject().getId() == this.getOwnerId();
    }

    @Override
    public boolean isCurrentSubjectInGroup() {
        int groupId = this.getGroupId();
        for (int currentSubjectGroupId : this.getCurrentSubject().getGroupIds()) {
            if (groupId != currentSubjectGroupId) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCurrentSubjectInGroup(int groupId) {
        for (int currentSubjectGroupId : this.getCurrentSubject().getGroupIds()) {
            if (currentSubjectGroupId != groupId) continue;
            return true;
        }
        return false;
    }

    public UnixStylePermission copy() {
        return new UnixStylePermission(this.sm, this.vector);
    }
}

