/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.Reference;
import org.exist.config.ReferenceImpl;
import org.exist.security.AXSchemaType;
import org.exist.security.AbstractAccount;
import org.exist.security.AbstractPrincipal;
import org.exist.security.AbstractRealm;
import org.exist.security.Account;
import org.exist.security.AuthenticationException;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.UUIDGenerator;
import org.exist.security.internal.AccountImpl;
import org.exist.security.internal.GroupImpl;
import org.exist.security.internal.SecurityManagerImpl;
import org.exist.security.internal.SubjectImpl;
import org.exist.security.internal.aider.UserAider;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;

public class RealmImpl
extends AbstractRealm {
    public static String ID = "exist";
    private static final Logger LOG = LogManager.getLogger(RealmImpl.class);
    public static final int SYSTEM_ACCOUNT_ID = 1048575;
    public static final int ADMIN_ACCOUNT_ID = 1048574;
    public static final int GUEST_ACCOUNT_ID = 1048573;
    public static final int UNKNOWN_ACCOUNT_ID = 1048572;
    public static final int INITIAL_LAST_ACCOUNT_ID = 10;
    public static final int DBA_GROUP_ID = 1048575;
    public static final int GUEST_GROUP_ID = 1048574;
    public static final int UNKNOWN_GROUP_ID = 1048573;
    public static final int INITIAL_LAST_GROUP_ID = 10;
    protected final AccountImpl ACCOUNT_SYSTEM;
    protected final AccountImpl ACCOUNT_UNKNOWN;
    protected final GroupImpl GROUP_DBA;
    protected final GroupImpl GROUP_GUEST;
    protected final GroupImpl GROUP_UNKNOWN;
    private static final String DEFAULT_ADMIN_PASSWORD = "";
    private static final String DEFAULT_GUEST_PASSWORD = "guest";
    public boolean allowGuestAuthentication = true;

    public static void setPasswordRealm(String value) {
        ID = value;
    }

    protected RealmImpl(DBBroker broker, final SecurityManagerImpl sm, Configuration config) throws ConfigurationException {
        super(sm, config);
        sm.lastUserId = 10;
        sm.lastGroupId = 10;
        this.GROUP_DBA = new GroupImpl(broker, this, 1048575, "dba");
        this.GROUP_DBA.setManagers((List<Reference<SecurityManager, Account>>)new ArrayList<Reference<SecurityManager, Account>>(){
            {
                this.add(new ReferenceImpl<SecurityManagerImpl, String>(sm, "getAccount", "admin"));
            }
        });
        this.GROUP_DBA.setMetadataValue(EXistSchemaType.DESCRIPTION, "Database Administrators");
        sm.addGroup(this.GROUP_DBA.getId(), (Group)this.GROUP_DBA);
        this.registerGroup(this.GROUP_DBA);
        this.ACCOUNT_SYSTEM = new AccountImpl(broker, this, 1048575, "SYSTEM", DEFAULT_ADMIN_PASSWORD, this.GROUP_DBA, true);
        this.ACCOUNT_SYSTEM.setMetadataValue(AXSchemaType.FULLNAME, "SYSTEM");
        this.ACCOUNT_SYSTEM.setMetadataValue(EXistSchemaType.DESCRIPTION, "System Internals");
        sm.addUser(this.ACCOUNT_SYSTEM.getId(), this.ACCOUNT_SYSTEM);
        this.registerAccount(this.ACCOUNT_SYSTEM);
        this.GROUP_GUEST = new GroupImpl(broker, this, 1048574, DEFAULT_GUEST_PASSWORD);
        this.GROUP_GUEST.setManagers((List<Reference<SecurityManager, Account>>)new ArrayList<Reference<SecurityManager, Account>>(){
            {
                this.add(new ReferenceImpl<SecurityManagerImpl, String>(sm, "getAccount", "admin"));
            }
        });
        this.GROUP_GUEST.setMetadataValue(EXistSchemaType.DESCRIPTION, "Anonymous Users");
        sm.addGroup(this.GROUP_GUEST.getId(), (Group)this.GROUP_GUEST);
        this.registerGroup(this.GROUP_GUEST);
        this.GROUP_UNKNOWN = new GroupImpl(broker, this, 1048573, DEFAULT_ADMIN_PASSWORD);
        this.ACCOUNT_UNKNOWN = new AccountImpl(broker, this, 1048572, DEFAULT_ADMIN_PASSWORD, null, this.GROUP_UNKNOWN);
    }

    @Override
    public void start(DBBroker broker) throws EXistException {
        block2: {
            super.start(broker);
            try {
                this.createAdminAndGuestIfNotExist(broker);
            }
            catch (PermissionDeniedException pde) {
                boolean exportOnly = broker.getConfiguration().getProperty("db-connection.emergency", false);
                if (exportOnly) break block2;
                throw new EXistException(pde.getMessage(), pde);
            }
        }
    }

    private void createAdminAndGuestIfNotExist(DBBroker broker) throws EXistException, PermissionDeniedException {
        if (this.getSecurityManager().getAccount(1048574) == null) {
            UserAider actAdmin = new UserAider(1048574, this.getId(), "admin");
            actAdmin.setPassword(DEFAULT_ADMIN_PASSWORD);
            actAdmin.setMetadataValue(AXSchemaType.FULLNAME, "admin");
            actAdmin.setMetadataValue(EXistSchemaType.DESCRIPTION, "System Administrator");
            actAdmin.addGroup("dba");
            this.getSecurityManager().addAccount(broker, actAdmin);
        }
        if (this.getSecurityManager().getAccount(1048573) == null) {
            UserAider actGuest = new UserAider(1048573, this.getId(), DEFAULT_GUEST_PASSWORD);
            actGuest.setMetadataValue(AXSchemaType.FULLNAME, DEFAULT_GUEST_PASSWORD);
            actGuest.setMetadataValue(EXistSchemaType.DESCRIPTION, "Anonymous User");
            actGuest.setPassword(DEFAULT_GUEST_PASSWORD);
            actGuest.addGroup(DEFAULT_GUEST_PASSWORD);
            this.getSecurityManager().addAccount(broker, actGuest);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean deleteAccount(Account account) throws PermissionDeniedException, EXistException {
        if (account == null) {
            return false;
        }
        this.usersByName.modify2E(principalDb -> {
            AbstractAccount remove_account = (AbstractAccount)principalDb.get(account.getName());
            if (remove_account == null) {
                throw new IllegalArgumentException("No such account exists!");
            }
            try (DBBroker broker = this.getDatabase().getBroker();){
                Subject user = broker.getCurrentSubject();
                if (!account.getName().equals(user.getName()) && !user.hasDbaRole()) {
                    throw new PermissionDeniedException("You are not allowed to delete '" + account.getName() + "' user");
                }
                remove_account.setRemoved(true);
                remove_account.setCollection(broker, this.collectionRemovedAccounts, XmldbURI.create(UUIDGenerator.getUUID() + ".xml"));
                TransactionManager transaction = this.getDatabase().getTransactionManager();
                try (Txn txn = transaction.beginTransaction();){
                    this.collectionAccounts.removeXMLResource(txn, broker, XmldbURI.create(remove_account.getName() + ".xml"));
                    transaction.commit(txn);
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
                this.getSecurityManager().addUser(remove_account.getId(), remove_account);
                principalDb.remove(remove_account.getName());
            }
        });
        return true;
    }

    @Override
    public boolean deleteGroup(Group group) throws PermissionDeniedException, EXistException {
        if (group == null) {
            return false;
        }
        this.groupsByName.modify2E(principalDb -> {
            AbstractPrincipal remove_group = (AbstractPrincipal)principalDb.get(group.getName());
            if (remove_group == null) {
                throw new IllegalArgumentException("Group does '" + group.getName() + "' not exist!");
            }
            DBBroker broker = this.getDatabase().getActiveBroker();
            Subject subject = broker.getCurrentSubject();
            ((Group)((Object)remove_group)).assertCanModifyGroup(subject);
            remove_group.setRemoved(true);
            remove_group.setCollection(broker, this.collectionRemovedGroups, XmldbURI.create(UUIDGenerator.getUUID() + ".xml"));
            TransactionManager transaction = this.getDatabase().getTransactionManager();
            try (Txn txn = transaction.beginTransaction();){
                this.collectionGroups.removeXMLResource(txn, broker, XmldbURI.create(remove_group.getName() + ".xml"));
                transaction.commit(txn);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            this.getSecurityManager().addGroup(remove_group.getId(), (Group)((Object)remove_group));
            principalDb.remove(remove_group.getName());
        });
        return true;
    }

    @Override
    public Subject authenticate(String accountName, Object credentials) throws AuthenticationException {
        Account account = this.getAccount(accountName);
        if (account == null) {
            throw new AuthenticationException(0, "Account '" + accountName + "' not found.");
        }
        if ("SYSTEM".equals(accountName) || !this.allowGuestAuthentication && DEFAULT_GUEST_PASSWORD.equals(accountName)) {
            throw new AuthenticationException(0, "Account '" + accountName + "' can not be used.");
        }
        if (!account.isEnabled()) {
            throw new AuthenticationException(2, "Account '" + accountName + "' is disabled.");
        }
        SubjectImpl subject = new SubjectImpl((AccountImpl)account, credentials);
        if (!subject.isAuthenticated()) {
            throw new AuthenticationException(1, "Wrong password for user [" + accountName + "] ");
        }
        return subject;
    }

    @Override
    public List<String> findUsernamesWhereUsernameStarts(String prefix) {
        return this.usersByName.read(principalDb -> principalDb.keySet().stream().filter(userName -> userName.startsWith(prefix)).collect(Collectors.toList()));
    }

    public List<String> findGroupnamesWhereGroupnameStarts(String prefix) {
        return this.groupsByName.read(principalDb -> principalDb.keySet().stream().filter(groupName -> groupName.startsWith(prefix)).collect(Collectors.toList()));
    }

    @Override
    public Collection<? extends String> findGroupnamesWhereGroupnameContains(String fragment) {
        return this.groupsByName.read(principalDb -> principalDb.keySet().stream().filter(groupName -> groupName.contains(fragment)).collect(Collectors.toList()));
    }

    @Override
    public List<String> findAllGroupNames() {
        return this.groupsByName.read(principalDb -> new ArrayList(principalDb.keySet()));
    }

    @Override
    public List<String> findAllUserNames() {
        return this.usersByName.read(principalDb -> new ArrayList(principalDb.keySet()));
    }

    @Override
    public List<String> findAllGroupMembers(String groupName) {
        return this.usersByName.read(principalDb -> principalDb.values().stream().filter(account -> account.hasGroup(groupName)).map(account -> account.getName()).collect(Collectors.toList()));
    }

    @Override
    public List<String> findUsernamesWhereNameStarts(String startsWith) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> findUsernamesWhereNamePartStarts(String startsWith) {
        return Collections.EMPTY_LIST;
    }
}

