/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.internal.web;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.security.Subject;

public class HttpAccount {
    private static final Logger LOG = LogManager.getLogger(HttpAccount.class);

    public static Subject getUserFromServletRequest(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        if (principal instanceof Subject) {
            return (Subject)principal;
        }
        if (principal != null && "org.eclipse.jetty.plus.jaas.JAASUserPrincipal".equals(principal.getClass().getName())) {
            try {
                Method method = principal.getClass().getMethod("getSubject", new Class[0]);
                Object obj = method.invoke((Object)principal, new Object[0]);
                if (obj instanceof javax.security.auth.Subject) {
                    javax.security.auth.Subject subject = (javax.security.auth.Subject)obj;
                    for (Principal _principal_ : subject.getPrincipals()) {
                        if (!(_principal_ instanceof Subject)) continue;
                        return (Subject)_principal_;
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.error((Object)e);
            }
        }
        return null;
    }
}

