/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.utils;

import org.exist.EXistException;
import org.exist.config.ConfigurationException;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.internal.RealmImpl;
import org.exist.security.internal.aider.GroupAider;
import org.exist.security.internal.aider.UserAider;
import org.exist.storage.DBBroker;
import org.exist.util.EXistInputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConverterFrom1_0 {
    public static final String LEGACY_USERS_DOCUMENT_PATH = "/db/system/users.xml";
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String PASS = "password";
    private static final String DIGEST_PASS = "digest-password";
    private static final String USER_ID = "uid";
    private static final String HOME = "home";

    public static void convert(EXistInputSource is) {
    }

    public static void convert(DBBroker broker, SecurityManager sm, Document acl) throws PermissionDeniedException, EXistException {
        Element docElement = null;
        if (acl != null) {
            docElement = acl.getDocumentElement();
        }
        if (docElement != null) {
            Element root = acl.getDocumentElement();
            Attr version = root.getAttributeNode("version");
            int major = 0;
            int minor = 0;
            if (version != null) {
                String[] numbers = version.getValue().split("\\.");
                major = Integer.parseInt(numbers[0]);
                minor = Integer.parseInt(numbers[1]);
            }
            NodeList nl = root.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node;
                int j;
                NodeList ul;
                if (nl.item(i).getNodeType() != 1) continue;
                Element next = (Element)nl.item(i);
                if ("users".equals(next.getTagName())) {
                    ul = next.getChildNodes();
                    for (j = 0; j < ul.getLength(); ++j) {
                        node = ul.item(j);
                        if (node.getNodeType() != 1 || !"user".equals(node.getLocalName())) continue;
                        Account account = ConverterFrom1_0.createAccount(major, minor, (Element)node);
                        if (sm.hasAccount(account.getName())) {
                            sm.updateAccount(account);
                            continue;
                        }
                        sm.addAccount(account);
                    }
                    continue;
                }
                if (!"groups".equals(next.getTagName())) continue;
                ul = next.getChildNodes();
                for (j = 0; j < ul.getLength(); ++j) {
                    node = ul.item(j);
                    if (node.getNodeType() != 1 || !GROUP.equals(node.getLocalName())) continue;
                    Group group = ConverterFrom1_0.createGroup((Element)node);
                    if (sm.hasGroup(group.getName())) {
                        sm.updateGroup(group);
                        continue;
                    }
                    sm.addGroup(broker, group);
                }
            }
        }
    }

    public static Account createAccount(int majorVersion, int minorVersion, Element node) throws ConfigurationException, DOMException, PermissionDeniedException {
        Attr userId;
        String password = null;
        Object digestPassword = null;
        int id = -1;
        Object home = null;
        String name = node.getAttribute(NAME);
        if (name == null) {
            throw new ConfigurationException("account needs a name");
        }
        if (majorVersion != 0) {
            Attr attr = node.getAttributeNode(PASS);
            String string = password = attr == null ? null : attr.getValue();
        }
        if ((userId = node.getAttributeNode(USER_ID)) == null) {
            throw new ConfigurationException("attribute id is missing");
        }
        try {
            id = Integer.parseInt(userId.getValue());
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("illegal user id: " + userId + " for account " + name);
        }
        if (id == 1 && password == null) {
            password = "";
        }
        UserAider new_account = new UserAider(RealmImpl.ID, name);
        new_account.setPassword(password);
        NodeList gl = node.getChildNodes();
        for (int i = 0; i < gl.getLength(); ++i) {
            Node group = gl.item(i);
            if (group.getNodeType() != 1 || !group.getLocalName().equals(GROUP)) continue;
            new_account.addGroup(group.getFirstChild().getNodeValue());
        }
        return new_account;
    }

    public static Group createGroup(Element element) {
        return new GroupAider(RealmImpl.ID, element.getAttribute(NAME));
    }
}

