/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.utils;

import java.io.IOException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;

public class Utils {
    public static Collection createCollection(DBBroker broker, Txn txn, XmldbURI uri) throws PermissionDeniedException, IOException, LockException, TriggerException {
        Collection collection = broker.getOrCreateCollection(txn, uri);
        if (collection == null) {
            throw new IOException("Collection " + uri + " cannot be created.");
        }
        collection.setPermissions(504);
        broker.saveCollection(txn, collection);
        return collection;
    }

    public static Collection getOrCreateCollection(DBBroker broker, Txn txn, XmldbURI collectionUri) throws PermissionDeniedException, IOException, LockException, TriggerException {
        Collection col = broker.getCollection(collectionUri);
        if (col == null) {
            col = Utils.createCollection(broker, txn, collectionUri);
        }
        return col;
    }
}

