/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.source.AbstractSource;
import org.exist.source.Source;
import org.exist.storage.DBBroker;

public class BinarySource
extends AbstractSource {
    private byte[] data;
    private boolean checkEncoding = false;
    private String encoding = "UTF-8";

    public BinarySource(byte[] data, boolean checkXQEncoding) {
        this.data = data;
        this.checkEncoding = checkXQEncoding;
    }

    @Override
    public String path() {
        return this.type();
    }

    @Override
    public String type() {
        return "Binary";
    }

    @Override
    public Object getKey() {
        return this.data;
    }

    @Override
    public Source.Validity isValid(DBBroker broker) {
        return Source.Validity.VALID;
    }

    @Override
    public Source.Validity isValid(Source other) {
        return Source.Validity.VALID;
    }

    @Override
    public Reader getReader() throws IOException {
        this.checkEncoding();
        return new InputStreamReader(this.getInputStream(), this.encoding);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public String getContent() throws IOException {
        this.checkEncoding();
        return new String(this.data, this.encoding);
    }

    private void checkEncoding() throws IOException {
        if (this.checkEncoding) {
            try (InputStream is = this.getInputStream();){
                String checkedEnc = BinarySource.guessXQueryEncoding(is);
                if (checkedEnc != null) {
                    this.encoding = checkedEnc;
                }
            }
        }
    }

    @Override
    public void validate(Subject subject, int perm) throws PermissionDeniedException {
    }
}

