/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.security.internal.aider.UnixStylePermissionAider;
import org.exist.source.AbstractSource;
import org.exist.source.Source;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;

public class DBSource
extends AbstractSource {
    private final BinaryDocument doc;
    private final XmldbURI key;
    private final long lastModified;
    private String encoding = "UTF-8";
    private final boolean checkEncoding;
    private final DBBroker broker;

    public DBSource(DBBroker broker, BinaryDocument doc, boolean checkXQEncoding) {
        this.broker = broker;
        this.doc = doc;
        this.key = doc.getURI();
        this.lastModified = doc.getMetadata().getLastModified();
        this.checkEncoding = checkXQEncoding;
    }

    @Override
    public String path() {
        return this.getDocumentPath().toString();
    }

    @Override
    public String type() {
        return "DB";
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public XmldbURI getDocumentPath() {
        return this.key;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source.Validity isValid(DBBroker broker) {
        Source.Validity result;
        DocumentImpl d = null;
        try {
            d = broker.getXMLResource(this.key, Lock.LockMode.READ_LOCK);
            result = d == null ? Source.Validity.INVALID : (d.getMetadata().getLastModified() > this.lastModified ? Source.Validity.INVALID : Source.Validity.VALID);
        }
        catch (PermissionDeniedException pde) {
            result = Source.Validity.INVALID;
        }
        finally {
            if (d != null) {
                d.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
        return result;
    }

    @Override
    public Source.Validity isValid(Source other) {
        Source.Validity result = !(other instanceof DBSource) ? Source.Validity.INVALID : (((DBSource)other).getLastModified() > this.lastModified ? Source.Validity.INVALID : Source.Validity.VALID);
        return result;
    }

    @Override
    public Reader getReader() throws IOException {
        InputStream is = this.broker.getBinaryResource(this.doc);
        BufferedInputStream bis = new BufferedInputStream(is);
        bis.mark(64);
        this.checkEncoding(bis);
        bis.reset();
        return new InputStreamReader((InputStream)bis, this.encoding);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.broker.getBinaryResource(this.doc);
    }

    @Override
    public String getContent() throws IOException {
        InputStream raw = this.broker.getBinaryResource(this.doc);
        long binaryLength = this.broker.getBinaryResourceSize(this.doc);
        if (binaryLength > Integer.MAX_VALUE) {
            throw new IOException("Resource too big to be read using this method.");
        }
        byte[] data = new byte[(int)binaryLength];
        raw.read(data);
        raw.close();
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        this.checkEncoding(is);
        return new String(data, this.encoding);
    }

    @Override
    public QName isModule() throws IOException {
        InputStream raw = this.broker.getBinaryResource(this.doc);
        long binaryLength = this.broker.getBinaryResourceSize(this.doc);
        if (binaryLength > Integer.MAX_VALUE) {
            throw new IOException("Resource too big to be read using this method.");
        }
        byte[] data = new byte[(int)binaryLength];
        raw.read(data);
        raw.close();
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        return DBSource.getModuleDecl(is);
    }

    private void checkEncoding(InputStream is) throws IOException {
        String checkedEnc;
        if (this.checkEncoding && (checkedEnc = DBSource.guessXQueryEncoding(is)) != null) {
            this.encoding = checkedEnc;
        }
    }

    public String toString() {
        return this.doc.getDocumentURI();
    }

    @Override
    public void validate(Subject subject, int mode) throws PermissionDeniedException {
        if (!this.doc.getPermissions().validate(subject, mode)) {
            String modeStr = new UnixStylePermissionAider(mode).toString();
            throw new PermissionDeniedException("Subject '" + subject.getName() + "' does not have '" + modeStr + "' access to resource '" + this.doc.getURI() + "'.");
        }
    }

    public Permission getPermissions() {
        return this.doc.getPermissions();
    }
}

