/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.source.ClassLoaderSource;
import org.exist.source.DBSource;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.source.URLSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.util.FileUtils;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.SAXException;

public class SourceFactory {
    private static final Logger LOG = LogManager.getLogger(SourceFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Source getSource(DBBroker broker, String contextPath, String location, boolean checkXQEncoding) throws IOException, PermissionDeniedException {
        void var4_26;
        Object var4_4 = null;
        if (location.startsWith("resource:")) {
            ClassLoaderSource classLoaderSource = new ClassLoaderSource(location);
            return var4_26;
        }
        if (contextPath != null && contextPath.startsWith("resource:")) {
            String conPathNoProtocol = contextPath.replace("resource:", "file://");
            String resolvedURL = new URL(new URL(conPathNoProtocol), location).toString();
            resolvedURL = resolvedURL.replaceFirst("file://", "resource:");
            ClassLoaderSource classLoaderSource = new ClassLoaderSource(resolvedURL);
            return var4_26;
        }
        if (location.startsWith("file:/") || !location.contains(":/")) {
            void var4_20;
            void var4_18;
            void var4_16;
            void var4_14;
            void var4_12;
            void var4_10;
            void var4_8;
            location = location.replaceAll("^(file:)?/*(.*)$", "$2");
            try {
                Path p = Paths.get(contextPath, location);
                if (Files.isReadable(p)) {
                    location = p.toUri().toASCIIString();
                    FileSource fileSource = new FileSource(p, checkXQEncoding);
                }
            }
            catch (InvalidPathException p) {
                // empty catch block
            }
            if (var4_8 == null) {
                try {
                    Path p2 = Paths.get(location, new String[0]);
                    if (Files.isReadable(p2)) {
                        location = p2.toUri().toASCIIString();
                        FileSource fileSource = new FileSource(p2, checkXQEncoding);
                    }
                }
                catch (InvalidPathException p2) {
                    // empty catch block
                }
            }
            if (var4_10 == null) {
                try {
                    Path p3 = Paths.get(contextPath, new String[0]).toAbsolutePath().resolve(location);
                    if (Files.isReadable(p3)) {
                        location = p3.toUri().toASCIIString();
                        FileSource fileSource = new FileSource(p3, checkXQEncoding);
                    }
                }
                catch (InvalidPathException p3) {
                    // empty catch block
                }
            }
            if (var4_12 == null) {
                try {
                    Path p4 = Paths.get("/" + location, new String[0]);
                    if (Files.isReadable(p4)) {
                        location = p4.toUri().toASCIIString();
                        FileSource fileSource = new FileSource(p4, checkXQEncoding);
                    }
                }
                catch (InvalidPathException p4) {
                    // empty catch block
                }
            }
            if (var4_14 == null) {
                try {
                    Path p5 = Paths.get(contextPath, new String[0]).resolveSibling(location);
                    if (Files.isReadable(p5)) {
                        location = p5.toUri().toASCIIString();
                        FileSource fileSource = new FileSource(p5, checkXQEncoding);
                    }
                }
                catch (InvalidPathException p5) {
                    // empty catch block
                }
            }
            if (var4_16 == null) {
                try {
                    Path p6 = null;
                    if (contextPath.startsWith("file:/")) {
                        try {
                            p6 = Paths.get(new URI(contextPath)).resolveSibling(location);
                        }
                        catch (URISyntaxException resolvedURL) {
                            // empty catch block
                        }
                    }
                    if (p6 == null) {
                        p6 = Paths.get(contextPath.replaceFirst("^file:/*(/.*)$", "$1"), new String[0]).resolveSibling(location);
                    }
                    if (Files.isReadable(p6)) {
                        location = p6.toUri().toASCIIString();
                        FileSource fileSource = new FileSource(p6, checkXQEncoding);
                    }
                }
                catch (InvalidPathException p6) {
                    // empty catch block
                }
            }
            if (var4_18 == null) {
                Path p7 = null;
                try {
                    p7 = FileUtils.resolve(BrokerPool.getInstance().getConfiguration().getExistHome(), location);
                    if (Files.isReadable(p7)) {
                        location = p7.toUri().toASCIIString();
                        FileSource fileSource = new FileSource(p7, checkXQEncoding);
                    }
                }
                catch (EXistException e) {
                    LOG.warn((Object)e);
                }
                catch (InvalidPathException e) {
                    // empty catch block
                }
            }
            if (var4_20 != null) return var4_26;
            throw new FileNotFoundException("cannot read module source from file at " + location + ". \n");
        }
        if (location.startsWith("xmldb:")) {
            DocumentImpl resource = null;
            try {
                XmldbURI pathUri = XmldbURI.create(location);
                resource = broker.getXMLResource(pathUri, Lock.LockMode.READ_LOCK);
                if (resource == null) return var4_26;
                if (resource.getResourceType() == 1) {
                    DBSource dBSource = new DBSource(broker, (BinaryDocument)resource, true);
                    return var4_26;
                }
                try {
                    StringSource stringSource = new StringSource(broker.getSerializer().serialize(resource));
                    return var4_26;
                }
                catch (SAXException e) {
                    throw new IOException(e.getMessage());
                }
            }
            finally {
                if (resource != null) {
                    resource.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                }
            }
        } else if (location.startsWith("resource:")) {
            ClassLoaderSource classLoaderSource = new ClassLoaderSource(location);
            return var4_26;
        } else {
            URL url = new URL(location);
            URLSource uRLSource = new URLSource(url);
        }
        return var4_26;
    }
}

